/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import javax.annotation.Nonnull;
import org.fest.swing.core.InputModifiers;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.TestTerminator;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class EmergencyAbortListener
implements AWTEventListener {
    private static final long EVENT_MASK = 8L;
    private final Toolkit toolkit;
    private final TestTerminator testTerminator;
    private int keyCode;
    private int modifiers;

    public static EmergencyAbortListener registerInToolkit() {
        EmergencyAbortListener listener = new EmergencyAbortListener(ToolkitProvider.instance().defaultToolkit());
        listener.register();
        return listener;
    }

    @VisibleForTesting
    EmergencyAbortListener(@Nonnull Toolkit toolkit) {
        if (toolkit == null) {
            EmergencyAbortListener.$$$reportNull$$$0(0);
        }
        this(toolkit, new TestTerminator());
    }

    @VisibleForTesting
    EmergencyAbortListener(@Nonnull Toolkit toolkit, @Nonnull TestTerminator testTerminator) {
        if (toolkit == null) {
            EmergencyAbortListener.$$$reportNull$$$0(1);
        }
        if (testTerminator == null) {
            EmergencyAbortListener.$$$reportNull$$$0(2);
        }
        this.keyCode = 65;
        this.modifiers = InputModifiers.unify(2, 1);
        this.testTerminator = testTerminator;
        this.toolkit = toolkit;
    }

    @VisibleForTesting
    void register() {
        this.removePrevious();
        this.toolkit.addAWTEventListener(this, 8L);
    }

    private void removePrevious() {
        AWTEventListener[] listeners;
        for (AWTEventListener listener : listeners = this.toolkit.getAWTEventListeners(8L)) {
            if (!(listener instanceof EmergencyAbortListener)) continue;
            this.toolkit.removeAWTEventListener(listener);
        }
    }

    public EmergencyAbortListener keyCombination(@Nonnull KeyPressInfo keyPressInfo) {
        if (keyPressInfo == null) {
            EmergencyAbortListener.$$$reportNull$$$0(3);
        }
        Preconditions.checkNotNull((Object)keyPressInfo);
        this.keyCode = keyPressInfo.keyCode();
        this.modifiers = InputModifiers.unify((int[])Preconditions.checkNotNull((Object)keyPressInfo.modifiers()));
        return this;
    }

    public void unregister() {
        this.toolkit.removeAWTEventListener(this);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event.getID() != 401) {
            return;
        }
        if (!(event instanceof KeyEvent)) {
            return;
        }
        KeyEvent e = (KeyEvent)event;
        if (e.getKeyCode() != this.keyCode) {
            return;
        }
        if (!InputModifiers.modifiersMatch(e, this.modifiers)) {
            return;
        }
        this.testTerminator.terminateTests();
    }

    @VisibleForTesting
    int keyCode() {
        return this.keyCode;
    }

    @VisibleForTesting
    int modifiers() {
        return this.modifiers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolkit";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testTerminator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPressInfo";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/core/EmergencyAbortListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "keyCombination";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

