/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.ObjectAssert;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentDragAndDrop;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Settings;
import org.fest.swing.driver.ComponentEnabledCondition;
import org.fest.swing.driver.ComponentPerformDefaultAccessibleActionTask;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.query.ComponentHasFocusQuery;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.query.ComponentVisibleQuery;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class ComponentDriver {
    private static final String ENABLED_PROPERTY = "enabled";
    private static final String SIZE_PROPERTY = "size";
    private static final String VISIBLE_PROPERTY = "visible";
    protected final Robot robot;
    private final ComponentDragAndDrop dragAndDrop;

    public ComponentDriver(@Nonnull Robot robot) {
        if (robot == null) {
            ComponentDriver.$$$reportNull$$$0(0);
        }
        this.robot = robot;
        this.dragAndDrop = new ComponentDragAndDrop(robot);
    }

    @RunsInEDT
    public void click(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(1);
        }
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.click(c);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(2);
        }
        if (button == null) {
            ComponentDriver.$$$reportNull$$$0(3);
        }
        this.click(c, button, 1);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseClickInfo mouseClickInfo) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(4);
        }
        if (mouseClickInfo == null) {
            ComponentDriver.$$$reportNull$$$0(5);
        }
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.click(c, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    public void doubleClick(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(6);
        }
        this.click(c, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClick(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(7);
        }
        this.click(c, MouseButton.RIGHT_BUTTON);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull MouseButton button, int times) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(8);
        }
        if (button == null) {
            ComponentDriver.$$$reportNull$$$0(9);
        }
        Preconditions.checkNotNull((Object)((Object)button));
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.click(c, button, times);
    }

    @RunsInEDT
    public void click(@Nonnull Component c, @Nonnull Point where) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(10);
        }
        if (where == null) {
            ComponentDriver.$$$reportNull$$$0(11);
        }
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.click(c, where);
    }

    @Nonnull
    protected Settings settings() {
        Settings settings = this.robot.settings();
        if (settings == null) {
            ComponentDriver.$$$reportNull$$$0(12);
        }
        return settings;
    }

    @RunsInEDT
    public void requireSize(@Nonnull Component c, @Nonnull Dimension size) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(13);
        }
        if (size == null) {
            ComponentDriver.$$$reportNull$$$0(14);
        }
        ((ObjectAssert)Assertions.assertThat((Object)ComponentSizeQuery.sizeOf(c)).as(ComponentDriver.propertyName(c, SIZE_PROPERTY))).isEqualTo((Object)size);
    }

    @RunsInEDT
    public void requireVisible(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(15);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c))).isTrue();
    }

    @RunsInEDT
    public void requireNotVisible(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(16);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentVisibleQuery.isVisible(c)).as(ComponentDriver.visibleProperty(c))).isFalse();
    }

    @Nonnull
    @RunsInEDT
    private static Description visibleProperty(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(17);
        }
        Description description = ComponentDriver.propertyName(c, VISIBLE_PROPERTY);
        if (description == null) {
            ComponentDriver.$$$reportNull$$$0(18);
        }
        return description;
    }

    @RunsInEDT
    public void requireFocused(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(19);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentHasFocusQuery.hasFocus(c)).as(ComponentDriver.requiredFocusedErrorMessage(c))).isTrue();
    }

    @Nonnull
    private static Description requiredFocusedErrorMessage(final Component c) {
        GuiLazyLoadingDescription guiLazyLoadingDescription = new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                String string = String.format("Expected component %s to have input focus", Formatting.format(c));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/ComponentDriver$1", "loadDescription"));
            }
        };
        if (guiLazyLoadingDescription == null) {
            ComponentDriver.$$$reportNull$$$0(20);
        }
        return guiLazyLoadingDescription;
    }

    @RunsInEDT
    public void requireEnabled(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(21);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c))).isTrue();
    }

    @RunsInEDT
    public void requireEnabled(@Nonnull Component c, @Nonnull Timeout timeout) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(22);
        }
        if (timeout == null) {
            ComponentDriver.$$$reportNull$$$0(23);
        }
        Pause.pause((Condition)ComponentEnabledCondition.untilIsEnabled(c), timeout);
    }

    @RunsInEDT
    public void requireDisabled(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(24);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)ComponentEnabledQuery.isEnabled(c)).as(ComponentDriver.enabledProperty(c))).isFalse();
    }

    @Nonnull
    @RunsInEDT
    private static Description enabledProperty(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(25);
        }
        Description description = ComponentDriver.propertyName(c, ENABLED_PROPERTY);
        if (description == null) {
            ComponentDriver.$$$reportNull$$$0(26);
        }
        return description;
    }

    @RunsInEDT
    public void pressAndReleaseKeys(@Nonnull Component c, int ... keyCodes) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(27);
        }
        if (keyCodes == null) {
            ComponentDriver.$$$reportNull$$$0(28);
        }
        Preconditions.checkNotNull((Object)keyCodes);
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.focusAndWaitForFocusGain(c);
        this.robot.pressAndReleaseKeys(keyCodes);
    }

    @RunsInEDT
    public void pressAndReleaseKey(@Nonnull Component c, @Nonnull KeyPressInfo keyPressInfo) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(29);
        }
        if (keyPressInfo == null) {
            ComponentDriver.$$$reportNull$$$0(30);
        }
        Preconditions.checkNotNull((Object)keyPressInfo);
        this.pressAndReleaseKey(c, keyPressInfo.keyCode(), keyPressInfo.modifiers());
    }

    @RunsInEDT
    public void pressAndReleaseKey(@Nonnull Component c, int keyCode, @Nonnull int[] modifiers) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(31);
        }
        if (modifiers == null) {
            ComponentDriver.$$$reportNull$$$0(32);
        }
        this.focusAndWaitForFocusGain(c);
        this.robot.pressAndReleaseKey(keyCode, modifiers);
    }

    @RunsInEDT
    public void pressKey(@Nonnull Component c, int keyCode) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(33);
        }
        this.focusAndWaitForFocusGain(c);
        this.robot.pressKey(keyCode);
    }

    @RunsInEDT
    public void releaseKey(@Nonnull Component c, int keyCode) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(34);
        }
        this.focusAndWaitForFocusGain(c);
        this.robot.releaseKey(keyCode);
    }

    @RunsInEDT
    public void focusAndWaitForFocusGain(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(35);
        }
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.focusAndWaitForFocusGain(c);
    }

    @RunsInEDT
    public void focus(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(36);
        }
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        this.robot.focus(c);
    }

    @RunsInEDT
    protected final void drag(@Nonnull Component c, @Nonnull Point where) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(37);
        }
        if (where == null) {
            ComponentDriver.$$$reportNull$$$0(38);
        }
        this.dragAndDrop.drag(c, where);
    }

    @RunsInEDT
    protected final void drop(@Nonnull Component c, @Nonnull Point where) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(39);
        }
        if (where == null) {
            ComponentDriver.$$$reportNull$$$0(40);
        }
        this.dragAndDrop.drop(c, where);
    }

    protected final void dragOver(@Nonnull Component c, @Nonnull Point where) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(41);
        }
        if (where == null) {
            ComponentDriver.$$$reportNull$$$0(42);
        }
        this.dragAndDrop.dragOver(c, where);
    }

    @RunsInCurrentThread
    protected final void performAccessibleActionOf(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(43);
        }
        ComponentPerformDefaultAccessibleActionTask.performDefaultAccessibleAction(c);
        this.robot.waitForIdle();
    }

    @RunsInCurrentThread
    protected final boolean waitForShowing(@Nonnull Component c, long timeout) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(44);
        }
        if (this.robot.isReadyForInput(c)) {
            return true;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.robot.isReadyForInput(c)) {
            Component invoker;
            if (c instanceof JPopupMenu && (invoker = ((JPopupMenu)c).getInvoker()) instanceof JMenu) {
                this.robot.jitter(invoker);
            }
            if (watch.isTimeOut()) {
                return false;
            }
            Pause.pause();
        }
        return true;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu invokePopupMenu(@Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(45);
        }
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(c);
        if (jPopupMenu == null) {
            ComponentDriver.$$$reportNull$$$0(46);
        }
        return jPopupMenu;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu invokePopupMenu(@Nonnull Component c, @Nonnull Point p) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(47);
        }
        if (p == null) {
            ComponentDriver.$$$reportNull$$$0(48);
        }
        Preconditions.checkNotNull((Object)p);
        ComponentDriver.checkInEdtEnabledAndShowing(c);
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(c, p);
        if (jPopupMenu == null) {
            ComponentDriver.$$$reportNull$$$0(49);
        }
        return jPopupMenu;
    }

    @RunsInEDT
    protected static void checkInEdtEnabledAndShowing(final @Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(50);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(c);
            }
        });
    }

    @Nonnull
    @RunsInEDT
    public static Description propertyName(final @Nonnull Component c, final @Nonnull String propertyName) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(51);
        }
        if (propertyName == null) {
            ComponentDriver.$$$reportNull$$$0(52);
        }
        GuiLazyLoadingDescription guiLazyLoadingDescription = new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                String string = String.format("%s - property:'%s'", Formatting.format(c), propertyName);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/ComponentDriver$3", "loadDescription"));
            }
        };
        if (guiLazyLoadingDescription == null) {
            ComponentDriver.$$$reportNull$$$0(53);
        }
        return guiLazyLoadingDescription;
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(@Nonnull Component c, @Nonnull Point p) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(54);
        }
        if (p == null) {
            ComponentDriver.$$$reportNull$$$0(55);
        }
        this.moveMouseIgnoringAnyError(c, p.x, p.y);
    }

    @RunsInEDT
    protected final void moveMouseIgnoringAnyError(@Nonnull Component c, int x, int y) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(56);
        }
        try {
            this.robot.moveMouse(c, x, y);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Nonnull
    @RunsInEDT
    public Font fontOf(final @Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(57);
        }
        Font result = GuiActionRunner.execute(new GuiQuery<Font>(){

            @Override
            @Nullable
            protected Font executeInEDT() {
                return c.getFont();
            }
        });
        Font font = (Font)Preconditions.checkNotNull((Object)result);
        if (font == null) {
            ComponentDriver.$$$reportNull$$$0(58);
        }
        return font;
    }

    @Nonnull
    @RunsInEDT
    public Color backgroundOf(final @Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(59);
        }
        Color result = GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            @Nullable
            protected Color executeInEDT() {
                return c.getBackground();
            }
        });
        Color color = (Color)Preconditions.checkNotNull((Object)result);
        if (color == null) {
            ComponentDriver.$$$reportNull$$$0(60);
        }
        return color;
    }

    @Nonnull
    @RunsInEDT
    public Color foregroundOf(final @Nonnull Component c) {
        if (c == null) {
            ComponentDriver.$$$reportNull$$$0(61);
        }
        Color result = GuiActionRunner.execute(new GuiQuery<Color>(){

            @Override
            @Nullable
            protected Color executeInEDT() {
                return c.getForeground();
            }
        });
        Color color = (Color)Preconditions.checkNotNull((Object)result);
        if (color == null) {
            ComponentDriver.$$$reportNull$$$0(62);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 18: 
            case 20: 
            case 26: 
            case 46: 
            case 49: 
            case 53: 
            case 58: 
            case 60: 
            case 62: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 18: 
            case 20: 
            case 26: 
            case 46: 
            case 49: 
            case 53: 
            case 58: 
            case 60: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseClickInfo";
                break;
            }
            case 11: 
            case 38: 
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 12: 
            case 18: 
            case 20: 
            case 26: 
            case 46: 
            case 49: 
            case 53: 
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/ComponentDriver";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = SIZE_PROPERTY;
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyCodes";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPressInfo";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 48: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/ComponentDriver";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "settings";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "visibleProperty";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFocusedErrorMessage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "enabledProperty";
                break;
            }
            case 46: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "invokePopupMenu";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyName";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "fontOf";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundOf";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "click";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doubleClick";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rightClick";
                break;
            }
            case 12: 
            case 18: 
            case 20: 
            case 26: 
            case 46: 
            case 49: 
            case 53: 
            case 58: 
            case 60: 
            case 62: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "requireSize";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "requireVisible";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requireNotVisible";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visibleProperty";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "requireFocused";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "requireEnabled";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "requireDisabled";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "enabledProperty";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "pressAndReleaseKeys";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "pressAndReleaseKey";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "pressKey";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "releaseKey";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "focusAndWaitForFocusGain";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "focus";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "drag";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "dragOver";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "performAccessibleActionOf";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "waitForShowing";
                break;
            }
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "invokePopupMenu";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkInEdtEnabledAndShowing";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "propertyName";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "moveMouseIgnoringAnyError";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "fontOf";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "backgroundOf";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "foregroundOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 18: 
            case 20: 
            case 26: 
            case 46: 
            case 49: 
            case 53: 
            case 58: 
            case 60: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

