/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.matcher.JButtonMatcher;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JFileChooserApproveButtonTextQuery;
import org.fest.swing.driver.JFileChooserCancelButtonTextQuery;
import org.fest.swing.driver.JFileChooserSelectFileTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JFileChooserDriver
extends JComponentDriver {
    private static final String APPROVE_BUTTON = "Approve";
    private static final String CANCEL_BUTTON = "Cancel";

    public JFileChooserDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JFileChooserDriver.$$$reportNull$$$0(0);
        }
        super(robot);
    }

    @RunsInEDT
    public void selectFile(@Nonnull JFileChooser fileChooser, @Nonnull File file) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JFileChooserDriver.$$$reportNull$$$0(2);
        }
        JFileChooserSelectFileTask.setSelectedFile(fileChooser, (File)Preconditions.checkNotNull((Object)file));
    }

    public void selectFiles(@Nonnull JFileChooser fileChooser, @Nonnull File[] files) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(3);
        }
        if (files == null) {
            JFileChooserDriver.$$$reportNull$$$0(4);
        }
        Preconditions.checkNotNull((Object)files);
        for (File file : (File[])Preconditions.checkNotNullOrEmpty((Object[])files)) {
            Preconditions.checkNotNull((Object)file);
        }
        JFileChooserSelectFileTask.setSelectedFiles(fileChooser, files);
    }

    @RunsInEDT
    public void setCurrentDirectory(final @Nonnull JFileChooser fileChooser, final @Nonnull File dir) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(5);
        }
        if (dir == null) {
            JFileChooserDriver.$$$reportNull$$$0(6);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(fileChooser);
                fileChooser.setCurrentDirectory(dir);
            }
        });
    }

    @RunsInEDT
    public JTextField fileNameTextBox(@Nonnull JFileChooser fileChooser) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(7);
        }
        return this.robot.finder().findByType(fileChooser, JTextField.class);
    }

    @RunsInEDT
    public void clickCancelButton(@Nonnull JFileChooser fileChooser) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(8);
        }
        this.click(this.cancelButton(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    public JButton cancelButton(@Nonnull JFileChooser fileChooser) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(9);
        }
        JButton jButton = this.findButton(fileChooser, CANCEL_BUTTON, JFileChooserCancelButtonTextQuery.cancelButtonText());
        if (jButton == null) {
            JFileChooserDriver.$$$reportNull$$$0(10);
        }
        return jButton;
    }

    @RunsInEDT
    public void clickApproveButton(@Nonnull JFileChooser fileChooser) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(11);
        }
        this.click(this.approveButton(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    public JButton approveButton(@Nonnull JFileChooser fileChooser) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(12);
        }
        JButton jButton = this.findButton(fileChooser, APPROVE_BUTTON, JFileChooserApproveButtonTextQuery.approveButtonTextFrom(fileChooser));
        if (jButton == null) {
            JFileChooserDriver.$$$reportNull$$$0(13);
        }
        return jButton;
    }

    @Nonnull
    @RunsInEDT
    private JButton findButton(@Nonnull JFileChooser fileChooser, @Nonnull String logicalName, @Nullable String text) {
        if (fileChooser == null) {
            JFileChooserDriver.$$$reportNull$$$0(14);
        }
        if (logicalName == null) {
            JFileChooserDriver.$$$reportNull$$$0(15);
        }
        JButton jButton = this.robot.finder().find((Container)fileChooser, JButtonMatcher.withText(text).andShowing());
        if (jButton == null) {
            JFileChooserDriver.$$$reportNull$$$0(16);
        }
        return jButton;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JFileChooserDriver";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JFileChooserDriver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelButton";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "approveButton";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentDirectory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fileNameTextBox";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clickCancelButton";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cancelButton";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clickApproveButton";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "approveButton";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

