/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.Map;
import javax.annotation.Nonnull;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Maps;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

final class JOptionPaneMessageTypes {
    private static final Map<Integer, String> messageMap = Maps.newHashMap();

    @Nonnull
    static String messageTypeAsText(int messageType) {
        if (messageMap.containsKey(messageType)) {
            String string = Preconditions.checkNotNullOrEmpty((String)messageMap.get(messageType));
            if (string == null) {
                JOptionPaneMessageTypes.$$$reportNull$$$0(0);
            }
            return string;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The message type <", messageType, "> is not valid"}));
    }

    private JOptionPaneMessageTypes() {
    }

    static {
        messageMap.put(0, "Error Message");
        messageMap.put(1, "Information Message");
        messageMap.put(2, "Warning Message");
        messageMap.put(3, "Question Message");
        messageMap.put(-1, "Plain Message");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/JOptionPaneMessageTypes", "messageTypeAsText"));
    }
}

