/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JProgressBar;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JProgressBarValueQuery;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.timing.Timeout;

final class JProgressBarWaitUntilValueIsEqualToExpectedTask {
    @RunsInEDT
    static void waitUntilValueIsEqualToExpected(final @Nonnull JProgressBar progressBar, final int expected, @Nonnull Timeout timeout) {
        if (progressBar == null) {
            JProgressBarWaitUntilValueIsEqualToExpectedTask.$$$reportNull$$$0(0);
        }
        if (timeout == null) {
            JProgressBarWaitUntilValueIsEqualToExpectedTask.$$$reportNull$$$0(1);
        }
        Pause.pause(new Condition(JProgressBarWaitUntilValueIsEqualToExpectedTask.untilValueIsEqualTo(progressBar, expected)){

            @Override
            public boolean test() {
                return JProgressBarValueQuery.valueOf(progressBar) == expected;
            }
        }, timeout);
    }

    private static Description untilValueIsEqualTo(final @Nonnull JProgressBar progressBar, final int expected) {
        if (progressBar == null) {
            JProgressBarWaitUntilValueIsEqualToExpectedTask.$$$reportNull$$$0(2);
        }
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                String string = String.format("value of %s to be equal to %d", Formatting.format(progressBar), expected);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@Nonnull method %s.%s must not return null", "org/fest/swing/driver/JProgressBarWaitUntilValueIsEqualToExpectedTask$2", "loadDescription"));
            }
        };
    }

    private JProgressBarWaitUntilValueIsEqualToExpectedTask() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressBar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
        }
        objectArray2[1] = "org/fest/swing/driver/JProgressBarWaitUntilValueIsEqualToExpectedTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "waitUntilValueIsEqualToExpected";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "untilValueIsEqualTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

