/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Insets;
import java.awt.Point;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.swing.JSlider;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Maps;
import org.fest.util.Preconditions;

public final class JSliderLocation {
    private static final Map<Integer, JSliderLocationStrategy> LOCATIONS = Maps.newHashMap();

    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JSlider slider, int value) {
        if (slider == null) {
            JSliderLocation.$$$reportNull$$$0(0);
        }
        JSliderLocationStrategy strategy = LOCATIONS.get(slider.getOrientation());
        Point point = strategy.locationForValue(slider, value);
        if (point == null) {
            JSliderLocation.$$$reportNull$$$0(1);
        }
        return point;
    }

    static {
        LOCATIONS.put(0, new JSliderHorizontalLocation());
        LOCATIONS.put(1, new JSliderVerticalLocation());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JSliderLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JSliderLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class JSliderLocationStrategy {
        private JSliderLocationStrategy() {
        }

        @Nonnull
        @RunsInCurrentThread
        final Point locationForValue(JSlider slider, int value) {
            Point center = new Point(slider.getWidth() / 2, slider.getHeight() / 2);
            int max = this.max(slider, (Insets)Preconditions.checkNotNull((Object)slider.getInsets()));
            int coordinate = (int)(this.percent(slider, value) * (float)max);
            if (!slider.getInverted()) {
                coordinate = max - coordinate;
            }
            Point point = this.update(center, coordinate);
            if (point == null) {
                JSliderLocationStrategy.$$$reportNull$$$0(0);
            }
            return point;
        }

        @RunsInCurrentThread
        abstract int max(@Nonnull JSlider var1, @Nonnull Insets var2);

        @Nonnull
        @RunsInCurrentThread
        abstract Point update(@Nonnull Point var1, int var2);

        @RunsInCurrentThread
        private float percent(@Nonnull JSlider slider, int value) {
            if (slider == null) {
                JSliderLocationStrategy.$$$reportNull$$$0(1);
            }
            int minimum = slider.getMinimum();
            int range = slider.getMaximum() - minimum;
            return (float)(value - minimum) / (float)range;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@Nonnull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/fest/swing/driver/JSliderLocation$JSliderLocationStrategy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "locationForValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/fest/swing/driver/JSliderLocation$JSliderLocationStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "percent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JSliderVerticalLocation
    extends JSliderLocationStrategy {
        private JSliderVerticalLocation() {
        }

        @Override
        @RunsInCurrentThread
        int max(@Nonnull JSlider slider, @Nonnull Insets insets) {
            if (slider == null) {
                JSliderVerticalLocation.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                JSliderVerticalLocation.$$$reportNull$$$0(1);
            }
            return slider.getHeight() - insets.top - insets.bottom - 1;
        }

        @Override
        @Nonnull
        @RunsInCurrentThread
        Point update(@Nonnull Point center, int coordinate) {
            if (center == null) {
                JSliderVerticalLocation.$$$reportNull$$$0(2);
            }
            Point point = new Point(center.x, coordinate);
            if (point == null) {
                JSliderVerticalLocation.$$$reportNull$$$0(3);
            }
            return point;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@Nonnull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "center";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/fest/swing/driver/JSliderLocation$JSliderVerticalLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/fest/swing/driver/JSliderLocation$JSliderVerticalLocation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "update";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "max";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JSliderHorizontalLocation
    extends JSliderLocationStrategy {
        private JSliderHorizontalLocation() {
        }

        @Override
        @RunsInCurrentThread
        int max(@Nonnull JSlider slider, @Nonnull Insets insets) {
            if (slider == null) {
                JSliderHorizontalLocation.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                JSliderHorizontalLocation.$$$reportNull$$$0(1);
            }
            return slider.getWidth() - insets.left - insets.right - 1;
        }

        @Override
        @Nonnull
        @RunsInCurrentThread
        Point update(@Nonnull Point center, int coordinate) {
            if (center == null) {
                JSliderHorizontalLocation.$$$reportNull$$$0(2);
            }
            Point point = new Point(coordinate, center.y);
            if (point == null) {
                JSliderHorizontalLocation.$$$reportNull$$$0(3);
            }
            return point;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@Nonnull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "slider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "center";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/fest/swing/driver/JSliderLocation$JSliderHorizontalLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/fest/swing/driver/JSliderLocation$JSliderHorizontalLocation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "update";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "max";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

