/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.data.TableCell;
import org.fest.util.Preconditions;

public final class JTableLocation {
    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTable table, int row, int column) {
        if (table == null) {
            JTableLocation.$$$reportNull$$$0(0);
        }
        Rectangle cellBounds = this.cellBounds(table, row, column);
        Point point = new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
        if (point == null) {
            JTableLocation.$$$reportNull$$$0(1);
        }
        return point;
    }

    @Nonnull
    @RunsInCurrentThread
    public Rectangle cellBounds(@Nonnull JTable table, @Nonnull TableCell cell) {
        if (table == null) {
            JTableLocation.$$$reportNull$$$0(2);
        }
        if (cell == null) {
            JTableLocation.$$$reportNull$$$0(3);
        }
        Rectangle rectangle = this.cellBounds(table, cell.row, cell.column);
        if (rectangle == null) {
            JTableLocation.$$$reportNull$$$0(4);
        }
        return rectangle;
    }

    @Nonnull
    @RunsInCurrentThread
    public Rectangle cellBounds(JTable table, int row, int column) {
        Rectangle rectangle = (Rectangle)Preconditions.checkNotNull((Object)table.getCellRect(row, column, false));
        if (rectangle == null) {
            JTableLocation.$$$reportNull$$$0(5);
        }
        return rectangle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTableLocation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTableLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pointAt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "cellBounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pointAt";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cellBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

