/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Preconditions;

final class JTableMatchingCellQuery {
    @Nonnull
    @RunsInEDT
    static TableCell cellWithValue(final @Nonnull JTable table, final @Nonnull TextMatcher matcher, final @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(1);
        }
        if (cellReader == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(2);
        }
        TableCell result = GuiActionRunner.execute(new GuiQuery<TableCell>(){

            @Override
            protected TableCell executeInEDT() {
                return JTableMatchingCellQuery.findMatchingCell(table, matcher, cellReader);
            }
        });
        TableCell tableCell = (TableCell)Preconditions.checkNotNull((Object)result);
        if (tableCell == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(3);
        }
        return tableCell;
    }

    @Nonnull
    @RunsInCurrentThread
    private static TableCell findMatchingCell(@Nonnull JTable table, @Nonnull TextMatcher matcher, @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(4);
        }
        if (matcher == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(5);
        }
        if (cellReader == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(6);
        }
        int rCount = table.getRowCount();
        int cCount = table.getColumnCount();
        for (int r = 0; r < rCount; ++r) {
            for (int c = 0; c < cCount; ++c) {
                if (!JTableMatchingCellQuery.cellHasValue(table, r, c, matcher, cellReader)) continue;
                TableCell tableCell = TableCell.row(r).column(c);
                if (tableCell == null) {
                    JTableMatchingCellQuery.$$$reportNull$$$0(7);
                }
                return tableCell;
            }
        }
        String msg = String.format("Unable to find cell matching %s %s", matcher.description(), matcher.formattedValues());
        throw ActionFailedException.actionFailure(msg);
    }

    @RunsInCurrentThread
    private static boolean cellHasValue(@Nonnull JTable table, int row, int column, @Nonnull TextMatcher matcher, @Nonnull JTableCellReader cellReader) {
        if (table == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(8);
        }
        if (matcher == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(9);
        }
        if (cellReader == null) {
            JTableMatchingCellQuery.$$$reportNull$$$0(10);
        }
        return matcher.isMatching(cellReader.valueAt(table, row, column));
    }

    private JTableMatchingCellQuery() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellReader";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTableMatchingCellQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTableMatchingCellQuery";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cellWithValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatchingCell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cellWithValue";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingCell";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cellHasValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

