/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTreeChildrenShowUpCondition;
import org.fest.swing.driver.JTreeClearSelectionTask;
import org.fest.swing.driver.JTreeEditableQuery;
import org.fest.swing.driver.JTreeExpandPathTask;
import org.fest.swing.driver.JTreeLocation;
import org.fest.swing.driver.JTreeMatchingPathQuery;
import org.fest.swing.driver.JTreeNodeTextQuery;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.driver.JTreeToggleExpandStateTask;
import org.fest.swing.driver.JTreeVerifySelectionTask;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.ArrayPreconditions;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

@InternalApi
public class JTreeDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTION_PROPERTY = "selection";
    private final JTreeLocation location;
    private final JTreePathFinder pathFinder;

    public JTreeDriver(@Nonnull Robot robot) {
        if (robot == null) {
            JTreeDriver.$$$reportNull$$$0(0);
        }
        super(robot);
        this.location = new JTreeLocation();
        this.pathFinder = new JTreePathFinder();
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(1);
        }
        Point p = this.scrollToRow(tree, row);
        this.robot.click((Component)tree, p);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree, int row, @Nonnull MouseButton button) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(2);
        }
        if (button == null) {
            JTreeDriver.$$$reportNull$$$0(3);
        }
        Preconditions.checkNotNull((Object)((Object)button));
        this.clickRow(tree, row, button, 1);
    }

    @RunsInEDT
    public void clickRow(@Nonnull JTree tree, int row, @Nonnull MouseClickInfo mouseClickInfo) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(4);
        }
        if (mouseClickInfo == null) {
            JTreeDriver.$$$reportNull$$$0(5);
        }
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.clickRow(tree, row, mouseClickInfo.button(), mouseClickInfo.times());
    }

    @RunsInEDT
    private void clickRow(@Nonnull JTree tree, int row, @Nonnull MouseButton button, int times) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(6);
        }
        if (button == null) {
            JTreeDriver.$$$reportNull$$$0(7);
        }
        Point p = this.scrollToRow(tree, row);
        this.robot.click(tree, p, button, times);
    }

    @RunsInEDT
    public void doubleClickRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(8);
        }
        Point p = this.scrollToRow(tree, row);
        this.doubleClick(tree, p);
    }

    @RunsInEDT
    public void rightClickRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(9);
        }
        Point p = this.scrollToRow(tree, row);
        this.rightClick(tree, p);
    }

    @Nonnull
    @RunsInEDT
    private Point scrollToRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(10);
        }
        Point p = (Point)JTreeDriver.scrollToRow((JTree)tree, (int)row, (JTreeLocation)this.location()).second;
        this.robot.waitForIdle();
        Point point = (Point)Preconditions.checkNotNull((Object)p);
        if (point == null) {
            JTreeDriver.$$$reportNull$$$0(11);
        }
        return point;
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(12);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(13);
        }
        Point p = this.scrollToPath(tree, path);
        this.robot.click((Component)tree, p);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree, @Nonnull String path, @Nonnull MouseButton button) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(14);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(15);
        }
        if (button == null) {
            JTreeDriver.$$$reportNull$$$0(16);
        }
        Preconditions.checkNotNull((Object)((Object)button));
        this.clickPath(tree, path, button, 1);
    }

    @RunsInEDT
    public void clickPath(@Nonnull JTree tree, @Nonnull String path, @Nonnull MouseClickInfo mouseClickInfo) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(17);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(18);
        }
        if (mouseClickInfo == null) {
            JTreeDriver.$$$reportNull$$$0(19);
        }
        Preconditions.checkNotNull((Object)mouseClickInfo);
        this.clickPath(tree, path, mouseClickInfo.button(), mouseClickInfo.times());
    }

    private void clickPath(@Nonnull JTree tree, @Nonnull String path, @Nonnull MouseButton button, int times) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(20);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(21);
        }
        if (button == null) {
            JTreeDriver.$$$reportNull$$$0(22);
        }
        Point p = this.scrollToPath(tree, path);
        this.robot.click(tree, p, button, times);
    }

    @RunsInEDT
    public void doubleClickPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(23);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(24);
        }
        Point p = this.scrollToPath(tree, path);
        this.doubleClick(tree, p);
    }

    @Nonnull
    private Point scrollToPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(25);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(26);
        }
        Point p = (Point)this.scrollToMatchingPath((JTree)tree, (String)path).third;
        this.robot.waitForIdle();
        Point point = (Point)Preconditions.checkNotNull((Object)p);
        if (point == null) {
            JTreeDriver.$$$reportNull$$$0(27);
        }
        return point;
    }

    private void doubleClick(@Nonnull JTree tree, @Nonnull Point p) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(28);
        }
        if (p == null) {
            JTreeDriver.$$$reportNull$$$0(29);
        }
        this.robot.click(tree, p, MouseButton.LEFT_BUTTON, 2);
    }

    @RunsInEDT
    public void rightClickPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(30);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(31);
        }
        Point p = this.scrollToPath(tree, path);
        this.rightClick(tree, p);
    }

    private void rightClick(@Nonnull JTree tree, @Nonnull Point p) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(32);
        }
        if (p == null) {
            JTreeDriver.$$$reportNull$$$0(33);
        }
        this.robot.click(tree, p, MouseButton.RIGHT_BUTTON, 1);
    }

    @RunsInEDT
    public void expandRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(34);
        }
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location());
        this.robot.waitForIdle();
        if (((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void collapseRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(35);
        }
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location());
        this.robot.waitForIdle();
        if (!((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void toggleRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(36);
        }
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToRowAndGetToggleInfo(tree, row, this.location());
        this.robot.waitForIdle();
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToRowAndGetToggleInfo(final @Nonnull JTree tree, final int row, final @Nonnull JTreeLocation location) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(37);
        }
        if (location == null) {
            JTreeDriver.$$$reportNull$$$0(38);
        }
        Triple<Boolean, Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                Point p = JTreeDriver.scrollToVisible(tree, row, location);
                return Triple.of(tree.isExpanded(row), p, tree.getToggleClickCount());
            }
        });
        Triple triple = (Triple)Preconditions.checkNotNull(result);
        if (triple == null) {
            JTreeDriver.$$$reportNull$$$0(39);
        }
        return triple;
    }

    @RunsInEDT
    public void expandPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(40);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(41);
        }
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree, path, this.pathFinder(), this.location());
        if (((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @RunsInEDT
    public void collapsePath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(42);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(43);
        }
        Triple<Boolean, Point, Integer> info = JTreeDriver.scrollToMatchingPathAndGetToggleInfo(tree, path, this.pathFinder(), this.location());
        if (!((Boolean)info.first).booleanValue()) {
            return;
        }
        this.toggleCell(tree, (Point)Preconditions.checkNotNull((Object)info.second), (Integer)info.third);
    }

    @Nonnull
    @RunsInEDT
    private static Triple<Boolean, Point, Integer> scrollToMatchingPathAndGetToggleInfo(final @Nonnull JTree tree, final @Nonnull String path, final @Nonnull JTreePathFinder pathFinder, final @Nonnull JTreeLocation location) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(44);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(45);
        }
        if (pathFinder == null) {
            JTreeDriver.$$$reportNull$$$0(46);
        }
        if (location == null) {
            JTreeDriver.$$$reportNull$$$0(47);
        }
        Triple<Boolean, Point, Integer> result = GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Point, Integer>>(){

            @Override
            protected Triple<Boolean, Point, Integer> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                TreePath matchingPath = JTreeMatchingPathQuery.matchingPathFor(tree, path, pathFinder);
                Point p = JTreeDriver.scrollToTreePath(tree, matchingPath, location);
                return Triple.of(tree.isExpanded(matchingPath), p, tree.getToggleClickCount());
            }
        });
        Triple triple = (Triple)Preconditions.checkNotNull(result);
        if (triple == null) {
            JTreeDriver.$$$reportNull$$$0(48);
        }
        return triple;
    }

    @RunsInEDT
    private void toggleCell(@Nonnull JTree tree, @Nonnull Point p, int toggleClickCount) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(49);
        }
        if (p == null) {
            JTreeDriver.$$$reportNull$$$0(50);
        }
        if (toggleClickCount == 0) {
            JTreeDriver.toggleRowThroughTreeUI(tree, p);
            this.robot.waitForIdle();
            return;
        }
        this.robot.click(tree, p, MouseButton.LEFT_BUTTON, toggleClickCount);
    }

    @RunsInEDT
    private static void toggleRowThroughTreeUI(final @Nonnull JTree tree, final @Nonnull Point p) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(51);
        }
        if (p == null) {
            JTreeDriver.$$$reportNull$$$0(52);
        }
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                TreeUI treeUI = tree.getUI();
                if (!(treeUI instanceof BasicTreeUI)) {
                    throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Can't toggle row for ", treeUI}));
                }
                JTreeToggleExpandStateTask.toggleExpandState(tree, p);
            }
        });
    }

    @RunsInEDT
    public void selectRows(final @Nonnull JTree tree, final @Nonnull int[] rows) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(53);
        }
        if (rows == null) {
            JTreeDriver.$$$reportNull$$$0(54);
        }
        ArrayPreconditions.checkNotNullOrEmpty(rows);
        this.clearSelection(tree);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return rows.length;
            }

            @Override
            void selectElement(int index) {
                JTreeDriver.this.selectRow(tree, rows[index]);
            }
        }.multiSelect();
    }

    @RunsInEDT
    private void clearSelection(@Nonnull JTree tree) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(55);
        }
        JTreeClearSelectionTask.clearSelectionOf(tree);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    public void selectRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(56);
        }
        this.scrollAndSelectRow(tree, row);
    }

    @RunsInEDT
    public void selectPaths(final @Nonnull JTree tree, final @Nonnull String[] paths) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(57);
        }
        if (paths == null) {
            JTreeDriver.$$$reportNull$$$0(58);
        }
        Preconditions.checkNotNullOrEmpty((Object[])paths);
        this.clearSelection(tree);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return paths.length;
            }

            @Override
            void selectElement(int index) {
                JTreeDriver.this.selectPath(tree, (String)Preconditions.checkNotNull((Object)paths[index]));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void selectPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(59);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(60);
        }
        this.selectMatchingPath(tree, path);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(61);
        }
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location());
        Point p = (Point)Preconditions.checkNotNull(info.second);
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(tree, p);
        if (jPopupMenu == null) {
            JTreeDriver.$$$reportNull$$$0(62);
        }
        return jPopupMenu;
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(63);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(64);
        }
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree, path);
        this.robot.waitForIdle();
        Point where = (Point)Preconditions.checkNotNull(info.third);
        JPopupMenu jPopupMenu = this.robot.showPopupMenu(tree, where);
        if (jPopupMenu == null) {
            JTreeDriver.$$$reportNull$$$0(65);
        }
        return jPopupMenu;
    }

    @RunsInEDT
    public void drag(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(66);
        }
        Point p = this.scrollAndSelectRow(tree, row);
        this.drag((Component)tree, p);
    }

    @Nonnull
    @RunsInEDT
    private Point scrollAndSelectRow(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(67);
        }
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location());
        Point p = (Point)Preconditions.checkNotNull(info.second);
        if (!((Boolean)info.first).booleanValue()) {
            this.robot.click((Component)tree, p);
        }
        Point point = p;
        if (point == null) {
            JTreeDriver.$$$reportNull$$$0(68);
        }
        return point;
    }

    @RunsInEDT
    public void drop(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(69);
        }
        Pair<Boolean, Point> info = JTreeDriver.scrollToRow(tree, row, this.location());
        this.drop((Component)tree, (Point)Preconditions.checkNotNull(info.second));
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> scrollToRow(final @Nonnull JTree tree, final int row, final @Nonnull JTreeLocation location) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(70);
        }
        if (location == null) {
            JTreeDriver.$$$reportNull$$$0(71);
        }
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(tree);
                Point p = JTreeDriver.scrollToVisible(tree, row, location);
                boolean selected = tree.getSelectionCount() == 1 && tree.isRowSelected(row);
                return Pair.of(selected, p);
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JTreeDriver.$$$reportNull$$$0(72);
        }
        return pair;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToVisible(@Nonnull JTree tree, int row, @Nonnull JTreeLocation location) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(73);
        }
        if (location == null) {
            JTreeDriver.$$$reportNull$$$0(74);
        }
        Pair<Rectangle, Point> boundsAndCoordinates = location.rowBoundsAndCoordinates(tree, row);
        tree.scrollRectToVisible((Rectangle)boundsAndCoordinates.first);
        Point point = (Point)Preconditions.checkNotNull(boundsAndCoordinates.second);
        if (point == null) {
            JTreeDriver.$$$reportNull$$$0(75);
        }
        return point;
    }

    @RunsInEDT
    public void drag(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(76);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(77);
        }
        Point p = this.selectMatchingPath(tree, path);
        this.drag((Component)tree, p);
    }

    @Nonnull
    @RunsInEDT
    private Point selectMatchingPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(78);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(79);
        }
        Triple<TreePath, Boolean, Point> info = this.scrollToMatchingPath(tree, path);
        this.robot.waitForIdle();
        Point where = (Point)Preconditions.checkNotNull(info.third);
        if (!((Boolean)info.second).booleanValue()) {
            this.robot.click((Component)tree, where);
        }
        Point point = where;
        if (point == null) {
            JTreeDriver.$$$reportNull$$$0(80);
        }
        return point;
    }

    @RunsInEDT
    public void drop(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(81);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(82);
        }
        Point p = (Point)this.scrollToMatchingPath((JTree)tree, (String)path).third;
        this.drop((Component)tree, (Point)Preconditions.checkNotNull((Object)p));
    }

    @Nonnull
    @RunsInEDT
    private Triple<TreePath, Boolean, Point> scrollToMatchingPath(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(83);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(84);
        }
        TreePath matchingPath = JTreeMatchingPathQuery.verifyJTreeIsReadyAndFindMatchingPath(tree, path, this.pathFinder());
        this.makeVisible(tree, matchingPath, false);
        Pair<Boolean, Point> info = JTreeDriver.scrollToPathToSelect(tree, matchingPath, this.location());
        Triple<TreePath, Boolean, Point> triple = Triple.of(matchingPath, info.first, info.second);
        if (triple == null) {
            JTreeDriver.$$$reportNull$$$0(85);
        }
        return triple;
    }

    @Nonnull
    @RunsInEDT
    private static Pair<Boolean, Point> scrollToPathToSelect(final @Nonnull JTree tree, final @Nonnull TreePath path, final @Nonnull JTreeLocation location) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(86);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(87);
        }
        if (location == null) {
            JTreeDriver.$$$reportNull$$$0(88);
        }
        Pair<Boolean, Point> result = GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                boolean isSelected = tree.getSelectionCount() == 1 && tree.isPathSelected(path);
                return Pair.of(isSelected, JTreeDriver.scrollToTreePath(tree, path, location));
            }
        });
        Pair pair = (Pair)Preconditions.checkNotNull(result);
        if (pair == null) {
            JTreeDriver.$$$reportNull$$$0(89);
        }
        return pair;
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point scrollToTreePath(@Nonnull JTree tree, @Nonnull TreePath path, @Nonnull JTreeLocation location) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(90);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(91);
        }
        if (location == null) {
            JTreeDriver.$$$reportNull$$$0(92);
        }
        Pair<Rectangle, Point> boundsAndCoordinates = location.pathBoundsAndCoordinates(tree, path);
        tree.scrollRectToVisible((Rectangle)boundsAndCoordinates.first);
        Point point = (Point)Preconditions.checkNotNull(boundsAndCoordinates.second);
        if (point == null) {
            JTreeDriver.$$$reportNull$$$0(93);
        }
        return point;
    }

    @RunsInEDT
    private boolean makeParentVisible(@Nonnull JTree tree, @Nonnull TreePath path) {
        boolean changed;
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(94);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(95);
        }
        if (changed = this.makeVisible(tree, (TreePath)Preconditions.checkNotNull((Object)path.getParentPath()), true)) {
            this.robot.waitForIdle();
        }
        return changed;
    }

    @RunsInEDT
    private boolean makeVisible(@Nonnull JTree tree, @Nonnull TreePath path, boolean expandWhenFound) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(96);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(97);
        }
        boolean changed = false;
        if (path.getPathCount() > 1) {
            changed = this.makeParentVisible(tree, path);
        }
        if (!expandWhenFound) {
            return changed;
        }
        JTreeExpandPathTask.expandTreePath(tree, path);
        this.waitForChildrenToShowUp(tree, path);
        return true;
    }

    @RunsInEDT
    private void waitForChildrenToShowUp(@Nonnull JTree tree, @Nonnull TreePath path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(98);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(99);
        }
        int timeout = this.robot.settings().timeoutToBeVisible();
        try {
            Pause.pause((Condition)JTreeChildrenShowUpCondition.untilChildrenShowUp(tree, path), (long)timeout);
        }
        catch (WaitTimedOutError e) {
            throw new LocationUnavailableException(e.getMessage());
        }
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JTree tree, @Nonnull int[] rows) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(100);
        }
        if (rows == null) {
            JTreeDriver.$$$reportNull$$$0(101);
        }
        Preconditions.checkNotNull((Object)rows);
        JTreeVerifySelectionTask.checkHasSelection(tree, rows, this.selectionProperty(tree));
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JTree tree, @Nonnull String[] paths) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(102);
        }
        if (paths == null) {
            JTreeDriver.$$$reportNull$$$0(103);
        }
        Preconditions.checkNotNull((Object)paths);
        JTreeVerifySelectionTask.checkHasSelection(tree, paths, this.pathFinder(), this.selectionProperty(tree));
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JTree tree) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(104);
        }
        JTreeVerifySelectionTask.checkNoSelection(tree, this.selectionProperty(tree));
    }

    @Nonnull
    @RunsInEDT
    private Description selectionProperty(@Nonnull JTree tree) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(105);
        }
        Description description = JTreeDriver.propertyName(tree, SELECTION_PROPERTY);
        if (description == null) {
            JTreeDriver.$$$reportNull$$$0(106);
        }
        return description;
    }

    @RunsInEDT
    public void requireEditable(@Nonnull JTree tree) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(107);
        }
        this.assertEditable(tree, true);
    }

    @RunsInEDT
    public void requireNotEditable(@Nonnull JTree tree) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(108);
        }
        this.assertEditable(tree, false);
    }

    @RunsInEDT
    private void assertEditable(@Nonnull JTree tree, boolean editable) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(109);
        }
        ((BooleanAssert)Assertions.assertThat((boolean)JTreeEditableQuery.isEditable(tree)).as(JTreeDriver.editableProperty(tree))).isEqualTo(editable);
    }

    @Nonnull
    @RunsInEDT
    private static Description editableProperty(@Nonnull JTree tree) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(110);
        }
        Description description = JTreeDriver.propertyName(tree, EDITABLE_PROPERTY);
        if (description == null) {
            JTreeDriver.$$$reportNull$$$0(111);
        }
        return description;
    }

    @Nonnull
    public String separator() {
        String string = this.pathFinder.separator();
        if (string == null) {
            JTreeDriver.$$$reportNull$$$0(112);
        }
        return string;
    }

    public void replaceSeparator(@Nonnull String newSeparator) {
        if (newSeparator == null) {
            JTreeDriver.$$$reportNull$$$0(113);
        }
        this.pathFinder.replaceSeparator((String)Preconditions.checkNotNull((Object)newSeparator));
    }

    public void replaceCellReader(@Nonnull JTreeCellReader newCellReader) {
        if (newCellReader == null) {
            JTreeDriver.$$$reportNull$$$0(114);
        }
        this.pathFinder.replaceCellReader((JTreeCellReader)Preconditions.checkNotNull((Object)newCellReader));
    }

    @RunsInEDT
    public void checkRowInBounds(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(115);
        }
        this.location.checkRowInBounds(tree, row);
    }

    @RunsInEDT
    public void checkPathExists(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(116);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(117);
        }
        JTreeMatchingPathQuery.matchingPathFor(tree, path, this.pathFinder());
    }

    @Nullable
    @RunsInEDT
    public String nodeValue(@Nonnull JTree tree, @Nonnull String path) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(118);
        }
        if (path == null) {
            JTreeDriver.$$$reportNull$$$0(119);
        }
        return JTreeNodeTextQuery.nodeText(tree, path, this.pathFinder());
    }

    @Nullable
    public String nodeValue(@Nonnull JTree tree, int row) {
        if (tree == null) {
            JTreeDriver.$$$reportNull$$$0(120);
        }
        return JTreeNodeTextQuery.nodeText(tree, row, this.location(), this.pathFinder());
    }

    @VisibleForTesting
    JTreeCellReader cellReader() {
        return this.pathFinder.cellReader();
    }

    @Nonnull
    private JTreeLocation location() {
        JTreeLocation jTreeLocation = this.location;
        if (jTreeLocation == null) {
            JTreeDriver.$$$reportNull$$$0(121);
        }
        return jTreeLocation;
    }

    @Nonnull
    private JTreePathFinder pathFinder() {
        JTreePathFinder jTreePathFinder = this.pathFinder;
        if (jTreePathFinder == null) {
            JTreeDriver.$$$reportNull$$$0(122);
        }
        return jTreePathFinder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 27: 
            case 39: 
            case 48: 
            case 62: 
            case 65: 
            case 68: 
            case 72: 
            case 75: 
            case 80: 
            case 85: 
            case 89: 
            case 93: 
            case 106: 
            case 111: 
            case 112: 
            case 121: 
            case 122: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 27: 
            case 39: 
            case 48: 
            case 62: 
            case 65: 
            case 68: 
            case 72: 
            case 75: 
            case 80: 
            case 85: 
            case 89: 
            case 93: 
            case 106: 
            case 111: 
            case 112: 
            case 121: 
            case 122: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "robot";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 49: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 73: 
            case 76: 
            case 78: 
            case 81: 
            case 83: 
            case 86: 
            case 90: 
            case 94: 
            case 96: 
            case 98: 
            case 100: 
            case 102: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 115: 
            case 116: 
            case 118: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseClickInfo";
                break;
            }
            case 11: 
            case 27: 
            case 39: 
            case 48: 
            case 62: 
            case 65: 
            case 68: 
            case 72: 
            case 75: 
            case 80: 
            case 85: 
            case 89: 
            case 93: 
            case 106: 
            case 111: 
            case 112: 
            case 121: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/driver/JTreeDriver";
                break;
            }
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 31: 
            case 41: 
            case 43: 
            case 45: 
            case 60: 
            case 64: 
            case 77: 
            case 79: 
            case 82: 
            case 84: 
            case 87: 
            case 91: 
            case 95: 
            case 97: 
            case 99: 
            case 117: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 29: 
            case 33: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 38: 
            case 47: 
            case 71: 
            case 74: 
            case 88: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFinder";
                break;
            }
            case 54: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 58: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCellReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/driver/JTreeDriver";
                break;
            }
            case 11: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToRow";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToPath";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToRowAndGetToggleInfo";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToMatchingPathAndGetToggleInfo";
                break;
            }
            case 62: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "showPopupMenu";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollAndSelectRow";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToVisible";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMatchingPath";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToMatchingPath";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToPathToSelect";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "scrollToTreePath";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "selectionProperty";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "editableProperty";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "separator";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "location";
                break;
            }
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "pathFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "clickRow";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doubleClickRow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rightClickRow";
                break;
            }
            case 10: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "scrollToRow";
                break;
            }
            case 11: 
            case 27: 
            case 39: 
            case 48: 
            case 62: 
            case 65: 
            case 68: 
            case 72: 
            case 75: 
            case 80: 
            case 85: 
            case 89: 
            case 93: 
            case 106: 
            case 111: 
            case 112: 
            case 121: 
            case 122: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "clickPath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doubleClickPath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "scrollToPath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doubleClick";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "rightClickPath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "rightClick";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "expandRow";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collapseRow";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "toggleRow";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "scrollToRowAndGetToggleInfo";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "collapsePath";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "scrollToMatchingPathAndGetToggleInfo";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toggleCell";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "toggleRowThroughTreeUI";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "selectRows";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "clearSelection";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "selectRow";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "selectPaths";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 61: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "showPopupMenu";
                break;
            }
            case 66: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "drag";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "scrollAndSelectRow";
                break;
            }
            case 69: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "drop";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "selectMatchingPath";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "scrollToMatchingPath";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "scrollToPathToSelect";
                break;
            }
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "scrollToTreePath";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "makeParentVisible";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "makeVisible";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "waitForChildrenToShowUp";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "requireSelection";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "requireNoSelection";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "selectionProperty";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "requireEditable";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "requireNotEditable";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "assertEditable";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "editableProperty";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "replaceSeparator";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "replaceCellReader";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "checkRowInBounds";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "checkPathExists";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "nodeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 27: 
            case 39: 
            case 48: 
            case 62: 
            case 65: 
            case 68: 
            case 72: 
            case 75: 
            case 80: 
            case 85: 
            case 89: 
            case 93: 
            case 106: 
            case 111: 
            case 112: 
            case 121: 
            case 122: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

