/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.util.Arrays;
import org.fest.util.Lists;
import org.fest.util.Maps;
import org.fest.util.Preconditions;
import org.fest.util.Strings;
import org.fest.util.ToString;

public final class IntrospectionComponentFormatter
extends ComponentFormatterTemplate {
    private final Class<? extends Component> targetType;
    private final List<String> propertyNames;
    private final Map<String, PropertyDescriptor> descriptors;

    public IntrospectionComponentFormatter(@Nonnull Class<? extends Component> targetType, String ... propertyNames) {
        if (targetType == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(0);
        }
        if (propertyNames == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(1);
        }
        this.descriptors = Maps.newHashMap();
        this.targetType = (Class)Preconditions.checkNotNull(targetType);
        this.propertyNames = Lists.newArrayList((Object[])propertyNames);
        this.populate();
    }

    private void populate() {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.targetType, Object.class);
        }
        catch (Exception e) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to get BeanInfo for type ", this.targetType.getName()}), e);
        }
        for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
            this.register((PropertyDescriptor)Preconditions.checkNotNull((Object)d));
        }
    }

    private void register(@Nonnull PropertyDescriptor d) {
        String name;
        if (d == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(2);
        }
        if (!this.propertyNames.contains(name = d.getName())) {
            return;
        }
        this.descriptors.put(name, d);
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        if (c == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(3);
        }
        StringBuilder b = new StringBuilder();
        b.append(c.getClass().getName()).append("[");
        int max = this.propertyNames.size() - 1;
        for (int i = 0; i <= max; ++i) {
            this.appendProperty(b, (String)Preconditions.checkNotNull((Object)this.propertyNames.get(i)), c);
            if (i >= max) continue;
            b.append(", ");
        }
        b.append("]");
        String string = b.toString();
        if (string == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void appendProperty(@Nonnull StringBuilder b, @Nonnull String name, @Nonnull Component c) {
        if (b == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(5);
        }
        if (name == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(6);
        }
        if (c == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(7);
        }
        b.append(name).append("=");
        try {
            b.append(this.propertyValue(c, name));
        }
        catch (Exception e) {
            b.append(String.format("<Unable to read property [%s: %s]>", e.getClass().getName(), Strings.quote((String)e.getMessage())));
        }
    }

    @Nullable
    private Object propertyValue(@Nonnull Component c, @Nonnull String property) throws Exception {
        if (c == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(8);
        }
        if (property == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(9);
        }
        if ("showing".equals(property)) {
            return c.isShowing();
        }
        PropertyDescriptor descriptor = this.descriptors.get(property);
        Object value = descriptor.getReadMethod().invoke((Object)c, new Object[0]);
        if (this.isOneDimensionalArray(value)) {
            return Arrays.format((Object)value);
        }
        return Strings.quote((Object)value);
    }

    private boolean isOneDimensionalArray(Object o) {
        return o != null && o.getClass().isArray() && !o.getClass().getComponentType().isArray();
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        Class<? extends Component> clazz = this.targetType;
        if (clazz == null) {
            IntrospectionComponentFormatter.$$$reportNull$$$0(10);
        }
        return clazz;
    }

    public String toString() {
        return String.format("%s[propertyNames=%s", this.getClass().getName(), ToString.toStringOf(this.propertyNames));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/format/IntrospectionComponentFormatter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/format/IntrospectionComponentFormatter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doFormat";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doFormat";
                break;
            }
            case 4: 
            case 10: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendProperty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "propertyValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

