/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.swing.format.IntEnum;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public class JTreeFormatter
extends ComponentFormatterTemplate {
    private static final String[] EMPTY = new String[0];
    private static final IntEnum SELECTION_MODES = new IntEnum();

    @Override
    @Nonnull
    protected String doFormat(@Nonnull Component c) {
        if (c == null) {
            JTreeFormatter.$$$reportNull$$$0(0);
        }
        JTree tree = (JTree)c;
        String format = "%s[name=%s, selectionCount=%d, selectionPaths=%s, selectionMode=%s, enabled=%b, visible=%b, showing=%b";
        String string = String.format(format, tree.getClass().getName(), Strings.quote((String)tree.getName()), tree.getSelectionCount(), Arrays.format((Object)this.selectionPaths(tree)), this.selectionMode(tree), tree.isEnabled(), tree.isVisible(), tree.isShowing());
        if (string == null) {
            JTreeFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nonnull
    private String[] selectionPaths(@Nonnull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            JTreeFormatter.$$$reportNull$$$0(2);
        }
        if ((paths = tree.getSelectionPaths()) == null) {
            if (EMPTY == null) {
                JTreeFormatter.$$$reportNull$$$0(3);
            }
            return EMPTY;
        }
        int count = paths.length;
        if (count == 0) {
            if (EMPTY == null) {
                JTreeFormatter.$$$reportNull$$$0(4);
            }
            return EMPTY;
        }
        String[] pathArray = new String[count];
        for (int i = 0; i < count; ++i) {
            TreePath path = paths[i];
            pathArray[i] = path != null ? path.toString() : null;
        }
        if (pathArray == null) {
            JTreeFormatter.$$$reportNull$$$0(5);
        }
        return pathArray;
    }

    @Nullable
    private String selectionMode(JTree tree) {
        TreeSelectionModel model = tree.getSelectionModel();
        return SELECTION_MODES.get(model.getSelectionMode());
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        if (JTree.class == null) {
            JTreeFormatter.$$$reportNull$$$0(6);
        }
        return JTree.class;
    }

    static {
        SELECTION_MODES.put(1, "SINGLE_TREE_SELECTION").put(2, "CONTIGUOUS_TREE_SELECTION").put(4, "DISCONTIGUOUS_TREE_SELECTION");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/fest/swing/format/JTreeFormatter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/fest/swing/format/JTreeFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doFormat";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "selectionPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFormat";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "selectionPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

