/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.text;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;

public abstract class TextReader<T extends Component> {
    @Nonnull
    public abstract Class<T> supportedComponent();

    @RunsInCurrentThread
    public final boolean containsText(@Nonnull Component c, @Nonnull String text) {
        if (c == null) {
            TextReader.$$$reportNull$$$0(0);
        }
        if (text == null) {
            TextReader.$$$reportNull$$$0(1);
        }
        this.checkCorrectType(c);
        Component casted = (Component)this.supportedComponent().cast(c);
        return this.checkContainsText(casted, text);
    }

    private void checkCorrectType(Component c) {
        Class<T> type = this.supportedComponent();
        if (!type.isAssignableFrom(c.getClass())) {
            String msg = String.format("Expecting component of type %s but got %s", type.getName(), c.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
    }

    @RunsInCurrentThread
    protected abstract boolean checkContainsText(@Nonnull T var1, @Nonnull String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "c";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "org/fest/swing/text/TextReader";
        objectArray[2] = "containsText";
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

