/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.FtlIndexInfo;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumDataDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.NullableDataExternalizer;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlFileIndex
extends FileBasedIndexExtension<FtlIndexKey, FtlIndexInfo> {
    public static final ID<FtlIndexKey, FtlIndexInfo> NAME = ID.create((String)"FtlFileIndex");
    @NonNls
    public static final String IMPLICIT_INCLUDE_MARKER = "[#ftl]\n[#-- @implicitly included --]\n";
    @NonNls
    public static final String ANGLE_IMPLICIT_INCLUDE_MARKER = "<#ftl>\n<#-- @implicitly included -->\n";

    @NotNull
    public ID<FtlIndexKey, FtlIndexInfo> getName() {
        ID<FtlIndexKey, FtlIndexInfo> iD = NAME;
        if (iD == null) {
            FtlFileIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<FtlIndexKey, FtlIndexInfo, FileContent> getIndexer() {
        DataIndexer<FtlIndexKey, FtlIndexInfo, FileContent> dataIndexer = new DataIndexer<FtlIndexKey, FtlIndexInfo, FileContent>(){

            @NotNull
            public Map<FtlIndexKey, FtlIndexInfo> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                SmartList includes = new SmartList();
                THashSet macros = new THashSet();
                THashSet functions = new THashSet();
                THashSet roots = new THashSet();
                PsiFile psiFile = inputData.getPsiFile();
                if (!(psiFile instanceof FtlFile)) {
                    Map<FtlIndexKey, FtlIndexInfo> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                psiFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor((Set)roots, (List)includes, (Set)functions, (Set)macros){
                    final /* synthetic */ Set val$roots;
                    final /* synthetic */ List val$includes;
                    final /* synthetic */ Set val$functions;
                    final /* synthetic */ Set val$macros;
                    {
                        this.val$roots = set;
                        this.val$includes = list;
                        this.val$functions = set2;
                        this.val$macros = set3;
                    }

                    public void visitComment(PsiComment comment) {
                        String text = comment.getText();
                        Matcher matcher = FtlFileReferenceDirective.FTL_ROOT_PATTERN.matcher(text);
                        if (matcher.matches()) {
                            this.val$roots.add(matcher.group(1));
                        }
                    }

                    public void visitWhiteSpace(PsiWhiteSpace space) {
                    }

                    public void visitOuterLanguageElement(OuterLanguageElement element) {
                    }

                    public void visitErrorElement(PsiErrorElement element) {
                    }

                    public void visitElement(PsiElement element) {
                        FtlSignatureDirective signatureDirective;
                        String name;
                        String refText;
                        FtlFileReferenceDirective directive;
                        FtlStringLiteral literal;
                        if (element instanceof LeafElement) {
                            return;
                        }
                        if (element instanceof FtlFileReferenceDirective && (literal = (directive = (FtlFileReferenceDirective)element).getReferenceLiteral()) != null && ((refText = literal.getValueText()).startsWith("/") || refText.startsWith("\\"))) {
                            this.val$includes.add(refText.replace('\\', '/'));
                        }
                        if (element instanceof FtlSignatureDirective && StringUtil.isNotEmpty((String)(name = (signatureDirective = (FtlSignatureDirective)element).getName()))) {
                            (signatureDirective.isFunction() ? this.val$functions : this.val$macros).add(name);
                        }
                        if (element instanceof FtlXmlTag) {
                            super.visitElement(element);
                        }
                    }
                });
                HashMap map = new HashMap();
                map.put((Object)(((FtlFile)psiFile).isImplicitlyIncluded() ? FtlIndexKey.IMPLICITLY_INCLUDED : FtlIndexKey.USUAL_FILE), null);
                map.put((Object)FtlIndexKey.DATA, (Object)new FtlIndexInfo((List<String>)includes, (Set<String>)macros, (Set<String>)functions, (Set<String>)roots));
                HashMap hashMap = map;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/freemarker/FtlFileIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/freemarker/FtlFileIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            FtlFileIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<FtlIndexKey> getKeyDescriptor() {
        EnumDataDescriptor enumDataDescriptor = new EnumDataDescriptor(FtlIndexKey.class);
        if (enumDataDescriptor == null) {
            FtlFileIndex.$$$reportNull$$$0(2);
        }
        return enumDataDescriptor;
    }

    @NotNull
    public DataExternalizer<FtlIndexInfo> getValueExternalizer() {
        NullableDataExternalizer nullableDataExternalizer = new NullableDataExternalizer((DataExternalizer)new DataExternalizer<FtlIndexInfo>(){

            public void save(@NotNull DataOutput out, FtlIndexInfo value) throws IOException {
                if (out == null) {
                    2.$$$reportNull$$$0(0);
                }
                IOUtil.writeStringList((DataOutput)out, value.includes);
                IOUtil.writeStringList((DataOutput)out, value.functions);
                IOUtil.writeStringList((DataOutput)out, value.macros);
                IOUtil.writeStringList((DataOutput)out, value.roots);
            }

            public FtlIndexInfo read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    2.$$$reportNull$$$0(1);
                }
                List includes = IOUtil.readStringList((DataInput)in);
                THashSet functions = new THashSet((Collection)IOUtil.readStringList((DataInput)in));
                THashSet macros = new THashSet((Collection)IOUtil.readStringList((DataInput)in));
                THashSet roots = new THashSet((Collection)IOUtil.readStringList((DataInput)in));
                return new FtlIndexInfo(includes, (Set<String>)macros, (Set<String>)functions, (Set<String>)roots);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/freemarker/FtlFileIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (nullableDataExternalizer == null) {
            FtlFileIndex.$$$reportNull$$$0(3);
        }
        return nullableDataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{FtlFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            FtlFileIndex.$$$reportNull$$$0(4);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/freemarker/FtlFileIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum FtlIndexKey {
        IMPLICITLY_INCLUDED,
        USUAL_FILE,
        DATA;

    }
}

