/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.midp.wtk;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin.emulator.midp.wtk.ConfigurationUtil");
    private static final String TITLE_VERSIONED_PROPERTY = "TITLE_VERSIONED";

    private ConfigurationUtil() {
    }

    @Nullable
    private static Properties getWTKEmulatorProperties(String homeDir) {
        return JarUtil.loadProperties((File)new File(homeDir, "wtklib/ktools.zip"), (String)"I18N.properties");
    }

    @Nullable
    public static Properties getApiSettings(String homeDir) {
        return JarUtil.loadProperties((File)new File(homeDir, "wtklib/ktools.zip"), (String)"com/sun/kvem/toolbar/ApiSettings.properties");
    }

    @Nullable
    public static String[] getDefaultApiPath(String homePath) {
        String[] apiPaths;
        Properties apiSettings = ConfigurationUtil.getApiSettings(homePath);
        if (apiSettings == null || apiSettings.isEmpty()) {
            return null;
        }
        String defaultConf = apiSettings.getProperty("default");
        String[] stringArray = apiPaths = defaultConf != null ? defaultConf.split(", ") : null;
        if (apiPaths == null) {
            return null;
        }
        String optionalConf = apiSettings.getProperty("optional");
        Object[] optionalPaths = optionalConf != null ? optionalConf.split(", ") : null;
        ArrayList<String> jars = new ArrayList<String>();
        for (String apiPath : apiPaths) {
            String jar;
            if (optionalPaths == null || ArrayUtil.find((Object[])optionalPaths, (Object)apiPath) != -1 || (jar = apiSettings.getProperty(apiPath + ".file")) == null) continue;
            jars.add(homePath + File.separator + "lib" + File.separator + jar);
        }
        return ArrayUtil.toStringArray(jars);
    }

    @Nullable
    public static String getWTKVersion(String homeDir) {
        Properties emulatorProperties = ConfigurationUtil.getWTKEmulatorProperties(homeDir);
        return emulatorProperties != null ? emulatorProperties.getProperty(TITLE_VERSIONED_PROPERTY) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWTKConfigurations(@NotNull String homeDir, @NonNls String name) {
        File file;
        if (homeDir == null) {
            ConfigurationUtil.$$$reportNull$$$0(0);
        }
        if ((file = new File(homeDir, "lib/system.config")).canRead()) {
            String string;
            FileInputStream stream = new FileInputStream(file);
            try {
                Properties properties = new Properties();
                properties.load(stream);
                string = properties.getProperty(name);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
            }
            ((InputStream)stream).close();
            return string;
        }
        return null;
    }

    @Nullable
    public static String getProfileVersion(@NotNull String homeDir) {
        if (homeDir == null) {
            ConfigurationUtil.$$$reportNull$$$0(1);
        }
        return ConfigurationUtil.getWTKConfigurations(homeDir, "microedition.profiles");
    }

    @Nullable
    public static String getConfigurationVersion(@NotNull String homeDir) {
        if (homeDir == null) {
            ConfigurationUtil.$$$reportNull$$$0(2);
        }
        return ConfigurationUtil.getWTKConfigurations(homeDir, "microedition.configuration");
    }

    @Nullable
    public static String[] getWTKDevices(String homeDir) {
        ArrayList<String> result = new ArrayList<String>();
        VirtualFile homeDirectory = LocalFileSystem.getInstance().findFileByPath(homeDir);
        if (homeDirectory == null) {
            return null;
        }
        VirtualFile devicesDirectory = homeDirectory.findFileByRelativePath("wtklib/devices");
        if (devicesDirectory == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        VirtualFile[] devices = devicesDirectory.getChildren();
        for (int i = 0; devices != null && i < devices.length; ++i) {
            if (!devices[i].isDirectory() || devices[i].findChild(devices[i].getName() + ".properties") == null) continue;
            result.add(devices[i].getName());
        }
        return ArrayUtil.toStringArray(result);
    }

    public static boolean isValidWTKHome(String homeDir) {
        Properties wtkEmulatorProperties = ConfigurationUtil.getWTKEmulatorProperties(homeDir);
        String property = wtkEmulatorProperties != null ? wtkEmulatorProperties.getProperty("TITLE_PROJECT") : null;
        return property != null && property.contains("Toolkit");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "homeDir";
        objectArray2[1] = "com/intellij/j2meplugin/emulator/midp/wtk/ConfigurationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getWTKConfigurations";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getProfileVersion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurationVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

