/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module;

import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2MERefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private final Project myProject;

    public J2MERefactoringListenerProvider(Project project) {
        this.myProject = project;
    }

    @Nullable
    public RefactoringElementListener getListener(PsiElement element) {
        Module[] modules;
        if (!(element instanceof PsiClass)) {
            return null;
        }
        RefactoringElementListenerComposite listenerComposite = null;
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            final MobileModuleSettings moduleSettings = MobileModuleSettings.getInstance(module);
            if (moduleSettings == null) continue;
            SortedSet<String> midlets = moduleSettings.getMIDlets();
            for (final String midlet : midlets) {
                PsiClass psiClass;
                String midletClassName = moduleSettings.getMIDletClassName(midlet);
                if (midletClassName == null || (psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(midletClassName, GlobalSearchScope.projectScope((Project)this.myProject))) == null || element != psiClass) continue;
                if (listenerComposite == null) {
                    listenerComposite = new RefactoringElementListenerComposite();
                }
                listenerComposite.addListener((RefactoringElementListener)new RefactoringElementAdapter(){

                    public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!(newElement instanceof PsiClass)) {
                            return;
                        }
                        moduleSettings.setMIDletClassName(midlet, ((PsiClass)newElement).getQualifiedName());
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (oldQualifiedName == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        moduleSettings.setMIDletClassName(midlet, oldQualifiedName);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElement";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "oldQualifiedName";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/j2meplugin/module/J2MERefactoringListenerProvider$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "elementRenamedOrMoved";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "undoElementMovedOrRenamed";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        return listenerComposite;
    }
}

