/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.midp;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.module.J2MEModuleBuilder;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.j2meplugin.module.settings.midp.MIDPApplicationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class MIDPSettings
extends MobileModuleSettings {
    public MIDPSettings() {
    }

    public MIDPSettings(Module module) {
        super(module);
    }

    @Override
    public void copyTo(MobileModuleSettings mobileModuleSettings) {
        if (!(mobileModuleSettings instanceof MIDPSettings)) {
            return;
        }
        super.copyTo(mobileModuleSettings);
    }

    @Override
    public void initSettings(J2MEModuleBuilder moduleBuilder) {
        super.initSettings(moduleBuilder);
        if (this.myDefaultModified) {
            this.putIfNotExists("MIDlet-Name", moduleBuilder.getName());
            this.putIfNotExists("MIDlet-Vendor", J2MEBundle.message("module.settings.default.vendor", new Object[0]));
            this.putIfNotExists("MIDlet-Version", "1.0");
        } else {
            this.putSetting("MIDlet-Name", moduleBuilder.getName());
            this.putSetting("MIDlet-Vendor", J2MEBundle.message("module.settings.default.vendor", new Object[0]));
            this.putSetting("MIDlet-Version", "1.0");
        }
    }

    @Override
    public void prepareJarSettings() {
        super.prepareJarSettings();
        Sdk myProjectJdk = ModuleRootManager.getInstance((Module)this.myModule).getSdk();
        if (MobileSdk.checkCorrectness(myProjectJdk, this.myModule)) {
            String configuration;
            String profile = ((Emulator)myProjectJdk.getSdkAdditionalData()).getProfile();
            LOG.assertTrue(profile != null);
            if (!this.isSynchronized()) {
                this.putSetting("MicroEdition-Profile", profile);
            }
            LOG.assertTrue((configuration = ((Emulator)myProjectJdk.getSdkAdditionalData()).getConfiguration()) != null);
            if (!this.isSynchronized()) {
                this.putSetting("MicroEdition-Configuration", configuration);
            }
        }
    }

    @Override
    public File getManifest() {
        File manifest = super.getManifest();
        if (manifest != null) {
            return manifest;
        }
        String separator = MIDPApplicationType.getInstance().getSeparator();
        try {
            File temp = FileUtil.createTempFile((String)"temp", (String)".mf");
            temp.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(temp)));
            MIDPSettings.putManifestAttribute(printWriter, Attributes.Name.MANIFEST_VERSION.toString(), separator, "1.0");
            MIDPSettings.putManifestAttribute(printWriter, "MicroEdition-Configuration", separator, this.getSettings().get("MicroEdition-Configuration"));
            MIDPSettings.putManifestAttribute(printWriter, "MIDlet-Name", separator, this.getSettings().get("MIDlet-Name"));
            MIDPSettings.putManifestAttribute(printWriter, "MIDlet-Vendor", separator, this.getSettings().get("MIDlet-Vendor"));
            for (String string : this.getMIDlets()) {
                MIDPSettings.putManifestAttribute(printWriter, string, separator, this.getSettings().get(string).replaceAll(",", ", "));
            }
            MIDPSettings.putManifestAttribute(printWriter, "MIDlet-Version", separator, this.getSettings().get("MIDlet-Version"));
            MIDPSettings.putManifestAttribute(printWriter, "MicroEdition-Profile", separator, this.getSettings().get("MicroEdition-Profile"));
            for (UserDefinedOption userDefinedOption : this.getUserDefinedOptions()) {
                MIDPSettings.putManifestAttribute(printWriter, userDefinedOption.getKey(), separator, userDefinedOption.getValue());
            }
            printWriter.close();
            return temp;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SortedSet<String> getMIDlets() {
        TreeSet<String> midletNumbers = new TreeSet<String>();
        for (String key : this.getSettings().keySet()) {
            if (!this.isMidletKey(key)) continue;
            midletNumbers.add(key);
        }
        return midletNumbers;
    }

    @Override
    public void setMIDletClassName(String key, String className) {
        MIDletProperty property = new MIDletProperty(key, this.getSettings().get(key));
        this.getSettings().put(key, property.getName() + "," + property.getIcon() + "," + className);
    }

    @Override
    @Nullable
    public String getMIDletClassName(String key) {
        String value = this.getSettings().get(key);
        MIDletProperty property = value != null ? new MIDletProperty(key, value) : null;
        return property != null ? property.getClassName() : null;
    }

    @Override
    public boolean isMidletKey(String key) {
        String pattern = "\\d*";
        Pattern midlets = Pattern.compile("MIDlet-\\d*");
        return midlets.matcher(key).matches();
    }

    @Override
    public MobileApplicationType getApplicationType() {
        return MIDPApplicationType.getInstance();
    }

    @Override
    public void addMidlet(String qualifiedName) {
        int dotIdx = qualifiedName.lastIndexOf(46);
        String name = dotIdx > -1 ? qualifiedName.substring(dotIdx + 1) : qualifiedName;
        this.getSettings().put("MIDlet-" + (this.getMIDlets().size() + 1), name + ",," + qualifiedName);
        super.addMidlet(qualifiedName);
    }

    @Override
    public boolean containsMidlet(String qualifiedName) {
        SortedSet<String> midlets = this.getMIDlets();
        for (String midlet : midlets) {
            if (ArrayUtil.find((Object[])this.getSettings().get(midlet).split("[, ]"), (Object)qualifiedName) == -1) continue;
            return true;
        }
        return false;
    }

    public static class MIDletProperty {
        private final String name;
        private final String icon;
        private final String className;
        private final String number;

        public MIDletProperty(String name, String icon, String className, String number) {
            this.name = name;
            this.icon = icon;
            this.className = className;
            this.number = number;
        }

        public MIDletProperty(String number, String value) {
            String[] midlet = value.split(",");
            LOG.assertTrue(midlet != null && midlet.length == 3);
            this.name = midlet[0];
            this.icon = midlet[1];
            this.className = midlet[2];
            this.number = number;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getClassName() {
            return this.className;
        }

        public String getValueString() {
            return this.name + "," + this.icon + "," + this.className;
        }

        public String getNumber() {
            return this.number;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MIDletProperty)) {
                return false;
            }
            return ((MIDletProperty)o).getNumber().equals(this.getNumber());
        }

        public int hashCode() {
            int result = this.getNumber().hashCode() * 29;
            return result + this.getValueString().hashCode() * 29;
        }
    }
}

