/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.midp;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.MobileSettingsConfigurable;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.j2meplugin.module.settings.general.UserKeysConfigurable;
import com.intellij.j2meplugin.module.settings.midp.MIDPSettings;
import com.intellij.j2meplugin.util.J2MEClassBrowser;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.SortedSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MIDPSettingsConfigurable
extends MobileSettingsConfigurable {
    private JTextField myMIDletName;
    private JLabel myMIDletNameLabel;
    private TextFieldWithBrowseButton myMIDletJarUrl;
    private JLabel myMIDletJarUrlLabel;
    private JTextField myMIDletVersion;
    private JLabel myMIDletVersionLabel;
    private JTextField myMIDletVendor;
    private JLabel myMIDletVendorLabel;
    private JButton myAddButton;
    private JButton myEditButton;
    private JButton myRemoveButton;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JButton myOptionalSettingsButton;
    private final DefaultListModel myListModel;
    private JList myMIDletList;
    private JPanel myWholePanel;
    private JPanel myMIDletPropertiesPanel;
    private boolean myModified;
    private final HashMap<String, String> myTempSettings;
    private final HashSet<UserDefinedOption> myTempUserOptions;

    public MIDPSettingsConfigurable(Module module, MobileModuleSettings settings, Project project) {
        super(module, settings, project);
        this.$$$setupUI$$$();
        this.myListModel = new DefaultListModel();
        this.myModified = false;
        this.myTempSettings = new HashMap();
        this.myTempUserOptions = new HashSet();
    }

    public JPanel createComponent() {
        ActionListener modifier = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MIDPSettingsConfigurable.this.myModified = true;
            }
        };
        DocumentAdapter textModifier = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MIDPSettingsConfigurable.this.myModified = true;
            }
        };
        DocumentAdapter defaultModifier = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MIDPSettingsConfigurable.this.mySettings.setDefaultModified(true);
            }
        };
        this.myMIDletNameLabel.setText("MIDlet-Name:");
        this.myMIDletName.getDocument().addDocumentListener((DocumentListener)textModifier);
        this.myMIDletName.getDocument().addDocumentListener((DocumentListener)defaultModifier);
        this.myMIDletVersionLabel.setText("MIDlet-Version:");
        this.myMIDletVersion.getDocument().addDocumentListener((DocumentListener)textModifier);
        this.myMIDletVersion.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MIDPSettingsConfigurable.this.myMIDletVersion.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.myMIDletVendorLabel.setText("MIDlet-Vendor:");
        this.myMIDletVendor.getDocument().addDocumentListener((DocumentListener)textModifier);
        this.myMIDletVendor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MIDPSettingsConfigurable.this.myMIDletVendor.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.myMIDletJarUrlLabel.setText("MIDlet-Jar-URL:");
        this.myMIDletJarUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
                fileChooserDescriptor.setTitle(J2MEBundle.message("build.settings.jar.utl.title", new Object[0]));
                fileChooserDescriptor.setDescription(J2MEBundle.message("build.settings.jar.url", new Object[0]));
                String directoryName = MIDPSettingsConfigurable.this.myMIDletJarUrl.getText().trim();
                VirtualFile initialFile = LocalFileSystem.getInstance().findFileByPath(directoryName.replace(File.separatorChar, '/'));
                VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)MIDPSettingsConfigurable.this.myProject, (VirtualFile)initialFile);
                if (file != null) {
                    MIDPSettingsConfigurable.this.myMIDletJarUrl.setText(FileUtil.toSystemIndependentName((String)file.getPresentableUrl()));
                }
            }
        });
        this.myMIDletJarUrl.addActionListener(modifier);
        this.myMIDletJarUrl.getTextField().getDocument().addDocumentListener((DocumentListener)textModifier);
        this.myMIDletJarUrl.getTextField().getDocument().addDocumentListener((DocumentListener)defaultModifier);
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MIDPSettingsConfigurable.this.myMIDletList.getSelectedIndex() <= 0) {
                    return;
                }
                MIDPSettingsConfigurable.this.moveMIDlet(-1);
                MIDPSettingsConfigurable.this.myModified = true;
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MIDPSettingsConfigurable.this.myMIDletList.getSelectedValue() == null || MIDPSettingsConfigurable.this.myMIDletList.getSelectedIndex() >= MIDPSettingsConfigurable.this.myListModel.size() - 1) {
                    return;
                }
                MIDPSettingsConfigurable.this.moveMIDlet(1);
                MIDPSettingsConfigurable.this.myModified = true;
            }
        });
        this.myMIDletList.setModel(this.myListModel);
        this.myMIDletList.setSelectionMode(0);
        this.myMIDletList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                super.getListCellRendererComponent((JList<?>)jList, o, i, b, b1);
                this.setText(((MIDPSettings.MIDletProperty)o).getName());
                return this;
            }
        });
        this.myRemoveButton.setEnabled(false);
        this.myEditButton.setEnabled(false);
        this.myMoveUpButton.setEnabled(false);
        this.myMoveDownButton.setEnabled(false);
        this.myMIDletList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MIDPSettingsConfigurable.this.myMIDletList.getSelectedIndex() == -1) {
                    MIDPSettingsConfigurable.this.myRemoveButton.setEnabled(false);
                    MIDPSettingsConfigurable.this.myEditButton.setEnabled(false);
                    MIDPSettingsConfigurable.this.myMoveUpButton.setEnabled(false);
                    MIDPSettingsConfigurable.this.myMoveDownButton.setEnabled(false);
                } else {
                    MIDPSettingsConfigurable.this.myEditButton.setEnabled(true);
                    MIDPSettingsConfigurable.this.myRemoveButton.setEnabled(true);
                    if (MIDPSettingsConfigurable.this.myMIDletList.getSelectedIndex() != 0) {
                        MIDPSettingsConfigurable.this.myMoveUpButton.setEnabled(true);
                    } else {
                        MIDPSettingsConfigurable.this.myMoveUpButton.setEnabled(false);
                    }
                    if (MIDPSettingsConfigurable.this.myMIDletList.getSelectedIndex() != MIDPSettingsConfigurable.this.myListModel.getSize() - 1) {
                        MIDPSettingsConfigurable.this.myMoveDownButton.setEnabled(true);
                    } else {
                        MIDPSettingsConfigurable.this.myMoveDownButton.setEnabled(false);
                    }
                }
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MIDPSettingsConfigurable.this.myMIDletList.getSelectedValue() == null) {
                    return;
                }
                MIDPSettings.MIDletProperty midlet = (MIDPSettings.MIDletProperty)MIDPSettingsConfigurable.this.myMIDletList.getSelectedValue();
                ArrayList<MIDPSettings.MIDletProperty> midlets = new ArrayList<MIDPSettings.MIDletProperty>();
                for (int i = 0; i < MIDPSettingsConfigurable.this.myListModel.size(); ++i) {
                    MIDPSettings.MIDletProperty property = (MIDPSettings.MIDletProperty)MIDPSettingsConfigurable.this.myListModel.get(i);
                    if (property.equals(midlet)) continue;
                    midlets.add(property);
                }
                MIDPSettingsConfigurable.this.myListModel.clear();
                int midletCount = 1;
                for (MIDPSettings.MIDletProperty key : midlets) {
                    MIDPSettings.MIDletProperty property = new MIDPSettings.MIDletProperty("MIDlet-" + midletCount, key.getValueString());
                    MIDPSettingsConfigurable.this.myListModel.addElement(property);
                    ++midletCount;
                }
                MIDPSettingsConfigurable.this.myModified = true;
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new MIDletOptionsPanel(MIDPSettingsConfigurable.this.myWholePanel, new MIDPSettings.MIDletProperty("", "", "", "MIDlet-" + (MIDPSettingsConfigurable.this.myListModel.size() + 1)), false).show();
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MIDPSettingsConfigurable.this.myMIDletList.getSelectedValue() == null) {
                    return;
                }
                new MIDletOptionsPanel(MIDPSettingsConfigurable.this.myWholePanel, (MIDPSettings.MIDletProperty)MIDPSettingsConfigurable.this.myMIDletList.getSelectedValue(), true).show();
            }
        });
        this.myOptionalSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AdditionalOptionsPanel(MIDPSettingsConfigurable.this.myWholePanel).show();
            }
        });
        this.myOptionalSettingsButton.setVisible(this.myModule != null);
        return this.myWholePanel;
    }

    @Override
    public void disableMidletProperties() {
        this.myMIDletPropertiesPanel.setVisible(false);
    }

    private void moveMIDlet(int direction) {
        int index = this.myMIDletList.getSelectedIndex();
        MIDPSettings.MIDletProperty from = (MIDPSettings.MIDletProperty)this.myListModel.getElementAt(index);
        MIDPSettings.MIDletProperty to = (MIDPSettings.MIDletProperty)this.myListModel.elementAt(index + direction);
        this.myListModel.set(index, new MIDPSettings.MIDletProperty(to.getName(), to.getIcon(), to.getClassName(), from.getNumber()));
        this.myListModel.set(index + direction, new MIDPSettings.MIDletProperty(from.getName(), from.getIcon(), from.getClassName(), to.getNumber()));
        this.myMIDletList.removeSelectionInterval(index, index);
        this.myMIDletList.addSelectionInterval(index + direction, index + direction);
    }

    @Override
    public void reset() {
        super.reset();
        this.myMIDletName.setText(this.mySettings.getSettings().get("MIDlet-Name"));
        this.myMIDletJarUrl.setText(this.mySettings.getSettings().get("MIDlet-Jar-URL"));
        this.myMIDletVersion.setText(this.mySettings.getSettings().get("MIDlet-Version"));
        this.myMIDletVendor.setText(this.mySettings.getSettings().get("MIDlet-Vendor"));
        this.myListModel.clear();
        SortedSet<String> midletNumbers = this.mySettings.getMIDlets();
        for (String key : midletNumbers) {
            String value = this.mySettings.getSettings().get(key);
            if (value == null) continue;
            this.myListModel.addElement(new MIDPSettings.MIDletProperty(key, value));
        }
        this.myMIDletList.setModel(this.myListModel);
        this.myModified = false;
        this.mySettings.setDefaultModified(false);
        this.myTempSettings.putAll(this.mySettings.getSettings());
        this.myTempUserOptions.addAll(this.mySettings.getUserDefinedOptions());
    }

    public void disposeUIResources() {
    }

    @Override
    public void apply() throws ConfigurationException {
        if (this.myMIDletName.getText() == null || this.myMIDletName.getText().length() == 0) {
            throw new ConfigurationException(J2MEBundle.message("module.settings.suit.not.specified", new Object[0]));
        }
        if (this.myMIDletJarUrl.getText() == null || this.myMIDletJarUrl.getText().length() == 0) {
            throw new ConfigurationException(J2MEBundle.message("compiler.jar.file.not.specified", new Object[0]));
        }
        if (this.myMIDletVersion.getText() == null || this.myMIDletVersion.getText().length() == 0) {
            throw new ConfigurationException(J2MEBundle.message("module.settings.version.not.specified", new Object[0]));
        }
        if (this.myMIDletVendor.getText() == null || this.myMIDletVendor.getText().length() == 0) {
            throw new ConfigurationException(J2MEBundle.message("module.settings.vendor.not.specified.", new Object[0]));
        }
        this.mySettings.getSettings().clear();
        for (String key : this.myTempSettings.keySet()) {
            if (this.mySettings.isMidletKey(key)) continue;
            this.mySettings.putSetting(key, this.myTempSettings.get(key));
        }
        for (int i = 0; i < this.myListModel.size(); ++i) {
            MIDPSettings.MIDletProperty midlet = (MIDPSettings.MIDletProperty)this.myListModel.getElementAt(i);
            this.mySettings.putSetting(midlet.getNumber(), midlet.getValueString());
        }
        this.mySettings.getUserDefinedOptions().clear();
        for (UserDefinedOption myTempUserOption : this.myTempUserOptions) {
            this.mySettings.getUserDefinedOptions().add(myTempUserOption);
        }
        this.mySettings.putSetting("MIDlet-Name", this.myMIDletName.getText());
        this.mySettings.putSetting("MIDlet-Jar-URL", this.myMIDletJarUrl.getText());
        this.mySettings.putSetting("MIDlet-Version", this.myMIDletVersion.getText());
        this.mySettings.putSetting("MIDlet-Vendor", this.myMIDletVendor.getText());
        super.apply();
        this.myModified = false;
    }

    public boolean isModified() {
        return this.myModified;
    }

    @Nullable
    private String getRelativeIconPath(@NotNull String iconPath) {
        String resourcePath;
        if (iconPath == null) {
            MIDPSettingsConfigurable.$$$reportNull$$$0(0);
        }
        if ((resourcePath = J2MEModuleProperties.getInstance(this.myModule).getResourcePath()) == null) {
            if (iconPath.length() != 0) {
                Messages.showErrorDialog((String)J2MEBundle.message("module.settings.unable.to.set.icon", new Object[0]), (String)J2MEBundle.message("resource.directory.needed", new Object[0]));
                return null;
            }
        } else if (!iconPath.startsWith(resourcePath = FileUtil.toSystemIndependentName((String)resourcePath))) {
            if (iconPath.length() != 0) {
                Messages.showErrorDialog((String)J2MEBundle.message("module.settings.incorrect.icon.path", new Object[0]), (String)J2MEBundle.message("module.settings.correct.icon.path", resourcePath));
                return null;
            }
        } else {
            iconPath = iconPath.substring(resourcePath.length());
        }
        return iconPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iconPath", "com/intellij/j2meplugin/module/settings/midp/MIDPSettingsConfigurable", "getRelativeIconPath"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JPanel jPanel;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myMIDletPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(10, 10, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 6, 1, 0, 3, 7, 7, null, null, null));
        JBList jBList = new JBList();
        this.myMIDletList = jBList;
        jBScrollPane.setViewportView((Component)jBList);
        this.myAddButton = jButton6 = new JButton();
        this.$$$loadButtonText$$$(jButton6, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("j2me.add"));
        jPanel.add((Component)jButton6, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditButton = jButton5 = new JButton();
        this.$$$loadButtonText$$$(jButton5, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("j2me.edit"));
        jPanel.add((Component)jButton5, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("j2me.remove"));
        jPanel.add((Component)jButton4, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveUpButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("j2me.move.up"));
        jPanel.add((Component)jButton3, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMoveDownButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("j2me.move.down"));
        jPanel.add((Component)jButton2, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("module.settings.midlets.properties.title"));
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myMIDletName = jTextField3 = new JTextField();
        jTextField3.setText("");
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMIDletVendor = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMIDletVersion = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, new Dimension(150, -1), new Dimension(150, -1), null));
        this.myMIDletNameLabel = jLabel4 = new JLabel();
        jLabel4.setText("");
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myMIDletJarUrlLabel = jLabel3 = new JLabel();
        jLabel3.setText("");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myMIDletVendorLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myMIDletVersionLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myMIDletJarUrl = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 8, 3, 3, 0, null, null, null));
        this.myOptionalSettingsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("module.settings.optional.settings"));
        jPanel2.add((Component)jButton, new GridConstraints(4, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public class AdditionalOptionsPanel
    extends DialogWrapper {
        private JPanel myCentrePanel;
        private JTextField myDeleteConfirmField;
        private JLabel myDeleteConfirm;
        private TextFieldWithBrowseButton myInstallNotifyURL;
        private JLabel myInstallNotify;
        private JTextField myDataSizeField;
        private JLabel myDataSize;
        private TextFieldWithBrowseButton myIconField;
        private JLabel myIcon;
        private JTextField myDescriptionField;
        private JLabel myDescription;
        private TextFieldWithBrowseButton myInfoURLField;
        private JLabel myInfoUrl;
        private JPanel myUserPanel;
        private UserKeysConfigurable myUserKeysConfigurable;

        public AdditionalOptionsPanel(Component parent) {
            super(parent, true);
            Object[] objectArray = new Object[]{};
            this.$$$setupUI$$$();
            this.setTitle(J2MEBundle.message("module.settings.optional.midp.settings", objectArray));
            this.init();
        }

        protected JComponent createCenterPanel() {
            this.myDataSize.setText("MIDlet-Data-Size:");
            this.myDataSizeField.setText((String)MIDPSettingsConfigurable.this.myTempSettings.get("MIDlet-Data-Size"));
            this.myDeleteConfirm.setText("MIDlet-Delete-Confirm:");
            this.myDeleteConfirmField.setText((String)MIDPSettingsConfigurable.this.myTempSettings.get("MIDlet-Delete-Confirm"));
            this.myDescription.setText("MIDlet-Description:");
            this.myDescriptionField.setText((String)MIDPSettingsConfigurable.this.myTempSettings.get("MIDlet-Description"));
            this.myIcon.setText("MIDlet-Icon:");
            String iconPath = (String)MIDPSettingsConfigurable.this.myTempSettings.get("MIDlet-Icon");
            if (iconPath != null) {
                String resourcePath = J2MEModuleProperties.getInstance(MIDPSettingsConfigurable.this.myModule).getResourcePath();
                this.myIconField.setText((resourcePath != null ? resourcePath : "") + File.separator + FileUtil.toSystemDependentName((String)iconPath));
            }
            this.myIconField.addBrowseFolderListener(J2MEBundle.message("module.settings.choose.icon.common", new Object[0]), J2MEBundle.message("module.settings.choose.icon", MIDPSettingsConfigurable.this.myMIDletName.getText()), MIDPSettingsConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            this.myInfoUrl.setText("MIDlet-Info-URL:");
            this.myInfoURLField.setText((String)MIDPSettingsConfigurable.this.myTempSettings.get("MIDlet-Info-URL"));
            this.myInfoURLField.addBrowseFolderListener(J2MEBundle.message("build.settings.file.url.title", new Object[0]), J2MEBundle.message("module.settings.application.url", new Object[0]), MIDPSettingsConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            this.myInstallNotify.setText("MIDlet-Install-Notify:");
            this.myInstallNotifyURL.setText((String)MIDPSettingsConfigurable.this.myTempSettings.get("MIDlet-Install-Notify"));
            this.myInstallNotifyURL.addBrowseFolderListener(J2MEBundle.message("build.settings.file.url.title", new Object[0]), J2MEBundle.message("module.settings.install.notify.url", new Object[0]), MIDPSettingsConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            this.myUserPanel.setLayout(new BorderLayout());
            this.myUserKeysConfigurable = new UserKeysConfigurable(MIDPSettingsConfigurable.this.myTempUserOptions);
            this.myUserPanel.add((Component)this.myUserKeysConfigurable.getUserKeysPanel(), "Center");
            return this.myCentrePanel;
        }

        protected void doOKAction() {
            this.myUserKeysConfigurable.getTable().stopEditing();
            MIDPSettingsConfigurable.this.myTempSettings.put("MIDlet-Data-Size", this.myDataSizeField.getText());
            MIDPSettingsConfigurable.this.myTempSettings.put("MIDlet-Delete-Confirm", this.myDeleteConfirmField.getText());
            MIDPSettingsConfigurable.this.myTempSettings.put("MIDlet-Description", this.myDescriptionField.getText());
            String iconPath = MIDPSettingsConfigurable.this.getRelativeIconPath(FileUtil.toSystemIndependentName((String)this.myIconField.getText()));
            if (iconPath == null) {
                return;
            }
            MIDPSettingsConfigurable.this.myTempSettings.put("MIDlet-Icon", iconPath);
            MIDPSettingsConfigurable.this.myTempSettings.put("MIDlet-Info-URL", this.myInfoURLField.getText());
            MIDPSettingsConfigurable.this.myTempSettings.put("MIDlet-Install-Notify", this.myInstallNotifyURL.getText());
            MIDPSettingsConfigurable.this.myTempUserOptions.clear();
            for (UserDefinedOption userDefinedOption : this.myUserKeysConfigurable.getUserDefinedOptions().getItems()) {
                MIDPSettingsConfigurable.this.myTempUserOptions.add(userDefinedOption);
            }
            MIDPSettingsConfigurable.this.myModified = true;
            super.doOKAction();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JTextField jTextField;
            JLabel jLabel2;
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JLabel jLabel3;
            JTextField jTextField2;
            JLabel jLabel4;
            TextFieldWithBrowseButton textFieldWithBrowseButton2;
            JLabel jLabel5;
            JTextField jTextField3;
            JLabel jLabel6;
            TextFieldWithBrowseButton textFieldWithBrowseButton3;
            JPanel jPanel;
            JPanel jPanel2;
            this.myCentrePanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myUserPanel = jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 0));
            jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myInstallNotifyURL = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
            jPanel2.add((Component)textFieldWithBrowseButton3, new GridConstraints(5, 1, 1, 1, 8, 3, 3, 0, null, null, null));
            this.myInstallNotify = jLabel6 = new JLabel();
            jLabel6.setText("");
            jPanel2.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, null, null));
            this.myDeleteConfirmField = jTextField3 = new JTextField();
            jPanel2.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myDeleteConfirm = jLabel5 = new JLabel();
            jLabel5.setText("");
            jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 4, 0, 0, 0, null, null, null));
            this.myInfoURLField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
            jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(3, 1, 1, 1, 8, 3, 3, 0, null, null, null));
            this.myInfoUrl = jLabel4 = new JLabel();
            jLabel4.setText("");
            jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 4, 0, 0, 0, null, null, null));
            this.myDataSizeField = jTextField2 = new JTextField();
            jPanel2.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myDataSize = jLabel3 = new JLabel();
            jLabel3.setText("");
            jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
            this.myIconField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 3, 3, 0, null, null, null));
            this.myIcon = jLabel2 = new JLabel();
            jLabel2.setText("");
            jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
            this.myDescriptionField = jTextField = new JTextField();
            jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myDescription = jLabel = new JLabel();
            jLabel.setText("");
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myCentrePanel;
        }
    }

    private class MIDletOptionsPanel
    extends DialogWrapper {
        private final JPanel myMIDletOptionsPanel;
        private final JPanel myLabelPanel;
        private final JPanel myFieldsPanel;
        private final TextFieldWithBrowseButton myMIDletClass;
        private final JLabel myClassLabel;
        private final TextFieldWithBrowseButton myMIDletIcon;
        private final JLabel myIconLabel;
        private final JTextField myMIDletName;
        private final JLabel myNameLabel;
        private MIDPSettings.MIDletProperty myMIDlet;
        private boolean myEditing;
        private final String relativeResources;

        public MIDletOptionsPanel(Component parent, MIDPSettings.MIDletProperty midlet, boolean isEditing) {
            super(parent, true);
            this.myMIDletOptionsPanel = new JPanel(new BorderLayout());
            this.myLabelPanel = new JPanel(new GridLayout(3, 1));
            this.myFieldsPanel = new JPanel(new GridLayout(3, 1));
            this.myMIDletClass = new TextFieldWithBrowseButton();
            this.myClassLabel = new JLabel(J2MEBundle.message("module.settings.midlet.class", new Object[0]));
            this.myMIDletIcon = new TextFieldWithBrowseButton();
            this.myIconLabel = new JLabel(J2MEBundle.message("module.settings.icon", new Object[0]));
            this.myMIDletName = new JTextField();
            this.myNameLabel = new JLabel(J2MEBundle.message("module.settings.midlet.name", new Object[0]));
            this.myEditing = false;
            this.relativeResources = J2MEModuleProperties.getInstance(MIDPSettingsConfigurable.this.myModule).getResourcePath();
            this.setTitle(midlet.getNumber());
            this.myMIDlet = midlet;
            this.init();
            this.myEditing = isEditing;
            if (!this.myEditing) {
                this.setOKActionEnabled(false);
            }
        }

        protected JComponent createCenterPanel() {
            this.myMIDletOptionsPanel.add((Component)this.myLabelPanel, "West");
            this.myMIDletOptionsPanel.add((Component)this.myFieldsPanel, "Center");
            this.myLabelPanel.add(this.myNameLabel);
            this.myMIDletName.setText(this.myMIDlet.getName());
            this.myFieldsPanel.add(this.myMIDletName);
            this.myLabelPanel.add(this.myIconLabel);
            if (this.relativeResources != null && this.myMIDlet.getIcon() != null) {
                this.myMIDletIcon.setText((this.relativeResources + this.myMIDlet.getIcon()).replace('/', File.separatorChar));
            }
            this.myMIDletIcon.addBrowseFolderListener(J2MEBundle.message("module.settings.choose.midlet.icon", new Object[0]), J2MEBundle.message("module.settings.choose.icon", this.myMIDletName.getText()), MIDPSettingsConfigurable.this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            this.myFieldsPanel.add((Component)this.myMIDletIcon);
            this.myLabelPanel.add(this.myClassLabel);
            this.myMIDletClass.setText(this.myMIDlet.getClassName());
            this.myFieldsPanel.add((Component)this.myMIDletClass);
            this.myMIDletClass.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    J2MEClassBrowser j2MEClassBrowser = new J2MEClassBrowser(MIDPSettingsConfigurable.this.myModule);
                    j2MEClassBrowser.show();
                    j2MEClassBrowser.setField(MIDletOptionsPanel.this.myMIDletClass);
                }
            });
            this.myMIDletClass.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (MIDletOptionsPanel.this.myMIDletName.getText() == null || MIDletOptionsPanel.this.myMIDletName.getText().length() == 0) {
                        MIDletOptionsPanel.this.myMIDletName.setText(MIDletOptionsPanel.this.myMIDletClass.getText());
                    }
                    MIDletOptionsPanel.this.update();
                }
            });
            this.myMIDletName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    MIDletOptionsPanel.this.update();
                }
            });
            JPanel whole = new JPanel(new BorderLayout());
            whole.add((Component)this.myMIDletOptionsPanel, "North");
            return whole;
        }

        private void update() {
            if (this.myMIDletName.getText() == null || this.myMIDletName.getText().length() == 0 || this.myMIDletClass.getText() == null || this.myMIDletClass.getText().length() == 0) {
                this.setOKActionEnabled(false);
            } else {
                this.setOKActionEnabled(true);
            }
        }

        protected void doOKAction() {
            String iconPath = MIDPSettingsConfigurable.this.getRelativeIconPath(FileUtil.toSystemIndependentName((String)this.myMIDletIcon.getText()));
            if (iconPath == null) {
                return;
            }
            this.myMIDlet = new MIDPSettings.MIDletProperty(this.myMIDletName.getText(), iconPath, this.myMIDletClass.getText(), this.myMIDlet.getNumber());
            if (this.myEditing) {
                MIDPSettingsConfigurable.this.myListModel.setElementAt(this.myMIDlet, MIDPSettingsConfigurable.this.myMIDletList.getSelectedIndex());
            } else {
                MIDPSettingsConfigurable.this.myListModel.addElement(this.myMIDlet);
            }
            MIDPSettingsConfigurable.this.myModified = true;
            super.doOKAction();
        }
    }
}

