/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.run.J2MEConfigurationType;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class J2MEConfigurationProducer
extends JavaRuntimeConfigurationProducerBase {
    private PsiClass myPsiClass;

    protected J2MEConfigurationProducer() {
        super((ConfigurationType)J2MEConfigurationType.getInstance());
    }

    public PsiElement getSourceElement() {
        return this.myPsiClass;
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        if ((location = J2MEConfigurationProducer.stepIntoSingleClass(location)) == null) {
            return null;
        }
        Project project = location.getProject();
        PsiElement element = location.getPsiElement();
        PsiClass aClass = J2MEConfigurationProducer.getMobileExeClass(element, PsiManager.getInstance((Project)project));
        if (aClass == null) {
            return null;
        }
        this.myPsiClass = aClass;
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(project, context);
        J2MERunConfiguration configuration = (J2MERunConfiguration)settings.getConfiguration();
        configuration.MAIN_CLASS_NAME = aClass.getQualifiedName();
        configuration.IS_CLASSES = true;
        configuration.userParameters = new ArrayList();
        configuration.setModule(ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(aClass.getContainingFile().getVirtualFile()));
        configuration.setGeneratedName();
        return settings;
    }

    public int compareTo(Object o) {
        return -1;
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        PsiClass aClass;
        if (existingConfigurations == null) {
            J2MEConfigurationProducer.$$$reportNull$$$0(0);
        }
        if ((aClass = J2MEConfigurationProducer.getMobileExeClass(location.getPsiElement(), PsiManager.getInstance((Project)location.getProject()))) != null) {
            String qualifiedName = aClass.getQualifiedName();
            for (RunnerAndConfigurationSettings existingConfiguration : existingConfigurations) {
                if (!Comparing.equal((String)qualifiedName, (String)((J2MERunConfiguration)existingConfiguration.getConfiguration()).MAIN_CLASS_NAME)) continue;
                return existingConfiguration;
            }
        }
        return null;
    }

    private static PsiClass getMobileExeClass(PsiElement element, PsiManager manager) {
        while (element != null) {
            PsiClass aClass;
            if (element instanceof PsiClass && J2MEConfigurationProducer.isMobileExeClass(aClass = (PsiClass)element, manager)) {
                return aClass;
            }
            element = element.getParent();
        }
        return null;
    }

    private static boolean isMobileExeClass(PsiClass aClass, PsiManager manager) {
        MobileApplicationType[] existingMobileApplicationTypes;
        if (DumbService.isDumb((Project)manager.getProject())) {
            return false;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true)) {
            return false;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
        for (MobileApplicationType mobileApplicationType : existingMobileApplicationTypes = MobileModuleUtil.getExistingMobileApplicationTypes()) {
            PsiClass mobileClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(mobileApplicationType.getBaseClassName(), scope);
            if (mobileClass == null || !aClass.isInheritor(mobileClass, true)) continue;
            return true;
        }
        return false;
    }

    public static Location stepIntoSingleClass(Location location) {
        PsiElement element = location.getPsiElement();
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null) {
            return location;
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiJavaFile.class)) == null) {
            return location;
        }
        PsiJavaFile psiFile = (PsiJavaFile)element;
        PsiClass[] classes = psiFile.getClasses();
        if (classes.length != 1) {
            return location;
        }
        return PsiLocation.fromPsiElement((PsiElement)classes[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "com/intellij/j2meplugin/run/J2MEConfigurationProducer", "findExistingByElement"));
    }
}

