/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run.states.doja;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;

public class DOJARunnableState
extends J2MERunnableState {
    public DOJARunnableState(RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSetting, J2MERunConfiguration configuration, Project project, Sdk projectJdk) {
        super(runnerSettings, configurationSetting, configuration, project, projectJdk);
    }

    @Override
    protected ProcessHandler getExecutionProcess(String availablePort) throws ExecutionException {
        Emulator emulator = (Emulator)this.myProjectJdk.getSdkAdditionalData();
        EmulatorType emulatorType = emulator.getEmulatorType();
        LOG.assertTrue(emulatorType != null);
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(emulatorType.getPathToEmulator(this.myProjectJdk.getHomePath()));
        if (this.myRunnerSettings instanceof DebuggingRunnerData) {
            generalCommandLine.addParameter("-debugger");
            generalCommandLine.addParameter("-suspend");
            generalCommandLine.addParameter("-port");
            generalCommandLine.addParameter(this.findFreePort());
            generalCommandLine.addParameter("-debugport");
            generalCommandLine.addParameter(availablePort);
            generalCommandLine.addParameter("-jdkpath");
            generalCommandLine.addParameter(emulator.getJavaSdk().getHomePath());
        }
        generalCommandLine.addParameter(emulatorType.getDescriptorOption());
        if (!this.myConfiguration.IS_CLASSES) {
            generalCommandLine.addParameter(this.myConfiguration.JAD_NAME);
        } else {
            Module module = this.myConfiguration.getModule();
            File tempJam = this.findFilesToDelete(module);
            generalCommandLine.addParameter(tempJam.getPath());
        }
        if (this.myConfiguration.TARGET_DEVICE_NAME != null && this.myConfiguration.TARGET_DEVICE_NAME.length() != 0) {
            generalCommandLine.addParameter(emulatorType.getDeviceOption());
            generalCommandLine.addParameter(this.myConfiguration.TARGET_DEVICE_NAME);
        }
        if (this.myConfiguration.COMMAND_LINE_PARAMETERS != null) {
            String[] params = this.myConfiguration.COMMAND_LINE_PARAMETERS.split(" ");
            for (int i = 0; params != null && i < params.length; ++i) {
                generalCommandLine.addParameter(params[i]);
            }
        }
        return new OSProcessHandler(generalCommandLine);
    }

    private String findFreePort() {
        try {
            return DebuggerUtils.getInstance().findAvailableDebugAddress(true);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

