/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.flex.build;

import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.AirDescriptorOptions;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.InfoFromConfigFile;
import com.intellij.flex.model.bc.JpsAirPackagingOptions;
import com.intellij.flex.model.bc.JpsAndroidPackagingOptions;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexDependencyEntry;
import com.intellij.flex.model.bc.JpsIosPackagingOptions;
import com.intellij.flex.model.bc.JpsLibraryDependencyEntry;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;

public class FlexBuilderUtils {
    public static String getCompilerName(JpsFlexBuildConfiguration bc) {
        String postfix;
        String string = postfix = bc.isTempBCForCompilation() ? " - " + FlexCommonUtils.getBCSpecifier((JpsFlexBuildConfiguration)bc) : "";
        if (!bc.getName().equals(bc.getModule().getName())) {
            postfix = postfix + " (module " + bc.getModule().getName() + ")";
        }
        return "[" + bc.getName() + postfix + "]";
    }

    public static void performPostCompileActions(CompileContext context, @NotNull JpsFlexBuildConfiguration bc, Collection<String> dirtyFilePaths, BuildOutputConsumer outputConsumer) throws ProjectBuildException {
        if (bc == null) {
            FlexBuilderUtils.$$$reportNull$$$0(0);
        }
        JpsSdk sdk = bc.getSdk();
        assert (sdk != null);
        LinkageType linkage = bc.getDependencies().getFrameworkLinkage();
        if (linkage == LinkageType.Default) {
            linkage = FlexCommonUtils.getDefaultFrameworkLinkage((String)sdk.getVersionString(), (BuildConfigurationNature)bc.getNature());
        }
        if (linkage == LinkageType.RSL) {
            // empty if block
        }
        if (bc.getOutputType() != OutputType.Application || FlexCommonUtils.isRLMTemporaryBC((JpsFlexBuildConfiguration)bc) || FlexCommonUtils.isRuntimeStyleSheetBC((JpsFlexBuildConfiguration)bc)) {
            return;
        }
        switch (bc.getTargetPlatform()) {
            case Web: {
                if (!bc.isUseHtmlWrapper()) break;
                FlexBuilderUtils.handleHtmlWrapper(context, bc, outputConsumer);
                break;
            }
            case Desktop: {
                FlexBuilderUtils.handleAirDescriptor(context, outputConsumer, dirtyFilePaths, bc, (JpsAirPackagingOptions)bc.getAirDesktopPackagingOptions());
                break;
            }
            case Mobile: {
                if (bc.getAndroidPackagingOptions().isEnabled()) {
                    FlexBuilderUtils.handleAirDescriptor(context, outputConsumer, dirtyFilePaths, bc, (JpsAirPackagingOptions)bc.getAndroidPackagingOptions());
                }
                if (!bc.getIosPackagingOptions().isEnabled()) break;
                FlexBuilderUtils.handleAirDescriptor(context, outputConsumer, dirtyFilePaths, bc, (JpsAirPackagingOptions)bc.getIosPackagingOptions());
            }
        }
    }

    private static void handleHtmlWrapper(CompileContext context, JpsFlexBuildConfiguration bc, BuildOutputConsumer outputConsumer) {
        File templateDir = new File(bc.getWrapperTemplatePath());
        if (!templateDir.isDirectory()) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"html.wrapper.dir.not.found", (Object[])new Object[]{bc.getWrapperTemplatePath()})));
            return;
        }
        File templateFile = new File(templateDir, "index.template.html");
        if (!templateFile.isFile()) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"no.index.template.html.file", (Object[])new Object[]{bc.getWrapperTemplatePath()})));
            return;
        }
        InfoFromConfigFile info = InfoFromConfigFile.getInfoFromConfigFile((String)bc.getCompilerOptions().getAdditionalConfigFilePath());
        String outputFolderPath = StringUtil.notNullize((String)info.getOutputFolderPath(), (String)bc.getOutputFolder());
        String outputFileName = bc.isTempBCForCompilation() ? bc.getOutputFileName() : StringUtil.notNullize((String)info.getOutputFileName(), (String)bc.getOutputFileName());
        String targetPlayer = StringUtil.notNullize((String)info.getTargetPlayer(), (String)bc.getDependencies().getTargetPlayer());
        File outputDir = new File(outputFolderPath);
        if (!outputDir.isDirectory()) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"output.folder.does.not.exist", (Object[])new Object[]{outputFolderPath})));
            return;
        }
        for (File file : templateDir.listFiles()) {
            if ("index.template.html".equals(file.getName())) {
                String wrapperText;
                JpsEncodingProjectConfiguration encodingConfiguration = JpsEncodingConfigurationService.getInstance().getEncodingConfiguration(bc.getModule().getProject());
                String encoding = encodingConfiguration == null ? null : encodingConfiguration.getEncoding(file);
                try {
                    try {
                        wrapperText = FileUtil.loadFile((File)file, (String)encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        wrapperText = FileUtil.loadFile((File)file);
                    }
                }
                catch (IOException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.load.template.file", (Object[])new Object[]{file.getPath(), e.getMessage()})));
                    return;
                }
                if (!wrapperText.contains("${swf}")) {
                    context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"no.swf.macro", (Object[])new Object[]{file.getPath()})));
                    return;
                }
                String mainClass = StringUtil.notNullize((String)info.getMainClass((JpsModule)bc.getModule()), (String)bc.getMainClass());
                String fixedText = FlexBuilderUtils.replaceMacros(wrapperText, FileUtil.getNameWithoutExtension((String)outputFileName), targetPlayer, FlexCommonUtils.getPathToMainClassFile((String)mainClass, (JpsModule)bc.getModule()));
                String wrapperFileName = FlexCommonUtils.getWrapperFileName((JpsFlexBuildConfiguration)bc);
                try {
                    byte[] bytes;
                    try {
                        bytes = encoding == null ? fixedText.getBytes() : fixedText.getBytes(encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        bytes = fixedText.getBytes();
                    }
                    File outputFile = new File(outputDir, wrapperFileName);
                    FileUtil.writeToFile((File)outputFile, (byte[])bytes);
                    outputConsumer.registerOutputFile(outputFile, Collections.singletonList(file.getPath()));
                }
                catch (IOException e) {
                    context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.create.file.in", (Object[])new Object[]{wrapperFileName, outputDir.getPath(), e.getMessage()})));
                }
                continue;
            }
            try {
                File outputFile = new File(outputDir, file.getName());
                if (file.isDirectory()) {
                    FileUtil.createDirectory((File)outputFile);
                    FileUtil.copyDir((File)file, (File)outputFile);
                } else {
                    FileUtil.copy((File)file, (File)outputFile);
                }
                outputConsumer.registerOutputFile(outputFile, Collections.singletonList(file.getPath()));
            }
            catch (IOException e) {
                context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.copy.file", (Object[])new Object[]{file.getName(), templateDir.getPath(), outputDir.getPath(), e.getMessage()})));
            }
        }
    }

    private static String replaceMacros(String wrapperText, String outputFileName, String targetPlayer, String mainClassPath) {
        THashMap replacementMap = new THashMap();
        replacementMap.put("${swf}", outputFileName);
        replacementMap.put("${title}", outputFileName);
        replacementMap.put("${application}", outputFileName);
        replacementMap.put("${bgcolor}", "#ffffff");
        replacementMap.put("${width}", "100%");
        replacementMap.put("${height}", "100%");
        List versionParts = StringUtil.split((String)targetPlayer, (String)".");
        replacementMap.put("${version_major}", versionParts.size() >= 1 ? (String)versionParts.get(0) : "0");
        replacementMap.put("${version_minor}", versionParts.size() >= 2 ? (String)versionParts.get(1) : "0");
        replacementMap.put("${version_revision}", versionParts.size() >= 3 ? (String)versionParts.get(2) : "0");
        String swfMetadata = null;
        File mainClassFile = new File(mainClassPath);
        if (mainClassFile.isFile()) {
            try {
                if (FileUtilRt.extensionEquals((String)mainClassPath, (String)"mxml")) {
                    Element rootElement = JDOMUtil.load((File)mainClassFile);
                    Element metadataElement = rootElement.getChild("Metadata", Namespace.getNamespace((String)"http://www.adobe.com/2006/mxml"));
                    if (metadataElement == null) {
                        metadataElement = rootElement.getChild("Metadata", Namespace.getNamespace((String)"http://ns.adobe.com/mxml/2009"));
                    }
                    if (metadataElement != null) {
                        swfMetadata = FlexBuilderUtils.getSwfMetadata(metadataElement.getTextNormalize());
                    }
                } else if (FileUtilRt.extensionEquals((String)mainClassPath, (String)"as")) {
                    swfMetadata = FlexBuilderUtils.getSwfMetadata(FileUtil.loadFile((File)mainClassFile));
                }
            }
            catch (IOException | JDOMException rootElement) {
                // empty catch block
            }
        }
        Map<String, String> attributesMap = FlexBuilderUtils.getAttributesMap(swfMetadata);
        ContainerUtil.putIfNotNull((Object)"${title}", (Object)attributesMap.get("pageTitle"), (Map)replacementMap);
        ContainerUtil.putIfNotNull((Object)"${bgcolor}", (Object)attributesMap.get("backgroundColor"), (Map)replacementMap);
        ContainerUtil.putIfNotNull((Object)"${width}", (Object)attributesMap.get("width"), (Map)replacementMap);
        ContainerUtil.putIfNotNull((Object)"${height}", (Object)attributesMap.get("height"), (Map)replacementMap);
        return FlexCommonUtils.replace((String)wrapperText, (Map)replacementMap);
    }

    @Nullable
    private static String getSwfMetadata(String text) {
        int swfIndex = -1;
        while ((swfIndex = text.indexOf("[SWF", swfIndex + 1)) > -1) {
            String textBefore = text.substring(0, swfIndex);
            int lfIndex = Math.max(textBefore.lastIndexOf(10), textBefore.lastIndexOf(13));
            int lineCommentIndex = textBefore.lastIndexOf("//");
            if (lineCommentIndex > lfIndex) continue;
            int endIndex = text.indexOf(93, swfIndex);
            return endIndex > swfIndex ? text.substring(swfIndex, endIndex + 1) : null;
        }
        return null;
    }

    private static Map<String, String> getAttributesMap(String metadata) {
        if (metadata == null) {
            return Collections.emptyMap();
        }
        THashMap result = new THashMap();
        int beginIndex = metadata.indexOf(40);
        int endIndex = metadata.lastIndexOf(41);
        if (endIndex > beginIndex) {
            for (String attribute : StringUtil.split((String)metadata.substring(beginIndex + 1, endIndex), (String)",")) {
                int eqIndex = attribute.indexOf(61);
                if (eqIndex <= 0) continue;
                String name = attribute.substring(0, eqIndex).trim();
                String value = StringUtil.stripQuotesAroundValue((String)attribute.substring(eqIndex + 1).trim());
                result.put((Object)name, (Object)value);
            }
        }
        return result;
    }

    private static void handleAirDescriptor(CompileContext context, BuildOutputConsumer outputConsumer, Collection<String> dirtyFilePaths, JpsFlexBuildConfiguration bc, JpsAirPackagingOptions packagingOptions) {
        if (packagingOptions.isUseGeneratedDescriptor()) {
            boolean android = packagingOptions instanceof JpsAndroidPackagingOptions;
            boolean ios = packagingOptions instanceof JpsIosPackagingOptions;
            String descriptorFileName = FlexCommonUtils.getGeneratedAirDescriptorName((JpsFlexBuildConfiguration)bc, (JpsAirPackagingOptions)packagingOptions);
            FlexBuilderUtils.generateAirDescriptor(context, outputConsumer, dirtyFilePaths, bc, descriptorFileName, android, ios);
        } else {
            FlexBuilderUtils.copyAndFixCustomAirDescriptor(context, outputConsumer, bc, packagingOptions);
        }
    }

    private static void generateAirDescriptor(CompileContext context, BuildOutputConsumer outputConsumer, Collection<String> dirtyFilePaths, JpsFlexBuildConfiguration bc, String descriptorFileName, boolean android, boolean ios) {
        JpsSdk sdk = bc.getSdk();
        assert (sdk != null);
        String outputFilePath = bc.getActualOutputFilePath();
        String outputFolderPath = PathUtilRt.getParentPath((String)outputFilePath);
        File outputFolder = new File(outputFolderPath);
        if (!outputFolder.isDirectory()) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"output.folder.does.not.exist", (Object[])new Object[]{outputFolder.getPath()})));
            return;
        }
        String airVersion = FlexCommonUtils.getAirVersion((String)sdk.getHomePath(), (String)sdk.getVersionString());
        if (airVersion == null) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.get.air.sdk.version.use.custom.descriptor", (Object[])new Object[0])));
            return;
        }
        String appId = FlexCommonUtils.fixApplicationId((String)bc.getMainClass());
        String appName = StringUtil.getShortName((String)bc.getMainClass());
        String swfName = PathUtilRt.getFileName((String)outputFilePath);
        String[] extensions = FlexBuilderUtils.getAirExtensionIDs(bc);
        try {
            AirDescriptorOptions descriptorOptions = new AirDescriptorOptions(airVersion, appId, appName, swfName, extensions, android, ios);
            String descriptorText = descriptorOptions.getAirDescriptorText();
            File outputFile = new File(outputFolder, descriptorFileName);
            FileUtil.writeToFile((File)outputFile, (String)descriptorText);
            outputConsumer.registerOutputFile(outputFile, dirtyFilePaths);
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.generate.air.descriptor", (Object[])new Object[]{e.getMessage()})));
        }
    }

    private static Collection<File> getANEFiles(JpsFlexBuildConfiguration bc) {
        ArrayList<File> result = new ArrayList<File>();
        for (JpsFlexDependencyEntry entry : bc.getDependencies().getEntries()) {
            JpsLibrary library;
            if (!(entry instanceof JpsLibraryDependencyEntry) || (library = ((JpsLibraryDependencyEntry)entry).getLibrary()) == null) continue;
            for (File libFile : library.getFiles(JpsOrderRootType.COMPILED)) {
                if (!libFile.isFile() || !FileUtilRt.extensionEquals((String)libFile.getName(), (String)"ane")) continue;
                result.add(libFile);
            }
        }
        return result;
    }

    private static String[] getAirExtensionIDs(JpsFlexBuildConfiguration bc) {
        ArrayList result = new ArrayList();
        for (File aneFile : FlexBuilderUtils.getANEFiles(bc)) {
            String extensionId = FlexBuilderUtils.getExtensionId(aneFile);
            ContainerUtil.addIfNotNull(result, (Object)extensionId);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getExtensionId(File aneFile) {
        try (ZipFile zipFile = new ZipFile(aneFile);){
            ZipEntry entry = zipFile.getEntry("META-INF/ANE/extension.xml");
            if (entry == null) return null;
            InputStream is = zipFile.getInputStream(entry);
            String string = FlexCommonUtils.findXMLElement((InputStream)is, (String)"<extension><id>");
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void copyAndFixCustomAirDescriptor(CompileContext context, BuildOutputConsumer outputConsumer, JpsFlexBuildConfiguration bc, JpsAirPackagingOptions packagingOptions) {
        String content;
        String customDescriptorPath = packagingOptions.getCustomDescriptorPath();
        File descriptorTemplateFile = new File(customDescriptorPath);
        if (!descriptorTemplateFile.isFile()) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"air.descriptor.not.found", (Object[])new Object[]{customDescriptorPath})));
            return;
        }
        String outputFilePath = bc.getActualOutputFilePath();
        String outputFolderPath = PathUtilRt.getParentPath((String)outputFilePath);
        File outputFolder = new File(outputFolderPath);
        if (!outputFolder.isDirectory()) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"output.folder.does.not.exist", (Object[])new Object[]{outputFolder.getPath()})));
            return;
        }
        try {
            content = FlexBuilderUtils.fixInitialContent(descriptorTemplateFile, PathUtilRt.getFileName((String)outputFilePath));
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.open.air.descriptor", (Object[])new Object[]{descriptorTemplateFile.getPath(), e.getMessage()})));
            return;
        }
        catch (JDOMException e) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"incorrect.air.descriptor.content", (Object[])new Object[]{descriptorTemplateFile.getPath(), e.getMessage()})));
            return;
        }
        try {
            String descriptorFileName = bc.isTempBCForCompilation() ? FlexCommonUtils.getGeneratedAirDescriptorName((JpsFlexBuildConfiguration)bc, (JpsAirPackagingOptions)packagingOptions) : descriptorTemplateFile.getName();
            File outputFile = new File(outputFolder, descriptorFileName);
            FileUtil.writeToFile((File)outputFile, (byte[])content.getBytes("UTF-8"));
            outputConsumer.registerOutputFile(outputFile, Collections.singletonList(descriptorTemplateFile.getPath()));
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(FlexBuilderUtils.getCompilerName(bc), BuildMessage.Kind.ERROR, FlexCommonBundle.message((String)"failed.to.copy.air.descriptor", (Object[])new Object[]{e.getMessage()})));
        }
    }

    private static String fixInitialContent(File descriptorFile, String swfName) throws IOException, JDOMException {
        Element contentElement;
        String descriptorContent = FileUtil.loadFile((File)descriptorFile, (String)"UTF-8");
        Element rootElement = JDOMUtil.load((CharSequence)StringUtil.trimStart((String)descriptorContent, (String)"\ufeff"));
        if (!"application".equals(rootElement.getName())) {
            throw new JDOMException("incorrect root tag");
        }
        Element initialWindowElement = rootElement.getChild("initialWindow", rootElement.getNamespace());
        if (initialWindowElement == null) {
            initialWindowElement = new Element("initialWindow", rootElement.getNamespace());
            rootElement.addContent(initialWindowElement);
        }
        if ((contentElement = initialWindowElement.getChild("content", rootElement.getNamespace())) == null) {
            contentElement = new Element("content", rootElement.getNamespace());
            initialWindowElement.addContent(contentElement);
        }
        contentElement.setText(swfName);
        return JDOMUtil.write((Parent)rootElement, (String)SystemProperties.getLineSeparator());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/jps/flex/build/FlexBuilderUtils", "performPostCompileActions"));
    }
}

