/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.diagram.managers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.UmlNodeHighlighter;
import com.intellij.jboss.jbpm.diagram.beans.wrappers.BpmnElementWrapper;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BpmnUmlNodeHighlighter
implements UmlNodeHighlighter<BpmnElementWrapper> {
    public List<DiagramNode<BpmnElementWrapper>> onNodeSelected(List<DiagramNode<BpmnElementWrapper>> selectedNodes, DiagramDataModel<BpmnElementWrapper> model) {
        if (selectedNodes.size() != 1) {
            return Collections.emptyList();
        }
        SmartList highlightNodes = new SmartList();
        BpmnUmlNodeHighlighter.collectNodes((List<DiagramNode<BpmnElementWrapper>>)highlightNodes, new HashSet<DiagramEdge<BpmnElementWrapper>>(), model, (DiagramNode<BpmnElementWrapper>)((DiagramNode)ContainerUtil.getFirstItem(selectedNodes)));
        return highlightNodes;
    }

    private static void collectNodes(List<DiagramNode<BpmnElementWrapper>> highlightNodes, Collection<DiagramEdge<BpmnElementWrapper>> visitedEdges, DiagramDataModel<BpmnElementWrapper> model, DiagramNode<BpmnElementWrapper> node) {
        List<DiagramEdge<BpmnElementWrapper>> outgoingEdges = BpmnUmlNodeHighlighter.getOutgoingEdges(model, node);
        if (outgoingEdges.isEmpty()) {
            highlightNodes.add(node);
            return;
        }
        for (DiagramEdge<BpmnElementWrapper> edge : outgoingEdges) {
            if (visitedEdges.contains(edge)) continue;
            highlightNodes.add(node);
            visitedEdges.add(edge);
            BpmnUmlNodeHighlighter.collectNodes(highlightNodes, visitedEdges, model, (DiagramNode<BpmnElementWrapper>)edge.getTarget());
        }
    }

    private static List<DiagramEdge<BpmnElementWrapper>> getOutgoingEdges(DiagramDataModel<BpmnElementWrapper> model, DiagramNode<BpmnElementWrapper> node) {
        return ContainerUtil.findAll((Collection)model.getEdges(), edge -> edge.getSource().equals(node));
    }

    public void selectionChanged(DiagramBuilder builder) {
    }
}

