/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting;

import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.SpringAopProvider;
import com.intellij.spring.contexts.model.XmlSpringModel;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.highlighting.EnableAspectJQuickFix;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MissingAspectjAutoproxyInspection
extends LocalInspectionTool {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)SpringLibraryUtil.SpringVersion.V_2_5)) {
                return null;
            }
            for (PsiClass aClass : ((PsiJavaFile)file).getClasses()) {
                LocalQuickFix[] localQuickFixArray;
                SpringAopProvider provider;
                AopAdvisedElementsSearcher searcher;
                PsiJavaCodeReferenceElement annoName;
                PsiModifierList modifierList = aClass.getModifierList();
                if (modifierList == null) continue;
                PsiAnnotation annotation = modifierList.findAnnotation("org.aspectj.lang.annotation.Aspect");
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = annoName = annotation == null ? null : annotation.getNameReferenceElement();
                if (annoName == null || !((searcher = (provider = (SpringAopProvider)((Object)Extensions.findExtension((ExtensionPointName)AopProvider.EXTENSION_POINT_NAME, SpringAopProvider.class))).getAdvisedElementsSearcher(aClass)) instanceof SpringAdvisedElementsSearcher)) continue;
                CommonSpringModel model = ((SpringAdvisedElementsSearcher)searcher).getSpringModel();
                PsiClass aspectJAutoProxy = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator");
                if (aspectJAutoProxy != null && MissingAspectjAutoproxyInspection.isAspectJSupportEnabled(model, aspectJAutoProxy)) continue;
                List<XmlSpringModel> models = SpringAdvisedElementsSearcher.findXmlModels(model);
                if (models.isEmpty()) {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                } else {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = new EnableAspectJQuickFix((CommonSpringModel)models.iterator().next());
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)annoName, SpringAopBundle.message("aop.warning.aspectj.isnt.enabled", new Object[0]), isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
            }
        }
        return super.checkFile(file, manager, isOnTheFly);
    }

    @NotNull
    public String getShortName() {
        if ("MissingAspectjAutoproxyInspection" == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(2);
        }
        return "MissingAspectjAutoproxyInspection";
    }

    public static boolean isAspectJSupportEnabled(CommonSpringModel model, @NotNull PsiClass aspectJBeanClass) {
        if (aspectJBeanClass == null) {
            MissingAspectjAutoproxyInspection.$$$reportNull$$$0(3);
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)aspectJBeanClass);
        for (XmlSpringModel xmlModel : SpringAdvisedElementsSearcher.findXmlModels(model)) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)xmlModel, (SpringModelSearchParameters.BeanClass)searchParameters)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/MissingAspectjAutoproxyInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aspectJBeanClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/MissingAspectjAutoproxyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAspectJSupportEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

