/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.DbSrcMigration;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DeleteQueryGenerator;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DbBatchIndicesDialog;
import com.intellij.database.view.ui.DbObjectDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.database.view.ui.DeleteDialog;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlActions {
    private static void deleteDataSources(@NotNull Project project, @NotNull Set<DbDataSource> dataSources2) {
        String message;
        if (project == null) {
            DdlActions.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            DdlActions.$$$reportNull$$$0(1);
        }
        if (dataSources2.size() == 1) {
            DbDataSource element = dataSources2.iterator().next();
            message = DatabaseMessages.message((String)"confirmation.text.remove.data.source", (Object[])new Object[]{element.getName()});
        } else {
            StringBuilder sb = new StringBuilder("The following data sources will be removed:\n");
            int i2 = 0;
            for (DbDataSource o : dataSources2) {
                if (i2++ > 0) {
                    sb.append(",").append(i2 % 3 == 1 ? "\n" : " ");
                }
                sb.append(o.getName());
            }
            message = sb.toString();
        }
        int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)"Confirmation", (Icon)Messages.getWarningIcon());
        if (ret != 0) {
            return;
        }
        DdlActions.closeAllFilesBeforeDataSourceRemoval(project, dataSources2);
        for (DbDataSource o : dataSources2) {
            o.getDbManager().removeDataSource(o);
        }
    }

    public static void closeAllFilesBeforeDataSourceRemoval(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            DdlActions.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DdlActions.$$$reportNull$$$0(3);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            DbDataSource dataSource = DbImplUtil.findDataSource(project, virtualFile);
            if (!elements.contains(dataSource)) continue;
            fileEditorManager.closeFile(virtualFile);
        }
    }

    @NotNull
    static Pair<DbTable, Set<DbColumn>> getTableAndColumns(AnActionEvent e) {
        DbTable tableElement;
        Set<Object> columns2 = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
        Set tables = ContainerUtil.map2Set(columns2, (Function)((NullableFunction)element -> element.getParent()));
        DbTable dbTable = tableElement = tables.size() == 1 ? (DbTable)tables.iterator().next() : null;
        if (tableElement == null) {
            Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement element2 = selection.size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element2, DbTable.class, (boolean)false);
            columns2 = Collections.emptySet();
        }
        Pair pair = Pair.create((Object)tableElement, columns2);
        if (pair == null) {
            DdlActions.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DdlActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DdlActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableAndColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "closeAllFilesBeforeDataSourceRemoval";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DropForeignKeyAction
    extends DumbAwareAction {
        public DropForeignKeyAction() {
            super("Drop Foreign Key", "Drop foreign key from selected column", DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbColumn> selection;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(0);
            }
            DbColumn column = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class)).size() == 1 ? (DbColumn)ContainerUtil.getFirstItem(selection) : null;
            boolean visible = column != null && DbImplUtil.getDatabaseDialect((DbElement)column).supportsDropForeignKey() && DbImplUtil.canConnectTo((DbElement)column) && DasUtil.isForeign((DasColumn)column);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)column));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbColumn column;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(1);
            }
            if ((column = (DbColumn)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class))) == null) {
                return;
            }
            SearchPath searchPath = SearchPath.of((DasObject)DbImplUtil.getSearchPathObject((DbElement)column));
            DeleteDialog dialog = new DeleteDialog(column.getProject(), column.getDataSource(), searchPath, DropForeignKeyAction.getStatement(column));
            if (dialog.showAndGet()) {
                DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(column.getDataSource(), searchPath).setStatement(dialog.getStatement());
                handler.getContext().include(column.getParent());
                handler.runStatements(false);
            }
        }

        private static String getStatement(@NotNull DbColumn column) {
            if (column == null) {
                DropForeignKeyAction.$$$reportNull$$$0(2);
            }
            DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)column, false);
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)column);
            DbTable table = column.getParent();
            if (table != null) {
                for (DasForeignKey key2 : DasUtil.getForeignKeys((DasTable)table)) {
                    if (!DasUtil.containsName((String)column.getName(), (MultiRef)key2.getColumnsRef())) continue;
                    dialect.sqlDropForeignKey(builder, (DasTable)table, key2, key2.getName()).newStatement();
                }
            }
            return DatabaseDialogsHelper.concatQueries(builder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DropPrimaryKeyAction
    extends DumbAwareAction {
        public DropPrimaryKeyAction() {
            super("Drop Primary Key", "Drop primary key from selected table", DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            DbElement element = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbTable tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element, DbTable.class, (boolean)false);
            boolean visible = tableElement != null && DbImplUtil.getDatabaseDialect((DbElement)tableElement).supportsDropPrimaryKey() && DbImplUtil.canConnectTo((DbElement)tableElement) && DasUtil.getPrimaryKey((DasTable)tableElement) != null;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)tableElement));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element;
            DbTable table;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class))), DbTable.class, (boolean)false)) == null) {
                return;
            }
            DbTableKey pk = (DbTableKey)DasUtil.getPrimaryKey((DasTable)table);
            if (pk == null) {
                return;
            }
            SearchPath searchPath = SearchPath.of((DasObject)DbImplUtil.getSearchPathObject(element));
            DeleteDialog dialog = new DeleteDialog(pk.getProject(), element.getDataSource(), searchPath, DropPrimaryKeyAction.generateStatement(pk));
            if (dialog.showAndGet()) {
                DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(table.getDataSource(), searchPath).setStatement(dialog.getStatement());
                handler.getContext().include(table);
                handler.getContext().setElementToFocus(element);
                handler.runStatements(false);
            }
        }

        private static String generateStatement(@NotNull DbTableKey pk) {
            if (pk == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(2);
            }
            DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)pk, false);
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)pk);
            dialect.sqlDropPrimaryKey(builder, (DasTableKey)pk);
            return DatabaseDialogsHelper.concatQueries(builder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pk";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generateStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddForeignKeyAction
    extends DumbAwareAction {
        public AddForeignKeyAction() {
            super("_Foreign Key", "Add new foreign key to selected table", DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddForeignKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            if (table == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                Ref newFk = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, (Iterable)pair.second))).addAndGet((Ref<DeForeignKey>)newFk)).leave()).commit();
                return (DeObject)newFk.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddPrimaryKeyAction
    extends DumbAwareAction {
        public AddPrimaryKeyAction() {
            super("_Primary Key", "Add new primary key to selected table", DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DbImplUtil.getDatabaseDialect((DbElement)pair.first).supportsAddPrimaryKey() && DasUtil.getPrimaryKey((DasTable)((DasTable)pair.first)) == null && ((DbTable)pair.first).getKind() == ObjectKind.TABLE && !((Set)pair.second).isEmpty();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            if (pair.first == null) {
                return;
            }
            DbTable table = (DbTable)pair.first;
            Set columns2 = (Set)pair.second;
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                Ref newKey = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)((TableModelBuilder.TableKeyModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withKey("")).setPrimary(true, false))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns2), DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)newKey)).leave()).commit();
                return (DeObject)newKey.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchAddIndicesAction
    extends DumbAwareAction {
        public BatchAddIndicesAction() {
            super("Indice_s Per Column", "Add separate indices for selected columns", DatabaseIcons.Index);
        }

        @NotNull
        private static List<DbColumn> getColumns(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(0);
            }
            Set<DbColumn> columns2 = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
            DbDataSource dataSource = null;
            for (DbColumn column : columns2) {
                if (dataSource == null) {
                    dataSource = column.getDataSource();
                }
                if (dataSource == column.getDataSource()) continue;
                List<DbColumn> list = Collections.emptyList();
                if (list == null) {
                    BatchAddIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList arrayList = ContainerUtil.newArrayList(columns2);
            if (arrayList == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        public void update(@NotNull AnActionEvent e) {
            List<DbColumn> columns2;
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(3);
            }
            boolean visible = (columns2 = BatchAddIndicesAction.getColumns(e)).size() > 1 && DbImplUtil.canConnectTo((DbElement)columns2.get(0)) && DbBatchIndicesDialog.canAddAnything(new DatabaseEditorContext((DbElement)columns2.get(0), null), columns2);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)columns2.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbColumn> columns2;
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(4);
            }
            if ((columns2 = BatchAddIndicesAction.getColumns(e)).size() < 2) {
                return;
            }
            DbBatchIndicesDialog.newBatchAddIndicesDialog(new DatabaseEditorContext((DbElement)columns2.get(0), null), columns2).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumns";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddIndexAction
    extends DumbAwareAction {
        public AddIndexAction() {
            super("_Index", "Add new index for selected columns", DatabaseIcons.Index);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddIndex(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            Set columns2 = (Set)pair.second;
            DbTable table = (DbTable)pair.first;
            if (table == null || columns2 == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                Ref newIndex = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns2), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)newIndex)).leave()).commit();
                return (DeObject)newIndex.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddIndexAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddColumnAction
    extends DumbAwareAction {
        public AddColumnAction() {
            super("_Column", "Add new column to selected table", DatabaseIcons.Col);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(0);
            }
            DbElement element = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbTable table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element, DbTable.class, (boolean)false);
            boolean visible = table != null && DbImplUtil.getDatabaseDialect((DbElement)table).supportsAddColumn() && DbImplUtil.canConnectTo((DbElement)table) && table.getKind() == ObjectKind.TABLE;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)table));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element;
            DbTable table;
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class))), DbTable.class, (boolean)false)) == null) {
                return;
            }
            AddColumnAction.perform(table, (DbColumn)PsiTreeUtil.getParentOfType((PsiElement)element, DbColumn.class, (boolean)false), "new_column");
        }

        public static void perform(@NotNull DbTable table, @Nullable DbColumn anchor, @NotNull String colName) {
            if (table == null) {
                AddColumnAction.$$$reportNull$$$0(2);
            }
            if (colName == null) {
                AddColumnAction.$$$reportNull$$$0(3);
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                if (colName == null) {
                    AddColumnAction.$$$reportNull$$$0(4);
                }
                List<DeColumn> columns2 = ((DatabaseTableEditor)dialog.getEditor()).getTable().columns;
                int idx = columns2.size();
                if (anchor != null && ((DatabaseTableEditor)dialog.getEditor()).getCaps().getColumns().canReorder()) {
                    String name = anchor.getName();
                    idx = 0;
                    for (DeColumn column : columns2) {
                        ++idx;
                        if (!column.name.equals(name)) continue;
                        break;
                    }
                }
                Ref newCol = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withColumn(colName)).addAndGet((Ref<DeColumn>)newCol, idx)).leave()).commit();
                return (DeObject)newCol.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddColumnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$perform$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddSchemaAction
    extends DumbAwareAction {
        public AddSchemaAction() {
            super("_Schema", "Add new schema to selected database", DatabaseIcons.Schema);
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement parent;
            if (e == null) {
                AddSchemaAction.$$$reportNull$$$0(0);
            }
            DbDataSource dataSource = (parent = AddSchemaAction.getSchemaParent(e)) == null ? null : parent.getDataSource();
            boolean visible = dataSource != null && DbImplUtil.getDatabaseDialect((DbElement)dataSource).supportsCreateSchema() && DbImplUtil.canConnectTo((DbElement)dataSource);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)dataSource));
        }

        @Nullable
        private static DbElement getSchemaParent(@NotNull AnActionEvent e) {
            DbDataSource dataSource;
            Set<DbElement> selection;
            if (e == null) {
                AddSchemaAction.$$$reportNull$$$0(1);
            }
            DbElement element = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbNamespaceImpl parent = DatabaseView.getLowestSchema(element);
            parent = (DbElement)DasUtil.dasParents((DasObject)parent).filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter(DbElement.class).first();
            DbDataSource dbDataSource = dataSource = element == null ? null : element.getDataSource();
            if (parent == null) {
                parent = dataSource;
            }
            return parent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement parent;
            if (e == null) {
                AddSchemaAction.$$$reportNull$$$0(2);
            }
            if ((parent = AddSchemaAction.getSchemaParent(e)) == null) {
                return;
            }
            AddSchemaAction.perform(parent, "new_schema");
        }

        public static void perform(@NotNull DbElement parent, @NotNull String schemaName) {
            if (parent == null) {
                AddSchemaAction.$$$reportNull$$$0(3);
            }
            if (schemaName == null) {
                AddSchemaAction.$$$reportNull$$$0(4);
            }
            DbObjectDialog dialog = DbRefactoringDialogHelper.newAddObjectDialog(new DatabaseEditorContext(parent, null), (DasNamespace)ObjectUtils.tryCast((Object)parent, DasNamespace.class), schemaName, ObjectKind.SCHEMA);
            dialog.finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemaName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddSchemaAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSchemaParent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddDatabaseAction
    extends DumbAwareAction {
        public AddDatabaseAction() {
            super("_Database", "Add new database to selected data source", DatabaseIcons.Database);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                AddDatabaseAction.$$$reportNull$$$0(0);
            }
            DbElement element = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbDataSource dataSource = element == null ? null : element.getDataSource();
            boolean visible = dataSource != null && DbImplUtil.getDatabaseDialect((DbElement)dataSource).supportsCreateDatabase() && DbImplUtil.canConnectTo((DbElement)dataSource);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)dataSource));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element;
            DbDataSource dataSource;
            if (e == null) {
                AddDatabaseAction.$$$reportNull$$$0(1);
            }
            DbDataSource dbDataSource = dataSource = (element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class))) == null ? null : element.getDataSource();
            if (dataSource == null) {
                return;
            }
            AddDatabaseAction.perform(dataSource, "new_database");
        }

        public static void perform(@NotNull DbDataSource dataSource, @NotNull String databaseName) {
            if (dataSource == null) {
                AddDatabaseAction.$$$reportNull$$$0(2);
            }
            if (databaseName == null) {
                AddDatabaseAction.$$$reportNull$$$0(3);
            }
            DbObjectDialog dialog = DbRefactoringDialogHelper.newAddObjectDialog(new DatabaseEditorContext((DbElement)dataSource, null), null, databaseName, ObjectKind.DATABASE);
            dialog.finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "databaseName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddDatabaseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchModifyIndicesAction
    extends DumbAwareAction {
        public BatchModifyIndicesAction() {
            super("Modify Indices", "Batch Modify Indices", null);
        }

        @NotNull
        private static List<DbIndex> getIndicesToModify(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(0);
            }
            Set<DbIndex> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbIndex.class);
            DbDataSource dataSource = null;
            for (DbIndex element : elements) {
                DbDataSource currentSource = element.getDataSource();
                if (dataSource == null) {
                    dataSource = currentSource;
                }
                if (dataSource == currentSource) continue;
                List<DbIndex> list = Collections.emptyList();
                if (list == null) {
                    BatchModifyIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            ArrayList arrayList = ContainerUtil.newArrayList(elements);
            if (arrayList == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        public void update(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(3);
            }
            boolean visible = (indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() > 1 && DbImplUtil.canConnectTo((DbElement)indices.get(0)) && DbBatchIndicesDialog.canModifyAnything(new DatabaseEditorContext((DbElement)indices.get(0), null), indices);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)indices.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(4);
            }
            if ((indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() < 2) {
                return;
            }
            BatchModifyIndicesAction.showModifyIndicesDialogAndRun(indices);
        }

        public static void showModifyIndicesDialogAndRun(@NotNull List<DbIndex> indices) {
            if (indices == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(5);
            }
            DbBatchIndicesDialog.newBatchModifyIndicesDialog(new DatabaseEditorContext((DbElement)indices.get(0), null), indices).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicesToModify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndicesToModify";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showModifyIndicesDialogAndRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddTableAction
    extends DumbAwareAction {
        public AddTableAction() {
            super("_Table", "Add new table to selected schema", DatabaseIcons.Table);
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement element;
            DbNamespaceImpl parent;
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(0);
            }
            boolean visible = (parent = DatabaseView.getLowestSchema(element = AddTableAction.getElement(e))) != null && DbImplUtil.canConnectTo(parent);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(parent));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element;
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(1);
            }
            if ((element = AddTableAction.getElement(e)) == null) {
                return;
            }
            DbDataSource dataSource = element.getDataSource();
            DbNamespaceImpl schema = DatabaseView.getLowestSchema(element);
            AddTableAction.showAddTableDialogAndRun(dataSource, schema, "table_name", ContainerUtil.emptyList());
        }

        @Nullable
        private static DbElement getElement(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(2);
            }
            return (DbElement)DatabaseView.getSelectedElements(e.getDataContext(), true).first();
        }

        public static void showAddTableDialogAndRun(@NotNull DbDataSource dataSource, @Nullable DasNamespace schema, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
            if (dataSource == null) {
                AddTableAction.$$$reportNull$$$0(3);
            }
            if (defaultName == null) {
                AddTableAction.$$$reportNull$$$0(4);
            }
            if (columnNames == null) {
                AddTableAction.$$$reportNull$$$0(5);
            }
            DbRefactoringDialogHelper.newAddTableDialog(new DatabaseEditorContext(dataSource, schema, null), schema, defaultName, columnNames).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddTableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAddTableDialogAndRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DeleteProvider2
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return "Drop";
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            DbDataSource dataSource;
            Project project;
            if (dataContext == null) {
                DeleteProvider2.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            for (DbElement e : selection) {
                if (e.isWritable()) continue;
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dbDataSource = dataSource = any == null ? null : any.getDataSource();
            if (dataSource == null || !DbImplUtil.canConnectToAndModify((DbElement)dataSource)) {
                return false;
            }
            for (DbElement e : selection) {
                if (dataSource.equals(e.getDataSource())) continue;
                return false;
            }
            return DeleteQueryGenerator.canDeleteAnything(selection.toList());
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider2.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            final JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            DbElement first = (DbElement)selection.first();
            if (first == null) {
                return;
            }
            final DbDataSource dataSource = first.getDataSource();
            final DasNamespace namespace = DbImplUtil.getSearchPathObject(first);
            final ArrayList messages = ContainerUtil.newArrayList();
            final Ref queryRef = Ref.create();
            final ArrayList toRemove = ContainerUtil.newArrayList();
            new Task.Backgroundable(project, "Generating Query"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DeleteQueryGenerator generator = new DeleteQueryGenerator(selection.filter(e -> !DataImporter.isBusy(e)).toList());
                    CompositeText text2 = generator.generateQueries(messages);
                    try {
                        text2 = DbSrcMigration.formatCompositeText(project, DbSqlUtil.getSqlDialect((DbElement)dataSource), text2);
                    }
                    catch (Error | RuntimeException e2) {
                        Logger.getInstance(DdlActions.class).warn(e2);
                    }
                    queryRef.set((Object)text2.getText().toString());
                    generator.fillNamespacesToRemove(toRemove);
                }

                public void onSuccess() {
                    super.onSuccess();
                    String query = (String)queryRef.get();
                    DeleteProvider2.showDialogAndRun(project, query, dataSource, SearchPath.of((DasObject)namespace), messages, (JBIterable<DbElement>)selection, toRemove);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/DdlActions$DeleteProvider2$1", "run"));
                }
            }.queue();
        }

        private static void showDialogAndRun(@NotNull Project project, @NotNull String query, @NotNull DbDataSource dataSource, @Nullable SearchPath searchPath, @NotNull List<String> messages, @NotNull JBIterable<DbElement> selection, @NotNull List<Pair<ObjectName, ObjectName>> toRemove) {
            DeleteDialog dialog;
            if (project == null) {
                DeleteProvider2.$$$reportNull$$$0(2);
            }
            if (query == null) {
                DeleteProvider2.$$$reportNull$$$0(3);
            }
            if (dataSource == null) {
                DeleteProvider2.$$$reportNull$$$0(4);
            }
            if (messages == null) {
                DeleteProvider2.$$$reportNull$$$0(5);
            }
            if (selection == null) {
                DeleteProvider2.$$$reportNull$$$0(6);
            }
            if (toRemove == null) {
                DeleteProvider2.$$$reportNull$$$0(7);
            }
            if (query.isEmpty() && messages.isEmpty()) {
                messages.add("No code generated");
            }
            if ((dialog = new DeleteDialog(project, dataSource, searchPath, query, messages)).showAndGet()) {
                DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(dataSource, searchPath).setStatement(dialog.getStatement());
                LoaderContext context = handler.getContext();
                for (DbElement element : selection) {
                    if (element instanceof DbTableChild) {
                        DbTable table = ((DbTableChild)element).getTable();
                        context.include(table);
                        for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)table)) {
                            context.include(fk.getRefTable());
                        }
                    }
                    context.include(element);
                }
                for (Pair<ObjectName, ObjectName> pair : toRemove) {
                    context.getScopeUpdater().toRemove((ObjectName)pair.first, (ObjectName)pair.second);
                }
                handler.runStatements(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toRemove";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DeleteProvider2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showDialogAndRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DeleteProvider1
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return "Remove";
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider1.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            if (selection.filter(DbDataSource.class).size() != selection.size()) {
                return false;
            }
            return !selection.isEmpty();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider1.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbDataSource.class));
            DdlActions.deleteDataSources(project, selection.toSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DeleteProvider1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

