/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.actions.CodeInsightEditorAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.editor.CsvTableFileEditorProvider;
import com.intellij.database.editor.FragmentTableFileEditorProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditAsTableAction
extends DumbAwareAction {
    public static final int LIMIT = 10000;
    private static final String CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY = "editAsTableFormatDialogDimension";

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            EditAsTableAction.$$$reportNull$$$0(0);
        }
        CodeInsightEditorAction.beforeActionPerformedUpdate((AnActionEvent)e);
        super.beforeActionPerformedUpdate(e);
    }

    public void update(AnActionEvent e) {
        boolean isCsv;
        Editor editor = EditAsTableAction.getEditor(e);
        VirtualFile file = editor == null ? null : FileDocumentManager.getInstance().getFile(editor.getDocument());
        Project project = e.getProject();
        if (project == null || file == null) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        TextRange selection = EditAsTableAction.getSelection(editor);
        boolean oneToken = selection != null && EditAsTableAction.isOneTokenSelection(editor, selection);
        boolean isDml = selection != null && language instanceof SqlLanguageDialect;
        boolean bl = isCsv = language != null && language.isKindOf((Language)PlainTextLanguage.INSTANCE);
        if (isDml && oneToken) {
            isDml = false;
            isCsv = true;
        }
        e.getPresentation().setText(this.getTemplatePresentation().getText() + (isDml ? "" : "..."));
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(isDml || isCsv || "EditorPopup" != e.getPlace());
    }

    @Nullable
    private static Editor getEditor(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null && project != null) {
            return (Editor)ObjectUtils.chooseNotNull((Object)BaseCodeInsightAction.getInjectedEditor((Project)project, (Editor)editor, (boolean)false), (Object)editor);
        }
        return editor;
    }

    private static boolean isOneTokenSelection(@NotNull Editor e, @NotNull TextRange r) {
        if (e == null) {
            EditAsTableAction.$$$reportNull$$$0(1);
        }
        if (r == null) {
            EditAsTableAction.$$$reportNull$$$0(2);
        }
        if (e.getProject() == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)e.getProject()).getPsiFile(e.getDocument());
        if (file == null) {
            return false;
        }
        PsiElement elem = file.findElementAt(r.getStartOffset() + r.getLength() / 2);
        if (elem == null) {
            return false;
        }
        return elem.getTextRange().contains(r);
    }

    public void actionPerformed(AnActionEvent e) {
        Language language;
        VirtualFile file;
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Editor editor = EditAsTableAction.getEditor(e);
        VirtualFile virtualFile = file = editor == null ? null : FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (editor == null || file == null) {
            return;
        }
        Document document = editor.getDocument();
        TextRange selection = EditAsTableAction.getSelection(editor);
        if (selection != null && (language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) instanceof SqlLanguageDialect && !EditAsTableAction.isOneTokenSelection(editor, selection)) {
            FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection, (SqlLanguageDialect)language);
            return;
        }
        CsvFormat format = this.showDataFormatEditorDialog(project, file, document, selection);
        if (format != null) {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
                if (selection == null && file instanceof VirtualFileWithId && EditorUtil.isRealFileEditor((Editor)editor)) {
                    CsvTableFileEditorProvider.openEditor(project, file, format);
                } else {
                    FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection == null ? TextRange.from((int)0, (int)editor.getDocument().getTextLength()) : selection, format);
                }
            });
        }
    }

    @Nullable
    private static TextRange getSelection(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        TextRange range = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (range.isEmpty()) {
            if (editor.getProject() == null) {
                return null;
            }
            SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument()), SqlFile.class);
            if (file == null || !file.getSqlLanguage().getDatabaseDialect().getFamilyId().isPostgres()) {
                return null;
            }
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
            IElementType type = element == null ? null : element.getNode().getElementType();
            return type != null && type.toString().equals("#SQL_RAW_INPUT") ? element.getTextRange() : null;
        }
        return range.isEmpty() ? null : range;
    }

    @Nullable
    private CsvFormat showDataFormatEditorDialog(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            EditAsTableAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            EditAsTableAction.$$$reportNull$$$0(4);
        }
        if (document == null) {
            EditAsTableAction.$$$reportNull$$$0(5);
        }
        Disposable disposable = Disposer.newDisposable();
        String text2 = range == null ? EditAsTableAction.getLimitedText(document) : range.subSequence(document.getCharsSequence()).toString();
        CsvFormatsSelectionUI formatsForm = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(disposable);
        CsvFormat format = CsvFormatResolver.getFormat(project, file, CsvFormatResolver.FormatGetter.STATE, CsvFormatResolver.FormatGetter.FILE, CsvFormatResolver.FormatGetter.CONTENT);
        formatsForm.select(format);
        CsvFormat selectedFormat = formatsForm.getSelectedFormat();
        TableCsvFormatPreview preview = new TableCsvFormatPreview(project, (CsvFormat)ObjectUtils.assertNotNull((Object)selectedFormat), text2, disposable);
        FormatsListAndPreviewPanel panel = new FormatsListAndPreviewPanel(formatsForm, preview);
        panel.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        DialogBuilder dialog = new DialogBuilder(project).title(this.getTemplatePresentation().getText() + ": '" + file.getName() + "'" + (range != null ? " Fragment" : "") + " Format").centerPanel((JComponent)panel).dimensionKey(CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY);
        dialog.setHelpId("edit.as.table.format.configuration.dialog");
        Disposer.register((Disposable)dialog, (Disposable)disposable);
        return dialog.showAndGet() ? formatsForm.getSelectedFormat() : null;
    }

    @NotNull
    private static String getLimitedText(@NotNull Document document) {
        if (document == null) {
            EditAsTableAction.$$$reportNull$$$0(6);
        }
        String string = document.getText().substring(0, Math.min(document.getTextLength(), 10000));
        if (string == null) {
            EditAsTableAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/EditAsTableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/EditAsTableAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLimitedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isOneTokenSelection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showDataFormatEditorDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLimitedText";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

