/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DatabaseObjectRefactoring;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDbObjectGroup
extends ActionGroup
implements DumbAware {
    public static final DataKey<Consumer<AbstractDbRefactoringDialog>> INTERCEPTOR = DataKey.create((String)"GenerateDbObjectGroup.INTERCEPTOR");
    public static final DataKey<DbRefactoringHelper.ObjectLocation> FORCED_LOCATION = DataKey.create((String)"DatabaseObjectRefactoring.FORCED_LOCATION");
    private final AnAction[] myChildren = new AnAction[]{new BaseGenerateDbObjectAction(ObjectKind.TABLE, DasNamespace.class, true){

        @Override
        @NotNull
        protected DeObject getEditedObject(@NotNull DbTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                1.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                1.$$$reportNull$$$0(1);
            }
            DeObject deObject = dialog.createEmptyTemplate(parent);
            if (deObject == null) {
                1.$$$reportNull$$$0(2);
            }
            return deObject;
        }

        @Override
        protected DeObject getObjectToSelect(@NotNull DbTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                1.$$$reportNull$$$0(3);
            }
            if (dataContext == null) {
                1.$$$reportNull$$$0(4);
            }
            return ((DatabaseTableEditor)dialog.getEditor()).getTable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateDbObjectGroup$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateDbObjectGroup$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditedObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditedObject";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjectToSelect";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.COLUMN, DasTable.class, false){

        @Override
        @Nullable
        protected DeColumn getObjectToSelect(@NotNull DbTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                2.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                2.$$$reportNull$$$0(1);
            }
            Ref column = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withColumn("new_column")).addAndGet((Ref<DeColumn>)column)).leave()).commit();
            return (DeColumn)column.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/GenerateDbObjectGroup$2";
            objectArray[2] = "getObjectToSelect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.INDEX, DasTable.class, false){

        @Override
        @Nullable
        protected DeIndex getObjectToSelect(@NotNull DbTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                3.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                3.$$$reportNull$$$0(1);
            }
            DeTable table = ((DatabaseTableEditor)dialog.getEditor()).getTable();
            Ref index = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)JBIterable.from((Iterable)DatabaseObjectRefactoring.getDasObjects(dataContext).filter(object -> object instanceof DasColumn && object.getDasParent() == parent)).transform(object -> {
                if (dialog == null) {
                    3.$$$reportNull$$$0(2);
                }
                DeColumn column = (DeColumn)dialog.exportOp((DasObject)object, true);
                column.table = table;
                return column;
            }), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)index)).leave()).commit();
            return (DeIndex)index.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/GenerateDbObjectGroup$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getObjectToSelect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getObjectToSelect$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }, new BaseGenerateDbObjectAction(ObjectKind.FOREIGN_KEY, DasTable.class, false){

        @Override
        @Nullable
        protected DeObject getObjectToSelect(@NotNull DbTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                4.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                4.$$$reportNull$$$0(1);
            }
            DeTable table = ((DatabaseTableEditor)dialog.getEditor()).getTable();
            Ref fk = Ref.create();
            ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)JBIterable.from((Iterable)DatabaseObjectRefactoring.getDasObjects(dataContext).filter(object -> object instanceof DasColumn && object.getDasParent() == parent)).transform(object -> {
                if (dialog == null) {
                    4.$$$reportNull$$$0(2);
                }
                DeColumn column = (DeColumn)dialog.exportOp((DasObject)object, true);
                column.table = table;
                return column;
            }))).addAndGet((Ref<DeForeignKey>)fk)).leave()).commit();
            return (DeObject)fk.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/GenerateDbObjectGroup$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getObjectToSelect";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$getObjectToSelect$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }};

    private static boolean checkFile(DataContext dataContext) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return file != null && file.getLanguage() instanceof SqlLanguageDialect || element != null && element.getLanguage() instanceof SqlLanguageDialect;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabledAndVisible(GenerateDbObjectGroup.checkFile(e.getDataContext()));
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (this.myChildren == null) {
            GenerateDbObjectGroup.$$$reportNull$$$0(0);
        }
        return this.myChildren;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup", "getChildren"));
    }

    public static abstract class BaseGenerateDbObjectAction
    extends DumbAwareAction {
        @NotNull
        private final ObjectKind myKind;
        private final Class<? extends DasObject> myParentClass;
        private final boolean myParentNullable;

        protected BaseGenerateDbObjectAction(@NotNull ObjectKind kind, @NotNull Class<? extends DasObject> parentClass, boolean parentNullable) {
            if (kind == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(0);
            }
            if (parentClass == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(1);
            }
            super(DatabaseObjectRefactoring.getKindTitle(kind));
            this.myKind = kind;
            this.myParentClass = parentClass;
            this.myParentNullable = parentNullable;
        }

        public boolean startInTransaction() {
            return true;
        }

        protected boolean isEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(2);
            }
            if (!GenerateDbObjectGroup.checkFile(dataContext)) {
                return false;
            }
            DasObject object = this.getObject(dataContext);
            if (object == null) {
                return this.myParentNullable;
            }
            if (this.getSupportedLocations(DbRefactoringHelper.ObjectLocation.of(object, null)).isEmpty()) {
                return false;
            }
            if (this.createContext(dataContext) == null) {
                return false;
            }
            return this.myParentClass.isAssignableFrom(object.getClass());
        }

        @NotNull
        protected JBIterable<DbRefactoringHelper.ObjectLocation> getSupportedLocations(@Nullable DbRefactoringHelper.ObjectLocation objectLocation) {
            JBIterable jBIterable = JBIterable.of((Object)ObjectUtils.chooseNotNull((Object)((Object)objectLocation), (Object)((Object)DbRefactoringHelper.ObjectLocation.CODE)));
            if (jBIterable == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.isEnabled(e.getDataContext()));
        }

        public void actionPerformed(final AnActionEvent e) {
            if (!this.isEnabled(e.getDataContext())) {
                return;
            }
            DbRefactoringHelper.ObjectLocation forcedLocation = (DbRefactoringHelper.ObjectLocation)((Object)FORCED_LOCATION.getData(e.getDataContext()));
            Consumer dialogInterceptor = (Consumer)INTERCEPTOR.getData(e.getDataContext());
            final DatabaseEditorContext context = this.createContext(e.getDataContext());
            if (context == null) {
                return;
            }
            final DasObject object = this.getObject(e.getDataContext());
            List<DbRefactoringHelper.ObjectLocation> locations = this.getSupportedLocations(DbRefactoringHelper.ObjectLocation.of(object, context.getDataSource())).toList();
            if (locations.isEmpty()) {
                return;
            }
            if (forcedLocation != null) {
                locations = Collections.singletonList(forcedLocation);
            }
            if (locations.size() == 1) {
                DbTableDialog dialog = this.prepare(object, context, e.getDataContext(), locations.get(0));
                if (dialogInterceptor != null) {
                    dialogInterceptor.consume((Object)dialog);
                } else {
                    dialog.finishAndShow();
                }
                return;
            }
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<DbRefactoringHelper.ObjectLocation>("Add definition to:", locations){

                public Icon getIconFor(DbRefactoringHelper.ObjectLocation value) {
                    if (value == DbRefactoringHelper.ObjectLocation.DATABASE) {
                        return DatabaseIcons.Dbms;
                    }
                    if (value == DbRefactoringHelper.ObjectLocation.CODE) {
                        return DatabaseIcons.Sql;
                    }
                    return null;
                }

                @NotNull
                public String getTextFor(DbRefactoringHelper.ObjectLocation value) {
                    String string = value.toString() + "...";
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public PopupStep onChosen(DbRefactoringHelper.ObjectLocation selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> this.prepare(object, context, e.getDataContext(), selectedValue).finishAndShow());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction$1", "getTextFor"));
                }
            }).showInBestPositionFor(e.getDataContext());
        }

        @NotNull
        protected DbTableDialog prepare(@Nullable DasObject object, @NotNull DatabaseEditorContext context, @NotNull DataContext dataContext, @NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (context == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(4);
            }
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(5);
            }
            if (genLocation == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(6);
            }
            DbTableDialog dialog = new DbTableDialog(context);
            BaseGenerateDbObjectAction.setProcessor(dialog, dataContext, genLocation);
            dialog.configureForCreation(this.getEditedObject(dialog, object, dataContext), this.isForceCreate(genLocation));
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                if (dataContext == null) {
                    BaseGenerateDbObjectAction.$$$reportNull$$$0(19);
                }
                return this.getObjectToSelect(dialog, object, dataContext);
            }));
            DbTableDialog dbTableDialog = dialog;
            if (dbTableDialog == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(7);
            }
            return dbTableDialog;
        }

        protected boolean isForceCreate(@NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (genLocation == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(8);
            }
            return genLocation == DbRefactoringHelper.ObjectLocation.CODE;
        }

        @Nullable
        public DatabaseEditorContext createContext(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(9);
            }
            DasObject object = this.getObject(dataContext);
            PsiElement place = BaseGenerateDbObjectAction.getPlace(dataContext);
            if (object != null) {
                return DbRefactoringHelper.createContext(object, place);
            }
            SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_FILE.getData(dataContext), SqlFile.class);
            if (file == null) {
                return null;
            }
            return DatabaseEditorContext.forFile(file);
        }

        @Nullable
        private static PsiElement getPlace(@NotNull DataContext context) {
            if (context == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(10);
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
            return editor == null || file == null ? null : file.findElementAt(editor.getCaretModel().getOffset());
        }

        private static void setProcessor(@NotNull DbTableDialog dialog, @NotNull DataContext dataContext, @NotNull DbRefactoringHelper.ObjectLocation genLocation) {
            if (dialog == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(11);
            }
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(12);
            }
            if (genLocation == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(13);
            }
            RangeMarker place = DbRefactoringHelper.getPlace(BaseGenerateDbObjectAction.getPlace(dataContext));
            if (genLocation == DbRefactoringHelper.ObjectLocation.CODE) {
                dialog.setResultProcessor(new GenericEditingResultProcessor(dialog, DbRefactoringHelper.SQL_SETTINGS, place));
            } else {
                dialog.setResultProcessor(new GenericEditingResultProcessor(dialog, DbRefactoringHelper.DB_SETTINGS, place));
            }
        }

        @NotNull
        protected DeObject getEditedObject(@NotNull DbTableDialog dialog, @Nullable DasObject parent, @NotNull DataContext dataContext) {
            if (dialog == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(14);
            }
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(15);
            }
            Object De = dialog.export((DasObject)ObjectUtils.assertNotNull((Object)parent), true);
            if (De == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(16);
            }
            return De;
        }

        @Nullable
        protected abstract DeObject getObjectToSelect(@NotNull DbTableDialog var1, @Nullable DasObject var2, @NotNull DataContext var3);

        @Nullable
        protected DasObject getObject(@NotNull DataContext dataContext) {
            DasObject object;
            if (dataContext == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(17);
            }
            if ((object = DatabaseObjectRefactoring.getDasObject(dataContext)) == null) {
                ObjectPath currentObject;
                SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)CommonDataKeys.PSI_FILE.getData(dataContext), SqlFile.class);
                ObjectPath objectPath = currentObject = file == null ? null : SearchPath.getCurrent((SearchPath)DatabaseEditorHelper.getSearchPath((PsiFile)file));
                if (currentObject == null) {
                    return null;
                }
                DbDataSource dataSource = DbImplUtil.getForcedDataSource((PsiFile)file);
                if (dataSource != null) {
                    object = DatabaseEditorHelper.findNamespace(file.getProject(), (DatabaseSystem)dataSource, currentObject);
                }
            }
            while (object != null && !this.myParentClass.isAssignableFrom(object.getClass())) {
                object = object.getDasParent();
            }
            return object;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = this.myKind;
            if (objectKind == null) {
                BaseGenerateDbObjectAction.$$$reportNull$$$0(18);
            }
            return objectKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 7: 
                case 16: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 7: 
                case 16: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentClass";
                    break;
                }
                case 2: 
                case 5: 
                case 9: 
                case 12: 
                case 15: 
                case 17: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 3: 
                case 7: 
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction";
                    break;
                }
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 6: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "genLocation";
                    break;
                }
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/GenerateDbObjectGroup$BaseGenerateDbObjectAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedLocations";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepare";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditedObject";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 3: 
                case 7: 
                case 16: 
                case 18: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isForceCreate";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createContext";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getPlace";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setProcessor";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditedObject";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getObject";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$prepare$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 7: 
                case 16: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

