/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BitDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.CustomSuitabilityDomain;
import com.intellij.database.data.types.domain.Float1Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.MysqlFloatDomain;
import com.intellij.database.data.types.domain.MysqlNumber2Domain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.MysqlDialect;
import org.jetbrains.annotations.NotNull;

public class MysqlDomains
extends DomainRegistry {
    private static final int MIN_MYSQL_MEDIUM_INT = -16777216;
    private static final int MAX_MYSQL_MEDIUM_INT = 0xFFFFFF;
    private static final int MAX_PRECISION = 53;
    private static final int MAX_SCALE = 30;
    private static final int MAX_CHAR = 255;
    private static final long MAX_LONG = 0x800000L;
    private static final int MAX_VARBINARY = 65535;
    private static final int MAX_VARCHAR = 21845;

    public MysqlDomains() {
        super(MysqlDialect.INSTANCE);
        this.add(new CustomSuitabilityDomain.LessOrEqual(new BooleanDomain("bit", ConversionPoint.BOOLEAN), 1));
        this.add(new CustomSuitabilityDomain.Greater(new BitDomain("bit", ConversionPoint.BINARY, 64L, -1L, true), 1));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add(new IntegerDomain("mediumint", ConversionPoint.NUMBER, -1.6777216E7, 1.6777215E7));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new YearDomain());
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("smallint unsigned", ConversionPoint.NUMBER, 0.0, 65535.0));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new MysqlNumber2Domain(new Number2Domain("double precision", ConversionPoint.DOUBLE_PRECISION, 53, 30, true)));
        this.add(new MysqlNumber2Domain(new Number2Domain("double", ConversionPoint.DOUBLE_PRECISION, 53, 30, true)));
        this.add(new MysqlFloatDomain(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE)));
        this.add(new MysqlFloatDomain(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE)));
        this.add(new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, 53, 30, true));
        this.add(new Number2Domain("dec", ConversionPoint.BIG_DECIMAL, 53, 30, true));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, -1, false));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, false));
        this.add(new FractionDomain("datetime", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, -1, false));
        this.add(new TextDomain("tinytext", ConversionPoint.VARCHAR, 127L));
        this.add(new TextDomain("text", ConversionPoint.TEXT, 65535L));
        this.add(new TextDomain("longtext", ConversionPoint.CLOB, 0x800000L));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 255L, -1L, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 21845L, -1L, true));
        this.add(new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 21845L, -1L, true));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 255L, -1L, true));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB, 65535L));
        this.add(new BinaryDomain("tinyblob", ConversionPoint.BLOB, 127L));
        this.add(new BinaryDomain("longblob", ConversionPoint.BLOB, 0x800000L));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 65535L, -1L, true));
        this.add(new IntegerDomain("integer unsigned", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("int unsigned", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("bigint unsigned", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new MysqlNumber2Domain(new Number2Domain("float", ConversionPoint.SINGLE_PRECISION, 53, 30, true)));
        this.add(new MysqlNumber2Domain(new Number2Domain("real", ConversionPoint.SINGLE_PRECISION, 53, 30, true)));
        this.add(new MysqlFloatDomain(new Float1Domain("float", ConversionPoint.SINGLE_PRECISION, new DomainRegistry.Limits(new DomainRegistry.Limit(23, Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE)), new DomainRegistry.Limit(53, -1.7976931348623157E308, Double.MAX_VALUE)))));
        this.add(new MysqlFloatDomain(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38)));
    }

    private static class YearDomain
    extends IntegerDomain {
        public static final int MIN = 1901;
        public static final int MAX = 2155;

        YearDomain() {
            super("year", ConversionPoint.NUMBER, 1901.0, 2155.0);
        }

        @Override
        @NotNull
        protected Number trim(@NotNull Number n) {
            long l;
            if (n == null) {
                YearDomain.$$$reportNull$$$0(0);
            }
            Long l2 = (l = YearDomain.convert(n.longValue())) <= 2155L && l >= 1901L ? l : 0L;
            if (l2 == null) {
                YearDomain.$$$reportNull$$$0(1);
            }
            return l2;
        }

        private static long convert(long value) {
            return value <= 69L && value >= 1L ? 2000L + value : (value >= 70L && value <= 99L ? 1900L + value : value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/data/types/registry/MysqlDomains$YearDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/data/types/registry/MysqlDomains$YearDomain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "trim";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

