/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.CompositeTextFun;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMarkup
implements CompositeText {
    private final CharSequence myText;
    private final int[] myOffsets;
    private final char[] myKinds;

    public PersistentMarkup(@NotNull CharSequence text2, @NotNull int[] offsets, @NotNull char[] kinds) {
        if (text2 == null) {
            PersistentMarkup.$$$reportNull$$$0(0);
        }
        if (offsets == null) {
            PersistentMarkup.$$$reportNull$$$0(1);
        }
        if (kinds == null) {
            PersistentMarkup.$$$reportNull$$$0(2);
        }
        assert (offsets.length == kinds.length);
        this.myText = text2;
        this.myOffsets = offsets;
        this.myKinds = kinds;
    }

    @Override
    @NotNull
    public Iterable<CompositeText.Fragment> getFragments() {
        Iterable<CompositeText.Fragment> iterable = () -> new JBIterator<CompositeText.Fragment>(){
            int i = 0;

            protected CompositeText.Fragment nextImpl() {
                return this.i < PersistentMarkup.this.myOffsets.length ? PersistentMarkup.this.createFragment(this.i++) : (CompositeText.Fragment)this.stop();
            }
        };
        if (iterable == null) {
            PersistentMarkup.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @Override
    @NotNull
    public CharSequence getText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            PersistentMarkup.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @Override
    public int getLength() {
        return this.myText.length();
    }

    public String toString() {
        return this.getText().toString();
    }

    @Override
    @Nullable
    public CompositeText.Fragment first(@NotNull CompositeText.Kind kind) {
        int idx;
        if (kind == null) {
            PersistentMarkup.$$$reportNull$$$0(5);
        }
        return (idx = CharArrayUtil.indexOf((char[])this.myKinds, (char)PersistentMarkup.ord(kind), (int)0, (int)this.myKinds.length)) < 0 ? null : this.createFragment(idx);
    }

    @Override
    @Nullable
    public CompositeText.Fragment getContent() {
        int idx = CharArrayUtil.indexOf((char[])this.myKinds, (char)PersistentMarkup.ord(CompositeText.Kind.ORIGINAL_TEXT), (int)0, (int)this.myKinds.length);
        if (idx < 0) {
            idx = CharArrayUtil.indexOf((char[])this.myKinds, (char)PersistentMarkup.ord(CompositeText.Kind.DECOMPILED_TEXT), (int)0, (int)this.myKinds.length);
        }
        return idx < 0 ? null : this.createFragment(idx);
    }

    @NotNull
    private CompositeText.Fragment createFragment(final int idx) {
        CompositeText.Fragment fragment = new CompositeText.Fragment(){

            @Override
            @NotNull
            public CharSequence getText() {
                CharSequence charSequence = PersistentMarkup.this.myText.subSequence(this.getBegin(), this.getEnd());
                if (charSequence == null) {
                    2.$$$reportNull$$$0(0);
                }
                return charSequence;
            }

            @Override
            @NotNull
            public CompositeText.Kind getKind() {
                CompositeText.Kind kind = (CompositeText.Kind)((Object)ObjectUtils.chooseNotNull((Object)((Object)CompositeTextFun.FragmentKindsByCodes.get(Character.valueOf(PersistentMarkup.this.myKinds[idx]))), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)));
                if (kind == null) {
                    2.$$$reportNull$$$0(1);
                }
                return kind;
            }

            @Override
            public int getBegin() {
                return Math.min(this.getOffset(idx - 1), PersistentMarkup.this.myText.length());
            }

            public int getOffset(int i2) {
                return i2 < 0 ? 0 : PersistentMarkup.this.myOffsets[i2];
            }

            @Override
            public int getEnd() {
                return Math.min(Math.max(this.getOffset(idx - 1), this.getOffset(idx)), PersistentMarkup.this.myText.length());
            }

            @Override
            public int getLength() {
                return this.getEnd() - this.getBegin();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/database/dataSource/srcStorage/PersistentMarkup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (fragment == null) {
            PersistentMarkup.$$$reportNull$$$0(6);
        }
        return fragment;
    }

    @NotNull
    public DbSrcStorageDsMetadata.MetaData getExpectedMetaData(@Nullable DbSrcStorageDsMetadata.MetaData md, int introVersion, int genVersion) {
        if (md == null) {
            md = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        DbSrcStorageDsMetadata.MetaData metaData = new DbSrcStorageDsMetadata.MetaData(md.srcVersion, DbSrcUtils.hashCode(this.myText), this.myOffsets, this.myKinds, introVersion, genVersion);
        if (metaData == null) {
            PersistentMarkup.$$$reportNull$$$0(7);
        }
        return metaData;
    }

    private static char ord(CompositeText.Kind k) {
        return k.getCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/PersistentMarkup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/PersistentMarkup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createFragment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private final StringBuilder kinds = new StringBuilder();
        private final TIntArrayList offsets = new TIntArrayList();

        public void add(CompositeText.Kind k, int o) {
            if (o == 0 || !this.offsets.isEmpty() && this.offsets.get(this.offsets.size() - 1) == o) {
                return;
            }
            int sz = this.kinds.length();
            char ord = PersistentMarkup.ord(k);
            if (k == CompositeText.Kind.PLAIN_TEXT && sz > 0 && this.kinds.charAt(sz - 1) == ord) {
                this.offsets.set(sz - 1, o);
            } else {
                this.offsets.add(o);
                this.kinds.append(ord);
            }
        }

        public void add(CompositeText.Kind k, int from, int to) {
            this.add(CompositeText.Kind.PLAIN_TEXT, from);
            this.add(k, to);
        }

        public void clear() {
            this.kinds.setLength(0);
            this.offsets.clear();
        }

        public PersistentMarkup build(CharSequence text2) {
            char[] kindsArray = new char[this.kinds.length()];
            this.kinds.getChars(0, this.kinds.length(), kindsArray, 0);
            return new PersistentMarkup(text2, this.offsets.toNativeArray(), kindsArray);
        }
    }
}

