/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.model.DasModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;

public class DbSrcStorageManager {
    private static final Logger LOG = Logger.getInstance(DbSrcStorageManager.class);
    private final Project myProject;
    private final @SystemDependent String myRootPath;
    private final Map<String, DbSrcStorage> myStorages = ContainerUtil.createConcurrentSoftValueMap();

    @NotNull
    public static DbSrcStorageManager getInstance(@Nullable Project project) {
        DbSrcStorageManager dbSrcStorageManager = project == null ? (DbSrcStorageManager)ServiceManager.getService(App.class) : (DbSrcStorageManager)ServiceManager.getService((Project)project, DbSrcStorageManager.class);
        if (dbSrcStorageManager == null) {
            DbSrcStorageManager.$$$reportNull$$$0(0);
        }
        return dbSrcStorageManager;
    }

    public DbSrcStorageManager(@Nullable Project project) {
        this.myProject = project;
        this.myRootPath = DbSrcStorageManager.getStorageRoot(project);
        Disposer.register((Disposable)(this.myProject == null ? ApplicationManager.getApplication() : this.myProject), this::finish);
        DbSrcChangesTracker.getInstance(null);
    }

    public boolean isStored() {
        return Files.isDirectory(FileSystems.getDefault().getPath(this.myRootPath, new String[0]), new LinkOption[0]);
    }

    public boolean isStored(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(1);
        }
        return Files.isDirectory(FileSystems.getDefault().getPath(this.myRootPath, dataSourceId), new LinkOption[0]);
    }

    public boolean isStoredInNewFormat(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(2);
        }
        return Files.isDirectory(FileSystems.getDefault().getPath(this.myRootPath, dataSourceId, "storage_v2"), new LinkOption[0]);
    }

    public void migrate(@NotNull String dataSourceId, @NotNull DasModel model) {
        DbSrcStorage storage;
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(3);
        }
        if (model == null) {
            DbSrcStorageManager.$$$reportNull$$$0(4);
        }
        if (!(storage = this.getStorage(dataSourceId, true)).migrate(model)) {
            storage.drop();
            this.removeBackend(dataSourceId);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public List<String> getStoredDataSources() {
        List<String> list;
        Throwable throwable;
        Stream<Path> list2;
        block18: {
            block19: {
                Path root2 = FileSystems.getDefault().getPath(this.myRootPath, new String[0]);
                if (!Files.isDirectory(root2, new LinkOption[0])) {
                    List<String> list3 = Collections.emptyList();
                    if (list3 == null) {
                        DbSrcStorageManager.$$$reportNull$$$0(5);
                    }
                    return list3;
                }
                list2 = Files.list(root2);
                throwable = null;
                list = list2.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).collect(Collectors.toList());
                if (list2 == null) break block18;
                if (throwable == null) break block19;
                try {
                    list2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block18;
            }
            list2.close();
        }
        List<String> list4 = list;
        if (list4 == null) {
            DbSrcStorageManager.$$$reportNull$$$0(6);
        }
        return list4;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (list2 != null) {
                            if (throwable != null) {
                                try {
                                    list2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                list2.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    List<String> list5 = Collections.emptyList();
                    if (list5 == null) {
                        DbSrcStorageManager.$$$reportNull$$$0(7);
                    }
                    return list5;
                }
            }
        }
    }

    @NotNull
    public Iterable<DbSrcStorage> getActiveStorages() {
        Collection<DbSrcStorage> collection = this.myStorages.values();
        if (collection == null) {
            DbSrcStorageManager.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Contract(value="_,true->!null")
    public DbSrcStorage getStorage(@NotNull String dataSourceId, boolean write) {
        DbSrcStorage backend;
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(9);
        }
        if ((backend = this.myStorages.get(dataSourceId)) == null) {
            String root2 = this.myRootPath + File.separator + dataSourceId;
            if (!write && !Files.isDirectory(FileSystems.getDefault().getPath(root2, new String[0]), new LinkOption[0])) {
                return null;
            }
            backend = new DbSrcStorage(this.myProject, this.myRootPath, dataSourceId);
            DbSrcStorage prev = this.myStorages.putIfAbsent(dataSourceId, backend);
            if (prev != null) {
                backend = prev;
            }
        }
        return backend;
    }

    public void removeBackend(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(10);
        }
        this.myStorages.remove(dataSourceId);
    }

    @NotNull
    public static @SystemDependent String getStorageRoot(@Nullable Project project) {
        String storage = DataSourceStorage.getStoragePath(project);
        if (storage == null && project != null) {
            storage = project.getProjectFilePath();
        }
        storage = storage == null ? PathManager.getOptionsPath() + File.separator + "dummy" : FileUtil.toSystemDependentName((String)storage);
        String string = new File(new File(storage).getParentFile(), "dataSources").getAbsolutePath();
        if (string == null) {
            DbSrcStorageManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void finish() {
        List<DbSrcStorage> storages = DbSrcBackendUtils.clearAndGet(this.myStorages.values());
        for (DbSrcStorage storage : storages) {
            storage.finish();
        }
    }

    public void prune() {
        List<DbSrcStorage> storages = DbSrcBackendUtils.clearAndGet(this.myStorages.values());
        for (DbSrcStorage storage : storages) {
            storage.flushToFs(false);
            storage.resetCaches();
        }
        FileUtil.delete((File)new File(this.myRootPath));
        Pair files = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)DbSrcFileSystem.getInstance(), (String)DbSrcFileSystem.getPath(this.myProject, null, null, DbSrcFileSystem.ItemType.FOLDER));
        NewVirtualFile file = (NewVirtualFile)ObjectUtils.chooseNotNull((Object)files.first, (Object)files.second);
        if (file != null) {
            VfsUtil.markDirty((files.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
            RefreshQueue.getInstance().refresh(false, true, null, new VirtualFile[]{file});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorageManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorageManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredDataSources";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveStorages";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStored";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStoredInNewFormat";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "migrate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeBackend";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class App
    extends DbSrcStorageManager {
        public App() {
            super(null);
        }
    }
}

