/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataConsumer {
    public void setColumns(@NotNull DataRequest.Context var1, int var2, Column[] var3, int var4);

    public void addRows(@NotNull DataRequest.Context var1, List<Row> var2);

    public void afterLastRowAdded(@NotNull DataRequest.Context var1, int var2);

    public static class Composite
    extends Adapter {
        private final List<DataConsumer> delegates;

        public Composite(List<DataConsumer> delegates) {
            this.delegates = delegates;
        }

        public Composite(DataConsumer ... delegates) {
            this.delegates = Arrays.asList(delegates);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column[] infos, int firstRowNum) {
            if (context == null) {
                Composite.$$$reportNull$$$0(0);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.setColumns(context, resultSetIndex, infos, firstRowNum);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                Composite.$$$reportNull$$$0(1);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.addRows(context, rows);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                Composite.$$$reportNull$$$0(2);
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.afterLastRowAdded(context, total);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Composite";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Wrapper
    implements DataConsumer {
        public final DataConsumer delegate;

        public Wrapper(DataConsumer dataConsumer) {
            this.delegate = dataConsumer;
        }

        public boolean accepts(DataRequest.Owner owner) {
            return true;
        }

        public boolean accepts(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            return this.accepts(context.request.owner);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column[] infos, int firstRowNum) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            if (this.accepts(context)) {
                this.delegate.setColumns(context, resultSetIndex, infos, firstRowNum);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            if (this.accepts(context)) {
                this.delegate.addRows(context, rows);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(3);
            }
            if (this.accepts(context)) {
                this.delegate.afterLastRowAdded(context, total);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Wrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accepts";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Adapter
    implements DataConsumer {
        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column[] infos, int firstRowNum) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                Adapter.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Adapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setColumns";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRows";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLastRowAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Column
    implements ColumnDescriptor {
        public final int columnNum;
        public final int type;
        public final String name;
        public final String typeName;
        public final String clazz;
        public final int precision;
        public final int scale;
        public final String catalog;
        public final String schema;
        public final String table;

        public Column(int columnNum, String name, int type, String typeName, String clazz) {
            this(columnNum, name, type, typeName, clazz, -1, -1, null, null, null);
        }

        public Column(int columnNum, String name, int type, String typeName, String clazz, int precision, int scale, @Nullable String catalog, @Nullable String schema, @Nullable String table) {
            this.columnNum = columnNum;
            this.name = name;
            this.type = type;
            this.typeName = typeName;
            this.clazz = clazz;
            this.precision = precision;
            this.scale = scale;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
        }

        @Nullable
        public Object getValue(@NotNull Row row) {
            if (row == null) {
                Column.$$$reportNull$$$0(0);
            }
            return row.values[this.columnNum];
        }

        public void setValue(@NotNull Row row, Object o) {
            if (row == null) {
                Column.$$$reportNull$$$0(1);
            }
            row.values[this.columnNum] = o;
        }

        @Override
        public String getJavaClassName() {
            return this.clazz;
        }

        @NotNull
        public DataType asDataType() {
            String type = StringUtil.isEmpty((String)this.typeName) ? "unknown" : this.typeName;
            DataType dataType = DataTypeFactory.of(this.schema, type, this.precision, this.scale, null, null, false, false);
            if (dataType == null) {
                Column.$$$reportNull$$$0(2);
            }
            return dataType;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        public String toString() {
            return "Column" + this.columnNum + "{name='" + this.name + '\'' + ", type=" + this.type + ", typeName='" + this.typeName + '\'' + ", clazz='" + this.clazz + '\'' + ", table='" + this.catalog + '\'' + ".'" + this.schema + '\'' + ".'" + this.table + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (this.columnNum != column.columnNum) {
                return false;
            }
            if (this.precision != column.precision) {
                return false;
            }
            if (this.scale != column.scale) {
                return false;
            }
            if (this.type != column.type) {
                return false;
            }
            if (this.catalog != null ? !this.catalog.equals(column.catalog) : column.catalog != null) {
                return false;
            }
            if (this.clazz != null ? !this.clazz.equals(column.clazz) : column.clazz != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(column.name) : column.name != null) {
                return false;
            }
            if (this.schema != null ? !this.schema.equals(column.schema) : column.schema != null) {
                return false;
            }
            if (this.table != null ? !this.table.equals(column.table) : column.table != null) {
                return false;
            }
            return !(this.typeName != null ? !this.typeName.equals(column.typeName) : column.typeName != null);
        }

        public int hashCode() {
            int result2 = this.columnNum;
            result2 = 31 * result2 + this.type;
            result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
            result2 = 31 * result2 + (this.typeName != null ? this.typeName.hashCode() : 0);
            result2 = 31 * result2 + (this.clazz != null ? this.clazz.hashCode() : 0);
            result2 = 31 * result2 + this.precision;
            result2 = 31 * result2 + this.scale;
            result2 = 31 * result2 + (this.catalog != null ? this.catalog.hashCode() : 0);
            result2 = 31 * result2 + (this.schema != null ? this.schema.hashCode() : 0);
            result2 = 31 * result2 + (this.table != null ? this.table.hashCode() : 0);
            return result2;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public int getSize() {
            return this.precision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/DataConsumer$Column";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/DataConsumer$Column";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asDataType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Row {
        public final int rowNum;
        public final Object[] values;

        protected Row(int rowNum, Object[] values2) {
            this.rowNum = rowNum;
            this.values = values2;
        }

        public static Row create(int realIdx, Object[] values2) {
            return new Row(realIdx + 1, values2);
        }

        public static int toRealIdx(@NotNull Row row) {
            if (row == null) {
                Row.$$$reportNull$$$0(0);
            }
            return row.rowNum - 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            if (this.rowNum != row.rowNum) {
                return false;
            }
            return Arrays.equals(this.values, row.values);
        }

        public int hashCode() {
            int result2 = this.rowNum;
            result2 = 31 * result2 + Arrays.hashCode(this.values);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DataConsumer$Row", "toRealIdx"));
        }
    }
}

