/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GridFilteringModelImpl
implements GridFilteringModel {
    private final EventDispatcher<GridFilteringModel.Listener> myEventDispatcher;
    private final DatabaseTableGridDataHookUp myHookUp;
    private final List<String> myHistory;
    private boolean myApplied;
    private boolean myEnabled;
    private Document myDocument;

    public GridFilteringModelImpl(@NotNull Document document, @NotNull DatabaseTableGridDataHookUp hookUp) {
        if (document == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(0);
        }
        if (hookUp == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher = EventDispatcher.create(GridFilteringModel.Listener.class);
        this.myHistory = ContainerUtil.newArrayList();
        this.myDocument = document;
        this.myHookUp = hookUp;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myEnabled;
    }

    @Override
    public void applyFilter(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
        String text2;
        boolean empty;
        if (source == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(2);
        }
        if (!(empty = StringUtil.isEmpty((String)(text2 = this.getFilterText().trim())))) {
            this.myHistory.remove(text2);
            this.myHistory.add(0, text2);
            this.trimFilterHistory();
        }
        this.myApplied = !empty;
        this.myHookUp.getLoader().applyFilter(source);
    }

    @Override
    public void onError() {
        this.myHistory.remove(this.getFilterText());
        this.myApplied = false;
    }

    private void trimFilterHistory() {
        DatabaseSettings settings = DatabaseSettings.getSettings();
        int historySize = Math.max(0, settings.getFiltersHistorySize());
        while (this.myHistory.size() > historySize) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
    }

    @Override
    public void setHistory(@NotNull List<String> history) {
        if (history == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(3);
        }
        this.myHistory.clear();
        this.myHistory.addAll(history);
        this.trimFilterHistory();
    }

    @Override
    @NotNull
    public List<String> getHistory() {
        List<String> list = this.myHistory;
        if (list == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void setFilteringEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    @NotNull
    public String getFilterText() {
        String string = this.myDocument.getText();
        if (string == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void setFilterText(@NotNull String filter) {
        boolean valueChanged;
        if (filter == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(6);
        }
        String newFilter = filter.trim();
        String currentFilter = this.getFilterText();
        boolean bl = valueChanged = !Comparing.equal((String)currentFilter, (String)newFilter);
        if (!valueChanged) {
            return;
        }
        this.myApplied = false;
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (filter == null) {
                GridFilteringModelImpl.$$$reportNull$$$0(11);
            }
            this.myDocument.setText((CharSequence)filter);
        });
    }

    @Override
    public boolean isFilterApplied() {
        return this.myApplied;
    }

    @Override
    @NotNull
    public Document getFilterDocument() {
        Document document = this.myDocument;
        if (document == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(7);
        }
        return document;
    }

    @Override
    public void addListener(@NotNull GridFilteringModel.Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(8);
        }
        if (disposable == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(9);
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable);
    }

    void setDocument(@NotNull Document document) {
        if (document == null) {
            GridFilteringModelImpl.$$$reportNull$$$0(10);
        }
        this.myDocument = document;
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).filterDocumentChanged(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridFilteringModelImpl";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridFilteringModelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHistory";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDocument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setFilterText$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

