/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DatabaseTableInput;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.database.DatabaseDataPreviewComponent;
import com.intellij.database.dbimport.ui.database.DatabaseTableEditorComponent;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseInputType
implements ImportAction.InputType {
    private static final String TITLE_MASK = "Import \"%s\" Table";
    private final LocalDataSource myProducerLocalDataSource;
    private final String myQueryText;
    private final String myProducerName;
    private final SearchPath myPath;
    private final DasTable myTable;
    private final Project myProject;
    private final DbDataSource myProducerSource;

    public DatabaseInputType(@NotNull LocalDataSource producerLocalDataSource, @NotNull DbDataSource producerDataSource, @NotNull DasTable table, @NotNull Project project) {
        if (producerLocalDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(0);
        }
        if (producerDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(1);
        }
        if (table == null) {
            DatabaseInputType.$$$reportNull$$$0(2);
        }
        if (project == null) {
            DatabaseInputType.$$$reportNull$$$0(3);
        }
        this(producerLocalDataSource, producerDataSource, table.getName(), DatabaseInputType.getQueryText(table, producerLocalDataSource, DbImplUtil.getDatabaseDialect((DbElement)producerDataSource)), project, DatabaseInputType.getSearchPath(producerDataSource, table), table);
    }

    public DatabaseInputType(@NotNull LocalDataSource producerLocalDataSource, @NotNull DbDataSource source, @NotNull String producerName, @NotNull String queryText, @NotNull Project project, @Nullable SearchPath path, @Nullable DasTable table) {
        if (producerLocalDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(4);
        }
        if (source == null) {
            DatabaseInputType.$$$reportNull$$$0(5);
        }
        if (producerName == null) {
            DatabaseInputType.$$$reportNull$$$0(6);
        }
        if (queryText == null) {
            DatabaseInputType.$$$reportNull$$$0(7);
        }
        if (project == null) {
            DatabaseInputType.$$$reportNull$$$0(8);
        }
        this.myProducerLocalDataSource = producerLocalDataSource;
        this.myProducerName = producerName;
        this.myQueryText = queryText;
        this.myProject = project;
        this.myProducerSource = source;
        this.myPath = path == null && table != null ? DatabaseInputType.getSearchPath(source, table) : path;
        this.myTable = table;
    }

    @Override
    @NotNull
    public ReaderTask.Input createInput(@NotNull ImportInfo info) {
        if (info == null) {
            DatabaseInputType.$$$reportNull$$$0(9);
        }
        DatabaseTableInput databaseTableInput = new DatabaseTableInput(this.myProducerSource, this.myProducerLocalDataSource, this.myPath, this.myQueryText, this.myProject);
        if (databaseTableInput == null) {
            DatabaseInputType.$$$reportNull$$$0(10);
        }
        return databaseTableInput;
    }

    @Override
    @NotNull
    public List<ImportComponent<?, ?>> getComponents(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            DatabaseInputType.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.list((Object[])new ImportComponent[]{new DatabaseDataPreviewComponent(context, this.myProducerLocalDataSource, this.myPath, this.myQueryText), new ImportSettingsComponent(context), new DdlPreviewComponent(context), new DatabaseTableEditorComponent(context)});
        if (list == null) {
            DatabaseInputType.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = String.format(TITLE_MASK, this.myProducerName);
        if (string == null) {
            DatabaseInputType.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @Nullable
    public DatabaseSystem getProducerSystem() {
        return this.myProducerLocalDataSource;
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(this.myProducerLocalDataSource);
        if (databaseDialectEx == null) {
            DatabaseInputType.$$$reportNull$$$0(14);
        }
        return databaseDialectEx;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportAction.ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
        if (context == null) {
            DatabaseInputType.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            DatabaseInputType.$$$reportNull$$$0(16);
        }
        DatabaseEditorContext editorContext = new DatabaseEditorContext((DbElement)this.myProducerSource, null);
        DeModel model = AbstractDbRefactoringDialog.createModel(editorContext);
        ImportInfo.Builder builder = context.getBuilder();
        List<? extends ColumnDescriptor> visibleProducers = builder.getVisibleProducers();
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        DeTable table = ImportUtil.createDeTableFromColumns(model, producers, this.myProducerName);
        table.parent = context.getNamespace();
        table.name = context.getTableName();
        table.comment = this.myTable == null ? table.comment : this.myTable.getComment();
        table.editedObject = null;
        table.getChildren().forEach(child -> {
            child.editedObject = null;
        });
        for (int i2 = 0; i2 < Math.min(producers.size(), table.columns.size()); ++i2) {
            ImportUtil.ColumnTypePredictorInfo info = new ImportUtil.ColumnTypePredictorInfo(context, (ColumnDescriptor)producers.get(i2), rows);
            table.columns.get((int)i2).dataType = this.getPreferredConsumerColumnType(info);
        }
        ImportUtil.removeUnsupportedObjects(table, context.getCaps());
        ImportUtil.removeUntransferableObjects(table);
        DeTable deTable = table;
        if (deTable == null) {
            DatabaseInputType.$$$reportNull$$$0(17);
        }
        return deTable;
    }

    @NotNull
    private String getPreferredConsumerColumnType(@NotNull ImportUtil.ColumnTypePredictorInfo info) {
        if (info == null) {
            DatabaseInputType.$$$reportNull$$$0(18);
        }
        DatabaseDialectEx producerDialect = DbImplUtil.getDatabaseDialect(this.myProducerLocalDataSource);
        String producerVersion = this.myProducerLocalDataSource.getDatabaseProductVersion();
        Domain producerDomain = DomainRegistry.getDomain(producerDialect, producerVersion, info.column, false);
        DatabaseDialectEx dialect = info.context.getDialect();
        DbDataSource source = info.context.getDataSource();
        String version = source == null ? null : source.getDatabaseProductVersion();
        Domain consumerDomain = producerDomain == null ? null : DomainRegistry.getMostRecentDomain(producerDomain, dialect, version);
        String string = consumerDomain == null ? ImportUtil.getPreferredTypeBasedOnContent(info) : consumerDomain.name();
        if (string == null) {
            DatabaseInputType.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getQueryText(@NotNull DasTable table, @NotNull LocalDataSource localDataSource, @NotNull DatabaseDialectEx dialect) {
        if (table == null) {
            DatabaseInputType.$$$reportNull$$$0(20);
        }
        if (localDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(21);
        }
        if (dialect == null) {
            DatabaseInputType.$$$reportNull$$$0(22);
        }
        String string = DbImplUtil.createSelectAllQuery(table, dialect, localDataSource).getStatement();
        if (string == null) {
            DatabaseInputType.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    private static SearchPath getSearchPath(@NotNull DbDataSource producerDataSource, @NotNull DasTable table) {
        if (producerDataSource == null) {
            DatabaseInputType.$$$reportNull$$$0(24);
        }
        if (table == null) {
            DatabaseInputType.$$$reportNull$$$0(25);
        }
        return SearchPath.of((DasObject)DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect((DbElement)producerDataSource), (DasObject)table));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerLocalDataSource";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDataSource";
                break;
            }
            case 2: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/DatabaseInputType";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localDataSource";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/DatabaseInputType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createInput";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialogTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTable";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredConsumerColumnType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInput";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createNewTable";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredConsumerColumnType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSearchPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

