/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ImporterGenerator;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.AbstractDatabaseModifier;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.DoubleAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ImportDatabaseModifier
extends AbstractDatabaseModifier {
    private static final Logger LOG = Logger.getInstance(ImportDatabaseModifier.class);
    private static final double UNSET = -1.0;
    private static final String INDICATOR_TITLE = "Importing Data...";
    private final AbstractDatabaseModifier.QueryExecutor myExecutor;

    public ImportDatabaseModifier(@NotNull DbDataSource dataSource, @NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull ReaderTask.Input reader, @Nullable SearchPath searchPath) {
        if (dataSource == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(2);
        }
        if (dialectEx == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(3);
        }
        if (reader == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(4);
        }
        super(dataSource, searchPath, INDICATOR_TITLE);
        this.myExecutor = new ImportExecutor(info, project, dialectEx, (DatabaseSystem)dataSource, reader);
    }

    @Override
    @NotNull
    protected AbstractDatabaseModifier.QueryExecutor getExecutor() {
        AbstractDatabaseModifier.QueryExecutor queryExecutor = this.myExecutor;
        if (queryExecutor == null) {
            ImportDatabaseModifier.$$$reportNull$$$0(5);
        }
        return queryExecutor;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectEx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportDatabaseModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportDatabaseModifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class IndicatorUpdater {
        protected final ProgressIndicator myIndicator;
        protected final ImportInfo myInfo;
        protected final DoubleAdder mySize;
        protected double myCurrentSize;
        protected long myLines;
        protected long myStartTime;

        public IndicatorUpdater(@NotNull ProgressIndicator indicator, @NotNull DoubleAdder size, @NotNull ImportInfo info) {
            if (indicator == null) {
                IndicatorUpdater.$$$reportNull$$$0(0);
            }
            if (size == null) {
                IndicatorUpdater.$$$reportNull$$$0(1);
            }
            if (info == null) {
                IndicatorUpdater.$$$reportNull$$$0(2);
            }
            this.myIndicator = indicator;
            this.mySize = size;
            this.myInfo = info;
        }

        public void start() {
            this.myIndicator.setFraction(0.0);
            this.myIndicator.setText(this.getIndicatorTitle());
            this.myStartTime = System.currentTimeMillis();
            this.myIndicator.setText(this.getIndicatorTitle());
        }

        public void update(@NotNull BatchRecords records, long lines) {
            if (records == null) {
                IndicatorUpdater.$$$reportNull$$$0(3);
            }
            this.myIndicator.checkCanceled();
            double value = this.mySize.doubleValue();
            this.myCurrentSize += records.getBatchSize();
            this.myLines += lines;
            this.myIndicator.setText2(this.getStatistics());
            if (Double.compare(value, -1.0) == 0) {
                return;
            }
            this.myIndicator.setFraction(this.myCurrentSize / value);
        }

        @NotNull
        private String getIndicatorTitle() {
            DbDataSource source = (DbDataSource)ObjectUtils.notNull((Object)this.myInfo.getContext().getDataSource());
            String string = String.format("Importing %s to %s (%s)", this.myInfo.getProducerName(), this.myInfo.getTableName(), source.getName());
            if (string == null) {
                IndicatorUpdater.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private String getStatistics() {
            long timeSpent = (System.currentTimeMillis() - this.myStartTime) / 1000L;
            if (this.myLines == 0L || timeSpent == 0L) {
                if ("" == null) {
                    IndicatorUpdater.$$$reportNull$$$0(5);
                }
                return "";
            }
            String speed = this.calculateSpeed(timeSpent);
            String string = String.format("%s %s", this.myLines, ImportUtil.pluralizeRows(this.myLines)) + (speed == null ? "" : String.format(" (%s)", speed));
            if (string == null) {
                IndicatorUpdater.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nullable
        public abstract String calculateSpeed(long var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDatabaseModifier$IndicatorUpdater";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicatorTitle";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatistics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ImportExecutor
    implements AbstractDatabaseModifier.QueryExecutor {
        private final ImporterGenerator myGenerator;
        private final ImportInfo myInfo;
        private final DatabaseSystem mySystem;
        private final Project myProject;
        private final ReaderTask.Input myInput;
        private final ImportManager myManager;
        private final ImportErrorHandler myHandler;

        public ImportExecutor(@NotNull ImportInfo info, @NotNull Project project, @NotNull DatabaseDialectEx dialectEx, @NotNull DatabaseSystem system, @NotNull ReaderTask.Input input) {
            if (info == null) {
                ImportExecutor.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ImportExecutor.$$$reportNull$$$0(1);
            }
            if (dialectEx == null) {
                ImportExecutor.$$$reportNull$$$0(2);
            }
            if (system == null) {
                ImportExecutor.$$$reportNull$$$0(3);
            }
            if (input == null) {
                ImportExecutor.$$$reportNull$$$0(4);
            }
            this.myProject = project;
            this.myInput = input;
            this.mySystem = system;
            this.myManager = ImportManager.of(dialectEx, this.mySystem.getDatabaseProductVersion());
            this.myHandler = new ImportErrorHandler(project, info);
            this.myGenerator = new ImporterGenerator(info, this.myHandler, this.myManager, input);
            this.myInfo = info;
        }

        @Override
        public Promise<Void> execute(final @NotNull ProgressIndicator indicator, @NotNull DataRequest.OwnerEx owner, @NotNull DataProducer producer, final @NotNull ErrorHandler errorHandler) {
            if (indicator == null) {
                ImportExecutor.$$$reportNull$$$0(5);
            }
            if (owner == null) {
                ImportExecutor.$$$reportNull$$$0(6);
            }
            if (producer == null) {
                ImportExecutor.$$$reportNull$$$0(7);
            }
            if (errorHandler == null) {
                ImportExecutor.$$$reportNull$$$0(8);
            }
            DataRequest.RawRequest request = new DataRequest.RawRequest(owner){

                @Override
                public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                    indicator.setText("Updating database...");
                    this.execute(indicator, connection, errorHandler);
                }
            };
            producer.processRequest(request);
            return request.getPromise();
        }

        /*
         * Exception decompiling
         */
        public boolean execute(@NotNull ProgressIndicator indicator, @NotNull DatabaseConnection connection, @NotNull ErrorHandler errorHandler) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Nullable
        protected Long getInsertedRows(@Nullable RemoteBatchPreparedStatement remoteStatement) {
            try {
                return remoteStatement == null ? 0L : remoteStatement.getInsertedLinesCount();
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private Notification createNotification(@NotNull Project project, @Nullable Long timeSpent, @NotNull IndicatorUpdater updater, @Nullable Long importedCount, long errorsCount, boolean bl) {
            void error;
            if (project == null) {
                ImportExecutor.$$$reportNull$$$0(12);
            }
            if (updater == null) {
                ImportExecutor.$$$reportNull$$$0(13);
            }
            DbDataSource system = this.myInfo.getContext().getDataSource();
            String path = this.myInfo.getErrorTaskInfo().getErrorRecordsPath();
            String content = ImportExecutor.getContent(this.myInfo, timeSpent, path, updater, importedCount, errorsCount);
            NotificationType type = errorsCount > 0L || error != false ? NotificationType.ERROR : NotificationType.INFORMATION;
            Notification notification = ImportExecutor.createNotification(project, (DatabaseSystem)ObjectUtils.assertNotNull((Object)system), content, type, errorsCount > 0L ? path : null);
            if (notification == null) {
                ImportExecutor.$$$reportNull$$$0(14);
            }
            return notification;
        }

        private static void notifyAboutInputError(@Nullable String error, @NotNull Project project) {
            if (project == null) {
                ImportExecutor.$$$reportNull$$$0(15);
            }
            if (error != null) {
                DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(error, NotificationType.ERROR).notify(project);
            }
        }

        @NotNull
        private static String getContent(@NotNull ImportInfo info, @Nullable Long timeSpent, @Nullable String path, @NotNull IndicatorUpdater updater, @Nullable Long importedCount, long errorsCount) {
            if (info == null) {
                ImportExecutor.$$$reportNull$$$0(16);
            }
            if (updater == null) {
                ImportExecutor.$$$reportNull$$$0(17);
            }
            String string = ImportExecutor.getTitle(info) + ImportExecutor.getInsertedCount(importedCount) + ImportExecutor.getStatistics(timeSpent, updater) + ImportExecutor.getErrorsCount(path, errorsCount);
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(18);
            }
            return string;
        }

        @NotNull
        private static String getTitle(@NotNull ImportInfo info) {
            if (info == null) {
                ImportExecutor.$$$reportNull$$$0(19);
            }
            String string = String.format("%s imported to %s", info.getProducerName(), info.getTableName());
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(20);
            }
            return string;
        }

        @NotNull
        private static String getStatistics(@Nullable Long timeSpent, @NotNull IndicatorUpdater updater) {
            if (updater == null) {
                ImportExecutor.$$$reportNull$$$0(21);
            }
            String time = ImportExecutor.getTimeSpent(timeSpent);
            String speed = ImportExecutor.getSpeed(timeSpent, updater);
            boolean isTimeEmpty = StringUtil.isEmpty((String)time);
            boolean isSpeedEmpty = StringUtil.isEmpty((String)speed);
            String string = isTimeEmpty && isSpeedEmpty ? "" : (isTimeEmpty || isSpeedEmpty ? String.format(" (%s)", isTimeEmpty ? speed : time) : String.format(" (%s, %s)", time, speed));
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(22);
            }
            return string;
        }

        @NotNull
        private static String getInsertedCount(@Nullable Long importedCount) {
            String string = importedCount == null ? "" : String.format(": %s %s", String.valueOf(importedCount), ImportUtil.pluralizeRows(importedCount));
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(23);
            }
            return string;
        }

        @NotNull
        private static String getErrorsCount(@Nullable String path, long errorsCount) {
            String string = errorsCount > 0L ? ImportExecutor.getErrorNotification(path, errorsCount) : "";
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(24);
            }
            return string;
        }

        @NotNull
        private static String getErrorNotification(@Nullable String path, long errorsCount) {
            String errors = ImportUtil.pluralize("error", errorsCount);
            String string = String.format(path == null ? "\n%s %s occurred" : "\n%s %s saved to", errorsCount, errors);
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(25);
            }
            return string;
        }

        @NotNull
        private static String getTimeSpent(@Nullable Long timeSpent) {
            String string = timeSpent == null ? "" : StringUtil.formatDuration((long)timeSpent);
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(26);
            }
            return string;
        }

        @NotNull
        private static String getSpeed(@Nullable Long timeSpent, @NotNull IndicatorUpdater updater) {
            if (updater == null) {
                ImportExecutor.$$$reportNull$$$0(27);
            }
            if (timeSpent == null || timeSpent / 1000L == 0L) {
                if ("" == null) {
                    ImportExecutor.$$$reportNull$$$0(28);
                }
                return "";
            }
            String string = StringUtil.notNullize((String)updater.calculateSpeed(timeSpent / 1000L));
            if (string == null) {
                ImportExecutor.$$$reportNull$$$0(29);
            }
            return string;
        }

        @NotNull
        private static Notification createNotification(@NotNull Project project, @NotNull DatabaseSystem system, @NotNull String content, @NotNull NotificationType type, @Nullable String path) {
            if (project == null) {
                ImportExecutor.$$$reportNull$$$0(30);
            }
            if (system == null) {
                ImportExecutor.$$$reportNull$$$0(31);
            }
            if (content == null) {
                ImportExecutor.$$$reportNull$$$0(32);
            }
            if (type == null) {
                ImportExecutor.$$$reportNull$$$0(33);
            }
            Notification notification = path == null ? DbUIUtil.createNotification(system, content, type) : DbUIUtil.createFileLinkNotification(project, system, content, type, path);
            if (notification == null) {
                ImportExecutor.$$$reportNull$$$0(34);
            }
            return notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void execute(@NotNull DatabaseConnection connection, @NotNull List<String> queries) throws Exception {
            if (connection == null) {
                ImportExecutor.$$$reportNull$$$0(35);
            }
            if (queries == null) {
                ImportExecutor.$$$reportNull$$$0(36);
            }
            Statement statement = connection.createStatement();
            try {
                for (String query : queries) {
                    statement.execute(query);
                }
            }
            finally {
                JdbcUtil.closeStatementSafe((Statement)statement);
            }
        }

        private static void executeInFinally(@NotNull DatabaseConnection connection, @NotNull List<String> queries) {
            if (connection == null) {
                ImportExecutor.$$$reportNull$$$0(37);
            }
            if (queries == null) {
                ImportExecutor.$$$reportNull$$$0(38);
            }
            try {
                ImportExecutor.execute(connection, queries);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 14: 
                case 18: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 34: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 14: 
                case 18: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 34: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: 
                case 12: 
                case 15: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialectEx";
                    break;
                }
                case 3: 
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "system";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 10: 
                case 35: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 13: 
                case 17: 
                case 21: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 14: 
                case 18: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 34: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 36: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/ImportDatabaseModifier$ImportExecutor";
                    break;
                }
                case 14: 
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNotification";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatistics";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertedCount";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorsCount";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorNotification";
                    break;
                }
                case 26: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeSpent";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpeed";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 35: 
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 12: 
                case 13: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "createNotification";
                    break;
                }
                case 14: 
                case 18: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 34: {
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyAboutInputError";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getContent";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getTitle";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatistics";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpeed";
                    break;
                }
                case 37: 
                case 38: {
                    objectArray = objectArray;
                    objectArray[2] = "executeInFinally";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 14: 
                case 18: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 34: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

