/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDb2Dialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerbyDialect
extends AbstractDb2Dialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.INDEX).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.TABLE, ObjectKind.CHECK).put(ObjectKind.TABLE, ObjectKind.TRIGGER).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).build();
    public static final DerbyDialect INSTANCE = new DerbyDialect();

    public DerbyDialect() {
        super(META_MODEL, new TypeHelper.DerbyTypeHelper(), new KeywordHelper.DerbyKeywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.DERBY;
        if (databaseFamilyId == null) {
            DerbyDialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.ApacheDerby;
        if (icon == null) {
            DerbyDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Derby" == null) {
            DerbyDialect.$$$reportNull$$$0(2);
        }
        return "Derby";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            DerbyDialect.$$$reportNull$$$0(3);
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("Apache Derby");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DerbyDialect.$$$reportNull$$$0(5);
        }
        if (attrs == null) {
            DerbyDialect.$$$reportNull$$$0(6);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddColumnSQL(builder, column, true, false, true);
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(7);
        }
        return ddlBuilder;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            DerbyDialect.$$$reportNull$$$0(8);
        }
        if (connection == null) {
            DerbyDialect.$$$reportNull$$$0(9);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "values (current schema)", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.SCHEMA, Collections.singletonList(s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            DerbyDialect.$$$reportNull$$$0(10);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    public boolean supportsDropSchema() {
        return true;
    }

    @Override
    public boolean supportsRenameRoutine() {
        return false;
    }

    @Override
    public boolean supportsRenameSchema() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(11);
        }
        if (pk == null) {
            DerbyDialect.$$$reportNull$$$0(12);
        }
        DasTable table = pk.getTable();
        for (DasTypedObject colInfo : pk.getColumnsRef().resolveObjects()) {
            builder.keyword("ALTER TABLE").space();
            builder.qualifiedRef((DasObject)table).space();
            builder.keyword("ALTER COLUMN");
            builder.space();
            builder.columnRef((DasObject)colInfo).space();
            builder.keyword("NOT NULL");
            builder.newStatement();
        }
        DialectUtils.getAddPrimaryKeySQL(builder, pk, false);
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropSynonym() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace namespace) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(14);
        }
        if (namespace == null) {
            DerbyDialect.$$$reportNull$$$0(15);
        }
        DdlBuilder ddlBuilder = super.sqlDropSchema(builder, namespace).space().keyword("RESTRICT");
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(16);
        }
        return ddlBuilder;
    }

    public boolean supportsColumnComment() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(17);
        }
        if (column == null) {
            DerbyDialect.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.comment.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnNullable(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(19);
        }
        if (column == null) {
            DerbyDialect.$$$reportNull$$$0(20);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnNullableAlterSQL(builder, column, "ALTER COLUMN", false);
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(21);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsRenameColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(22);
        }
        if (from == null) {
            DerbyDialect.$$$reportNull$$$0(23);
        }
        if (toName == null) {
            DerbyDialect.$$$reportNull$$$0(24);
        }
        builder.keywords("RENAME", "COLUMN").space();
        builder.qualifiedRef((DasObject)from.getTable()).symbol(".").columnRef((DasObject)from).space();
        builder.keyword("TO").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(25);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnType(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(26);
        }
        if (from == null) {
            DerbyDialect.$$$reportNull$$$0(27);
        }
        if (to == null) {
            DerbyDialect.$$$reportNull$$$0(28);
        }
        if (from.getDataType().jdbcType != to.getDataType().jdbcType) {
            throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.column.type", (Object[])new Object[]{this.getDisplayName()}));
        }
        if (from.getDataType().jdbcType != 12) {
            throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.column.type.varchar", (Object[])new Object[]{this.getDisplayName()}));
        }
        if (from.getDataType().getLength() > to.getDataType().getLength()) {
            throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.column.type.varchar.length", (Object[])new Object[]{this.getDisplayName()}));
        }
        DdlBuilder ddlBuilder = super.sqlAlterColumnType(builder, from, to);
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(30);
        }
        if (column == null) {
            DerbyDialect.$$$reportNull$$$0(31);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.column.default.alter", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(32);
        }
        if (sequence == null) {
            DerbyDialect.$$$reportNull$$$0(33);
        }
        if (increment == null) {
            DerbyDialect.$$$reportNull$$$0(34);
        }
        if (minimum == null) {
            DerbyDialect.$$$reportNull$$$0(35);
        }
        if (maximum == null) {
            DerbyDialect.$$$reportNull$$$0(36);
        }
        if (start == null) {
            DerbyDialect.$$$reportNull$$$0(37);
        }
        if (cache == null) {
            DerbyDialect.$$$reportNull$$$0(38);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.create.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsDropSequence() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(39);
        }
        if (sequence == null) {
            DerbyDialect.$$$reportNull$$$0(40);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            DerbyDialect.$$$reportNull$$$0(41);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(42);
        }
        if (sequence == null) {
            DerbyDialect.$$$reportNull$$$0(43);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.sequence.information", (Object[])new Object[]{this.getDisplayName()}));
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(44);
        }
        if (sequence == null) {
            DerbyDialect.$$$reportNull$$$0(45);
        }
        if (increment == null) {
            DerbyDialect.$$$reportNull$$$0(46);
        }
        if (minimum == null) {
            DerbyDialect.$$$reportNull$$$0(47);
        }
        if (maximum == null) {
            DerbyDialect.$$$reportNull$$$0(48);
        }
        if (restart == null) {
            DerbyDialect.$$$reportNull$$$0(49);
        }
        if (cache == null) {
            DerbyDialect.$$$reportNull$$$0(50);
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.alter.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(51);
        }
        if (table == null) {
            DerbyDialect.$$$reportNull$$$0(52);
        }
        if (constraintName == null) {
            DerbyDialect.$$$reportNull$$$0(53);
        }
        if (columns2 == null) {
            DerbyDialect.$$$reportNull$$$0(54);
        }
        boolean specifyColumnType = false;
        String alterClause = "ALTER COLUMN";
        for (DasColumn column : columns2) {
            if (column.isNotNull()) continue;
            DialectUtils.getColumnNullableAlterSQL(builder, (DasTypedObject)column, false, "ALTER COLUMN", false);
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddUniqueConstraintSQL(builder, table, constraint, constraintName, columns2);
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(55);
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            DerbyDialect.$$$reportNull$$$0(56);
        }
        return Pair.create((Object)("select v.VIEWDEFINITION from sys.SYSVIEWS v, sys.SYSTABLES t, sys.SYSSCHEMAS s where v.TABLEID = t.TABLEID and s.SCHEMAID = t.SCHEMAID and UPPER(t.TABLENAME) = '" + element.getName().toUpperCase(Locale.ENGLISH) + "' and UPPER(s.SCHEMANAME) = '" + DasUtil.getSchema((DasObject)element).toUpperCase(Locale.ENGLISH) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            DerbyDialect.$$$reportNull$$$0(57);
        }
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(58);
        }
        if (statement == null) {
            DerbyDialect.$$$reportNull$$$0(59);
        }
        builder.plain("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)").newStatement();
        if (!analyze2) {
            builder.plain("CALL SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(1)").newStatement();
        }
        builder.plain(statement).newStatement();
        builder.plain("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)").newStatement();
        builder.plain("VALUES SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlPostExplainPlan(@NotNull DdlBuilder builder, boolean analyze2) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(61);
        }
        builder.plain("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)").newStatement();
        if (!analyze2) {
            builder.newStatement().plain("CALL SYSCS_UTIL.SYSCS_SET_XPLAIN_MODE(0)");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(62);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/DerbyDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 26: 
            case 30: 
            case 32: 
            case 39: 
            case 42: 
            case 44: 
            case 51: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 18: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 33: 
            case 40: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 34: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 35: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 36: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 38: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/DerbyDialect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSchema";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnNullable";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnType";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddUniqueConstraint";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlPostExplainPlan";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSchema";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnNullable";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnType";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefault";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "sqlPostExplainPlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

