/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;

public class DatabaseElementSelectInProvider
implements NullableFunction<SelectInContext, DbElement> {
    public DbElement fun(SelectInContext selectInContext) {
        DbDataSource target2;
        VirtualFile file = selectInContext.getVirtualFile();
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement dbElement = DbImplUtil.findElement(selectInContext.getProject(), file);
            Object selector = selectInContext.getSelectorInFile();
            DataGridPomTarget.Column column = selector instanceof PsiElement ? DataGridPomTarget.unwrapColumn((PsiElement)selector) : null;
            DbColumn columnElement = column == null ? null : (DbColumn)DasUtil.findChild((DasObject)dbElement, DbColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)column.getColumn().name);
            target2 = (DbElement)ObjectUtils.chooseNotNull(columnElement, (Object)dbElement);
        } else {
            Project project;
            JdbcConsole console;
            target2 = DbConsoleRootType.isConsoleFile(file) ? DbConsoleRootType.getDataSource(selectInContext.getProject(), file) : ((console = JdbcConsoleProvider.getAttachedConsole(project = selectInContext.getProject(), file)) != null ? DbPsiFacade.getInstance((Project)project).findDataSource(console.getDataSource().getUniqueId()) : null);
        }
        return target2;
    }
}

