/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class GotoRowAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DataGrid dataGrid = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        if (dataGrid != null) {
            GotoRowAction.showGoToDialog(dataGrid);
        }
    }

    public static void showGoToDialog(DataGrid dataGrid) {
        GotoRowDialog dialog = new GotoRowDialog(dataGrid);
        dialog.show();
    }

    public void update(AnActionEvent e) {
        DataGrid resultPanel = (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(e.getDataContext());
        boolean enabled = resultPanel != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public static enum Counter {
        REGULAR{

            @Override
            public int verticalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DataGridUtil.min(grid.getSelectionModel().getSelectedRows().toView(grid));
            }

            @Override
            public int horizontalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    1.$$$reportNull$$$0(1);
                }
                return DataGridUtil.min(grid.getSelectionModel().getSelectedColumns().toView(grid));
            }

            @Override
            public int verticalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (Integer)coordinates.first;
            }

            @Override
            public int horizontalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    1.$$$reportNull$$$0(3);
                }
                return (Integer)coordinates.second;
            }

            @Override
            public int rowIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (s == null) {
                    1.$$$reportNull$$$0(5);
                }
                return StringUtil.isEmpty((String)s) ? Counter.defaultRow(grid) : StringUtil.parseInt((String)s, (int)-1);
            }

            @Override
            public int columnIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (s == null) {
                    1.$$$reportNull$$$0(7);
                }
                try {
                    return Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    GridModel model;
                    if (StringUtil.isEmpty((String)s)) {
                        return Counter.defaultColumn(grid);
                    }
                    List indexList = grid.getVisibleColumns().asList();
                    ModelIndex idx = (ModelIndex)ContainerUtil.find(indexList, arg_0 -> 1.lambda$columnIndex$0(model = grid.getDataModel(DataAccessType.DATABASE_DATA), s, arg_0));
                    return idx == null ? Counter.defaultColumn(grid) : idx.toView(grid).asInteger() + 1;
                }
            }

            private static /* synthetic */ boolean lambda$columnIndex$0(GridModel model, @NotNull String s, ModelIndex c) {
                DataConsumer.Column column;
                if (s == null) {
                    1.$$$reportNull$$$0(8);
                }
                return (column = (DataConsumer.Column)model.getColumn(c)) != null && StringUtil.equalsIgnoreCase((CharSequence)column.getName(), (CharSequence)s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grid";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "coordinates";
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/GotoRowAction$Counter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "verticalUnit";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "horizontalUnit";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rowIndex";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "columnIndex";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$columnIndex$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        TRANSPOSED{

            @Override
            public int verticalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    2.$$$reportNull$$$0(0);
                }
                return REGULAR.horizontalUnit(grid);
            }

            @Override
            public int horizontalUnit(@NotNull DataGrid grid) {
                if (grid == null) {
                    2.$$$reportNull$$$0(1);
                }
                return REGULAR.verticalUnit(grid);
            }

            @Override
            public int verticalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    2.$$$reportNull$$$0(2);
                }
                return REGULAR.horizontalUnit(coordinates);
            }

            @Override
            public int horizontalUnit(@NotNull Couple<Integer> coordinates) {
                if (coordinates == null) {
                    2.$$$reportNull$$$0(3);
                }
                return REGULAR.verticalUnit(coordinates);
            }

            @Override
            public int rowIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (s == null) {
                    2.$$$reportNull$$$0(5);
                }
                return REGULAR.columnIndex(grid, s);
            }

            @Override
            public int columnIndex(@NotNull DataGrid grid, @NotNull String s) {
                if (grid == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (s == null) {
                    2.$$$reportNull$$$0(7);
                }
                return REGULAR.rowIndex(grid, s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "grid";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "coordinates";
                        break;
                    }
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/editor/GotoRowAction$Counter$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "verticalUnit";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "horizontalUnit";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rowIndex";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "columnIndex";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract int horizontalUnit(@NotNull DataGrid var1);

        public abstract int horizontalUnit(@NotNull Couple<Integer> var1);

        public abstract int verticalUnit(@NotNull DataGrid var1);

        public abstract int verticalUnit(@NotNull Couple<Integer> var1);

        public abstract int rowIndex(@NotNull DataGrid var1, @NotNull String var2);

        public abstract int columnIndex(@NotNull DataGrid var1, @NotNull String var2);

        private static int defaultColumn(@NotNull DataGrid dataGrid) {
            int min;
            if (dataGrid == null) {
                Counter.$$$reportNull$$$0(0);
            }
            int result2 = (min = DataGridUtil.min(dataGrid.getSelectionModel().getSelectedColumns().toView(dataGrid))) == -1 ? DataGridUtil.min(dataGrid.getVisibleColumns().toView(dataGrid)) : min;
            return result2 == -1 ? -1 : result2 + 1;
        }

        private static int defaultRow(@NotNull DataGrid dataGrid) {
            int min;
            if (dataGrid == null) {
                Counter.$$$reportNull$$$0(1);
            }
            int result2 = (min = DataGridUtil.min(dataGrid.getSelectionModel().getSelectedRows().toView(dataGrid))) == -1 ? DataGridUtil.min(dataGrid.getVisibleRows().toView(dataGrid)) : min;
            return result2 == -1 ? -1 : result2 + 1;
        }

        @NotNull
        public static Counter get(@NotNull DataGrid grid) {
            if (grid == null) {
                Counter.$$$reportNull$$$0(2);
            }
            Counter counter = grid.isTransposed() ? TRANSPOSED : REGULAR;
            if (counter == null) {
                Counter.$$$reportNull$$$0(3);
            }
            return counter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataGrid";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/GotoRowAction$Counter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/GotoRowAction$Counter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "defaultColumn";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "defaultRow";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GotoRowDialog
    extends DialogWrapper {
        private JTextField myField;
        private final DataGrid myDataGrid;

        public GotoRowDialog(DataGrid dataGrid) {
            super((Component)dataGrid.getPreferredFocusedComponent(), true);
            this.myDataGrid = dataGrid;
            this.setTitle("Go to Row");
            this.init();
        }

        protected void doOKAction() {
            Couple<Integer> coordinates = this.coordinates();
            Counter counter = Counter.get(this.myDataGrid);
            int column = counter.horizontalUnit(coordinates);
            int row = counter.verticalUnit(coordinates);
            ModelIndex columnIdx = this.myDataGrid.uiColumn(column);
            ModelIndex rowIdx = this.myDataGrid.uiRow(row);
            if (columnIdx.isValid(this.myDataGrid) && rowIdx.asInteger() != -1) {
                this.myDataGrid.showCell(rowIdx, columnIdx);
                super.doOKAction();
            }
        }

        @NotNull
        private Couple<Integer> coordinates() {
            String text2 = this.getText();
            int idx = GotoRowDialog.separatorIndex(text2);
            Counter counter = Counter.get(this.myDataGrid);
            String row = idx == -1 ? String.valueOf(text2) : text2.substring(0, idx).trim();
            String column = idx == -1 ? "" : text2.substring(idx + 1).trim();
            int rowIdx = counter.rowIndex(this.myDataGrid, row);
            int columnIdx = counter.columnIndex(this.myDataGrid, column);
            Couple couple = Couple.of((Object)rowIdx, (Object)columnIdx);
            if (couple == null) {
                GotoRowDialog.$$$reportNull$$$0(0);
            }
            return couple;
        }

        private static int separatorIndex(String text2) {
            int colonIndex = text2.indexOf(58);
            return colonIndex >= 0 ? colonIndex : text2.indexOf(44);
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            JTextField jTextField = this.myField;
            if (jTextField == null) {
                GotoRowDialog.$$$reportNull$$$0(1);
            }
            return jTextField;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        private String getText() {
            return this.myField.getText();
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)8, (int)4);
            gbConstraints.fill = 3;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel label = new JLabel("[Row] [:column]:");
            panel.add((Component)label, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            class MyTextField
            extends JTextField {
                public MyTextField() {
                    super("");
                }

                @Override
                @NotNull
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    Dimension dimension = new Dimension(200, d.height);
                    if (dimension == null) {
                        MyTextField.$$$reportNull$$$0(0);
                    }
                    return dimension;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/editor/GotoRowAction$GotoRowDialog$1MyTextField", "getPreferredSize"));
                }
            }
            this.myField = new MyTextField();
            panel.add((Component)this.myField, gbConstraints);
            this.myField.setToolTipText(StringUtil.escapeXml((String)"[<row>][:<column>] or [<row>][,<column>]"));
            return panel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/editor/GotoRowAction$GotoRowDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "coordinates";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredFocusedComponent";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

