/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection.jdbcMetadataWrappers;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.properties.JdbcProcedureType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoutineIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.Routine> {
    private final DatabaseFamilyId myFamilyId;
    private final DatabaseMetaDataWrapper.Schema mySchema;
    private final boolean myCatIsPkg;
    private final boolean myProc;
    private final MetaDataUtil.SpecNamer namer;

    public RoutineIt(@Nullable ResultSet rs, @NotNull DatabaseFamilyId familyId, @NotNull DatabaseMetaDataWrapper.Schema schema, boolean catIsPkg, boolean proc) throws SQLException {
        if (familyId == null) {
            RoutineIt.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            RoutineIt.$$$reportNull$$$0(1);
        }
        super(rs);
        this.namer = new MetaDataUtil.SpecNamer();
        this.myFamilyId = familyId;
        this.mySchema = schema;
        this.myCatIsPkg = catIsPkg;
        this.myProc = proc;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.Routine createStorage() {
        DatabaseMetaDataWrapper.Routine routine = new DatabaseMetaDataWrapper.Routine(this.mySchema, "", "");
        if (routine == null) {
            RoutineIt.$$$reportNull$$$0(2);
        }
        return routine;
    }

    @Override
    protected DatabaseMetaDataWrapper.Routine calcValue() throws SQLException {
        DatabaseMetaDataWrapper.Routine res = (DatabaseMetaDataWrapper.Routine)this.getStorageToFill();
        try {
            String cat = this.getCatalog();
            String database = !this.myCatIsPkg ? StringUtil.nullize((String)cat) : null;
            String string = res.pkg = this.myCatIsPkg ? StringUtil.nullize((String)cat) : null;
            if (!StringUtil.equalsIgnoreCase((CharSequence)this.mySchema.schema, (CharSequence)this.getSchema())) {
                return (DatabaseMetaDataWrapper.Routine)this.skip();
            }
            String origName = this.getName();
            Pair<String, Short> name = GenericIntrospectorLegacyModelUtils.fixProcedureName(this.mySchema.schema, this.myFamilyId, origName);
            if (name == null || StringUtil.isEmpty((String)((String)name.first))) {
                return (DatabaseMetaDataWrapper.Routine)this.skip();
            }
            res.name = (String)name.first;
            res.number = (Short)name.second;
            String spec = this.getSpecificName();
            res.specificName = this.namer.getSpecName(spec, res.name, res.pkg);
            this.namer.finish(spec, res.name, res.pkg);
            res.comment = this.getRemarks();
            if (this.myProc) {
                res.kind = this.getType();
                if (this.myFamilyId.isSybase()) {
                    res.kind = DasRoutine.Kind.PROCEDURE;
                }
            } else {
                res.kind = DasRoutine.Kind.FUNCTION;
            }
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.Routine)this.skip();
        }
        return res;
    }

    private DasRoutine.Kind getType() throws SQLException {
        return JdbcProcedureType.findByID(this.myRs.getShort("PROCEDURE_TYPE", 8)).getKind();
    }

    private String getRemarks() throws SQLException {
        return this.myRs.getString("REMARKS", this.myProc ? 7 : 4);
    }

    private String getSpecificName() throws SQLException {
        return this.myRs.getString("SPECIFIC_NAME", this.myProc ? 9 : 6);
    }

    private String getName() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_NAME" : "FUNCTION_NAME", 3);
    }

    @NotNull
    private String getSchema() throws SQLException {
        String string = StringUtil.notNullize((String)this.myRs.getString(this.myProc ? "PROCEDURE_SCHEM" : "FUNCTION_SCHEM", 2), (String)this.mySchema.schema);
        if (string == null) {
            RoutineIt.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private String getCatalog() throws SQLException {
        return this.myRs.getString(this.myProc ? "PROCEDURE_CAT" : "FUNCTION_CAT", 1);
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.Routine cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.schema.database, cur.schema.schema, cur.name);
        this.addError(title, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/introspection/jdbcMetadataWrappers/RoutineIt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/introspection/jdbcMetadataWrappers/RoutineIt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

