/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetaModelImpl
implements MetaModel {
    private final Set<Couple<ObjectKind>> objectClasses;
    private final Map<String, ObjectKind> objectKinds;
    private final Map<ObjectKind, ObjectKind> aliases;
    private final Set<ObjectKind> namespaces;
    private final MultiMap<ObjectKind, List<ObjectKind>> paths;

    @NotNull
    public static MetaModelBuilder builder() {
        MetaModelBuilder metaModelBuilder = new MetaModelBuilder();
        if (metaModelBuilder == null) {
            MetaModelImpl.$$$reportNull$$$0(0);
        }
        return metaModelBuilder;
    }

    private MetaModelImpl(@NotNull Set<Couple<ObjectKind>> objectClasses, @NotNull Map<String, ObjectKind> objectKinds, @NotNull Map<ObjectKind, ObjectKind> aliases) {
        if (objectClasses == null) {
            MetaModelImpl.$$$reportNull$$$0(1);
        }
        if (objectKinds == null) {
            MetaModelImpl.$$$reportNull$$$0(2);
        }
        if (aliases == null) {
            MetaModelImpl.$$$reportNull$$$0(3);
        }
        this.paths = MultiMap.createLinkedSet();
        this.objectClasses = objectClasses;
        this.objectKinds = objectKinds;
        this.aliases = aliases;
        this.namespaces = Collections.unmodifiableSet((Set)JBIterable.from(objectClasses).transform(Functions.pairSecond()).filter(k -> k == ObjectKind.SCHEMA || k == ObjectKind.DATABASE).addAllTo((Collection)ContainerUtil.newLinkedHashSet()));
        JBIterable traversal = ((JBTreeTraverser)JBTreeTraverser.from(this::getChildKinds).withRoot((Object)ObjectKind.ROOT)).traverse(TreeTraversal.INTERLEAVED_DFS);
        int pathLenMax = objectKinds.size();
        int pathLenToStop = pathLenMax * pathLenMax;
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)traversal.typedIterator();
        while (it.hasNext()) {
            ObjectKind next = (ObjectKind)it.next();
            List list = it.backtrace().toList();
            if (list.size() <= pathLenMax) {
                this.paths.putValue((Object)next, (Object)ContainerUtil.newUnmodifiableList((List)list));
            }
            if (list.size() <= pathLenToStop) continue;
            break;
        }
    }

    @NotNull
    public Set<Couple<ObjectKind>> getKindCouples() {
        Set<Couple<ObjectKind>> set = this.objectClasses;
        if (set == null) {
            MetaModelImpl.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public JBIterable<ObjectKind> getRootNamespaceKinds() {
        JBIterable<ObjectKind> jBIterable = this.getChildKinds(ObjectKind.ROOT);
        if (jBIterable == null) {
            MetaModelImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<ObjectKind> getChildKinds(@NotNull ObjectKind kind) {
        ObjectKind adjusted;
        if (kind == null) {
            MetaModelImpl.$$$reportNull$$$0(6);
        }
        if ((adjusted = this.unaliased(kind)) == ObjectKind.BODY) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                MetaModelImpl.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(this.getKindCouples()).filterMap(p -> p.first == adjusted ? (ObjectKind)p.second : null);
        if (jBIterable == null) {
            MetaModelImpl.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getNamespaces() {
        Set<ObjectKind> set = this.namespaces;
        if (set == null) {
            MetaModelImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public JBIterable<List<ObjectKind>> getPathsToRoot(@NotNull ObjectKind kind) {
        if (kind == null) {
            MetaModelImpl.$$$reportNull$$$0(10);
        }
        JBIterable jBIterable = JBIterable.from((Iterable)this.paths.get((Object)this.unaliased(kind)));
        if (jBIterable == null) {
            MetaModelImpl.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @Nullable
    public ObjectKind findKind(@Nullable String code) {
        if (code == null) {
            return null;
        }
        if ((code = code.trim()).isEmpty()) {
            return null;
        }
        return this.objectKinds.get(code);
    }

    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) {
        if (kind == null) {
            MetaModelImpl.$$$reportNull$$$0(12);
        }
        ObjectKind objectKind = (ObjectKind)ObjectUtils.chooseNotNull((Object)this.aliases.get(kind), (Object)kind);
        if (objectKind == null) {
            MetaModelImpl.$$$reportNull$$$0(13);
        }
        return objectKind;
    }

    public String toString() {
        return this.objectKinds.values().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/MetaModelImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectClasses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectKinds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliases";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/MetaModelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindCouples";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootNamespaceKinds";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildKinds";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaces";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToRoot";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unaliased";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildKinds";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unaliased";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class MetaModelBuilder<T> {
        private final Set<Couple<ObjectKind>> a = ContainerUtil.newLinkedHashSet();
        private final Map<String, ObjectKind> b = ContainerUtil.newLinkedHashMap();
        private final Map<ObjectKind, ObjectKind> aliases = ContainerUtil.newLinkedHashMap();

        public MetaModelBuilder() {
            this.b.put("root", ObjectKind.ROOT);
        }

        public MetaModelBuilder<T> put(ObjectKind parent, ObjectKind child) {
            this.a.add((Couple<ObjectKind>)Couple.of((Object)parent, (Object)child));
            this.b.put(child.code(), child);
            return this;
        }

        public MetaModelBuilder<T> putAlias(ObjectKind alias, ObjectKind target2) {
            this.aliases.put(alias, target2);
            this.b.put(alias.code(), target2);
            return this;
        }

        public MetaModelImpl build() {
            return new MetaModelImpl(Collections.unmodifiableSet(this.a), Collections.unmodifiableMap(this.b), Collections.unmodifiableMap(this.aliases));
        }
    }
}

