/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ListMultiRef;
import com.intellij.database.util.DasUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicForeignKey
extends BasicConstraint,
BasicNamedElement,
DasForeignKey {
    default public boolean isReferencingAnotherSchema() {
        @Nullable BasicMajorObject majorObject = this.getMajorObject();
        if (majorObject == null) {
            return false;
        }
        BasicSchema mySchema = majorObject.getSchema();
        if (mySchema == null) {
            return false;
        }
        String refSchemaName = this.getRefSchemaName();
        if (refSchemaName == null) {
            return false;
        }
        return !refSchemaName.equals(mySchema.getName());
    }

    @Nullable
    default public String getRefSchemaName() {
        return null;
    }

    @Nullable
    default public BasicSchema getRefSchema() {
        @Nullable BasicMajorObject majorObject = this.getMajorObject();
        if (majorObject == null) {
            return null;
        }
        BasicSchema mySchema = majorObject.getSchema();
        String refSchemaName = this.getRefSchemaName();
        if (refSchemaName == null) {
            return mySchema;
        }
        return mySchema != null ? mySchema.getSibling(refSchemaName) : null;
    }

    @Nullable
    default public String getRefTableName() {
        return null;
    }

    @Nullable
    default public BasicTableOrView getRefTable() {
        String refTableName = this.getRefTableName();
        if (refTableName == null) {
            return null;
        }
        BasicSchema refSchema = this.getRefSchema();
        return refSchema != null ? refSchema.getTableOrView(refTableName) : null;
    }

    @Nullable
    default public String getRefKeyName() {
        return null;
    }

    @Nullable
    default public BasicKey getRefKey() {
        BasicTableOrView refTable = this.getRefTable();
        if (refTable == null) {
            return null;
        }
        String refKeyName = this.getRefKeyName();
        if (refKeyName != null && refKeyName.length() > 0) {
            return refTable.findChild(ObjectKind.KEY, refKeyName, BasicKey.class);
        }
        List<String> refColNames = this.getRefColNames();
        int n = refColNames.size();
        if (n > 0) {
            for (BasicKey basicKey : refTable.getKeys()) {
                List<String> keyColNames = basicKey.getColNames();
                if (!keyColNames.equals(refColNames)) continue;
                return basicKey;
            }
            return null;
        }
        return refTable.getPrimaryKey();
    }

    @NotNull
    default public List<String> getRefColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            BasicForeignKey.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends BasicLikeColumn> getRefCols() {
        List<String> refColNames = this.getRefColNames();
        if (refColNames.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicForeignKey.$$$reportNull$$$0(1);
            }
            return list;
        }
        BasicTableOrView refTable = this.getRefTable();
        if (refTable == null) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicForeignKey.$$$reportNull$$$0(2);
            }
            return list;
        }
        Family<@NotNull ? extends BasicElement> columns2 = refTable.familyOf(ObjectKind.COLUMN);
        if (columns2 == null) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicForeignKey.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (!1.$assertionsDisabled && !(columns2 instanceof NamingFamily)) {
            throw new AssertionError();
        }
        List list = ((NamingFamily)columns2).get(refColNames);
        if (list == null) {
            BasicForeignKey.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    default public CascadeRule getOnUpdate() {
        CascadeRule cascadeRule = CascadeRule.restrict;
        if (cascadeRule == null) {
            BasicForeignKey.$$$reportNull$$$0(5);
        }
        return cascadeRule;
    }

    @NotNull
    default public CascadeRule getOnDelete() {
        CascadeRule cascadeRule = CascadeRule.restrict;
        if (cascadeRule == null) {
            BasicForeignKey.$$$reportNull$$$0(6);
        }
        return cascadeRule;
    }

    @Override
    @NotNull
    default public Iterable<? extends BasicElement> getPredecessors() {
        BasicTableOrView refTable = this.getRefTable();
        BasicKey refKey = this.getRefKey();
        JBIterable jBIterable = JBIterable.of((Object[])new BasicElement[]{refTable, refKey}).filter(x -> x != null);
        if (jBIterable == null) {
            BasicForeignKey.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    default public MultiRef<? extends BasicLikeColumn> getRefColumns() {
        ListMultiRef<? extends BasicLikeColumn> listMultiRef = new ListMultiRef<BasicLikeColumn>(this.getRefCols());
        if (listMultiRef == null) {
            BasicForeignKey.$$$reportNull$$$0(8);
        }
        return listMultiRef;
    }

    @Deprecated
    default public String getRefTableSchema() {
        return this.getRefSchemaName();
    }

    @Deprecated
    default public String getRefTableCatalog() {
        BasicTableOrView refTable = this.getRefTable();
        return DasUtil.getCatalog((DasObject)refTable);
    }

    @Deprecated
    default public DasForeignKey.RuleAction getUpdateRule() {
        switch (this.getOnUpdate()) {
            case restrict: {
                return DasForeignKey.RuleAction.RESTRICT;
            }
            case set_null: {
                return DasForeignKey.RuleAction.SET_NULL;
            }
            case set_default: {
                return DasForeignKey.RuleAction.SET_DEFAULT;
            }
            case cascade: {
                return DasForeignKey.RuleAction.CASCADE;
            }
        }
        return DasForeignKey.RuleAction.NO_ACTION;
    }

    @Deprecated
    default public DasForeignKey.RuleAction getDeleteRule() {
        switch (this.getOnDelete()) {
            case restrict: {
                return DasForeignKey.RuleAction.RESTRICT;
            }
            case set_null: {
                return DasForeignKey.RuleAction.SET_NULL;
            }
            case set_default: {
                return DasForeignKey.RuleAction.SET_DEFAULT;
            }
            case cascade: {
                return DasForeignKey.RuleAction.CASCADE;
            }
        }
        return DasForeignKey.RuleAction.NO_ACTION;
    }

    @Deprecated
    default public DasForeignKey.Deferrability getDeferrability() {
        return this.isDeferrable() ? (this.isInitiallyDeferred() ? DasForeignKey.Deferrability.INITIALLY_DEFERRED : DasForeignKey.Deferrability.INITIALLY_IMMEDIATE) : DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/model/basic/BasicForeignKey";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefColNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefCols";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnUpdate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDelete";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefColumns";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

