/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.delta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.delta.ElementCreation;
import com.intellij.database.model.delta.ElementDelta;
import com.intellij.database.model.delta.ModelDelta;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u001a\"\u00020\f\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001cR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/model/delta/ModelCreation;", "Lcom/intellij/database/model/delta/ModelDelta;", "targetModel", "Lcom/intellij/database/model/basic/BasicModel;", "(Lcom/intellij/database/model/basic/BasicModel;)V", "deltas", "", "Lcom/intellij/database/model/delta/ElementCreation;", "getDeltas", "()Ljava/util/Set;", "sourceMap", "", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/delta/ElementDelta;", "getSourceMap", "()Ljava/util/Map;", "sourceModel", "getSourceModel", "()Lcom/intellij/database/model/basic/BasicModel;", "targetMap", "", "getTargetMap", "getTargetModel", "includeElements", "", "elements", "", "([Lcom/intellij/database/model/basic/BasicElement;)V", "", "database-model-api"})
public final class ModelCreation
extends ModelDelta {
    @Nullable
    private final BasicModel sourceModel;
    @NotNull
    private final BasicModel targetModel;
    @NotNull
    private final Set<ElementCreation> deltas;
    @NotNull
    private final Map<BasicElement, ElementDelta> sourceMap;
    @NotNull
    private final Map<BasicElement, ElementCreation> targetMap;

    @Override
    @Nullable
    public BasicModel getSourceModel() {
        return this.sourceModel;
    }

    @Override
    @NotNull
    public BasicModel getTargetModel() {
        return this.targetModel;
    }

    @NotNull
    public Set<ElementCreation> getDeltas() {
        return this.deltas;
    }

    @Override
    @NotNull
    public Map<BasicElement, ElementDelta> getSourceMap() {
        return this.sourceMap;
    }

    @NotNull
    public Map<BasicElement, ElementCreation> getTargetMap() {
        return this.targetMap;
    }

    public final void includeElements(BasicElement ... elements) {
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        List<BasicElement> list = Arrays.asList(Arrays.copyOf(elements, elements.length));
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(*elements)");
        this.includeElements((Iterable<? extends BasicElement>)list);
    }

    public final void includeElements(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        for (BasicElement basicElement : elements) {
            boolean bl;
            Map<BasicElement, ElementCreation> map2;
            boolean bl2 = Intrinsics.areEqual((Object)basicElement.getModel(), (Object)this.getTargetModel());
            if (_Assertions.ENABLED && !bl2) {
                map2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(map2));
            }
            Map<BasicElement, ElementCreation> map3 = this.getTargetMap();
            map2 = map3;
            boolean bl3 = bl = !map2.containsKey(basicElement);
            if (_Assertions.ENABLED && !bl) {
                map2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError(map2));
            }
            ElementCreation creation = new ElementCreation(basicElement);
            map2 = this.getDeltas();
            map2.add(creation);
            map2 = this.getTargetMap();
            ElementCreation elementCreation = creation;
            map2.put(basicElement, elementCreation);
        }
    }

    public ModelCreation(@NotNull BasicModel targetModel) {
        Intrinsics.checkParameterIsNotNull((Object)targetModel, (String)"targetModel");
        super(null);
        this.sourceMap = MapsKt.emptyMap();
        this.targetModel = targetModel;
        this.deltas = new LinkedHashSet();
        this.targetMap = new HashMap();
    }
}

