/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExplainPlanProvider {
    public static final ExtensionPointName<ExplainPlanProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.explainPlanProvider");
    public static final ExplainPlanProvider NULL_PROVIDER = new NullExplainPlanProvider();

    @NotNull
    public static List<ExplainPlanProvider> getProvidersFor(@Nullable LocalDataSource dataSource) {
        ArrayList res = ContainerUtil.newArrayList();
        if (dataSource != null && ApplicationManager.getApplication() != null) {
            for (ExplainPlanProvider provider : (ExplainPlanProvider[])Extensions.getExtensions(EP_NAME)) {
                if (!provider.isAvailableFor(dataSource)) continue;
                res.add(provider);
            }
        }
        Collections.sort(res, (o1, o2) -> {
            if (o1 == NULL_PROVIDER) {
                return o2 == o1 ? 0 : 1;
            }
            if (o2 == NULL_PROVIDER) {
                return -1;
            }
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        });
        ArrayList arrayList = res;
        if (arrayList == null) {
            ExplainPlanProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public static ExplainPlanProvider getDefaultProvider(@Nullable LocalDataSource dataSource) {
        ExplainPlanProvider explainPlanProvider = (ExplainPlanProvider)ObjectUtils.chooseNotNull((Object)ContainerUtil.getFirstItem(ExplainPlanProvider.getProvidersFor(dataSource)), (Object)NULL_PROVIDER);
        if (explainPlanProvider == null) {
            ExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return explainPlanProvider;
    }

    @NotNull
    public static ExplainPlanProvider getProviderByClassName(@Nullable String className) {
        if (StringUtil.isEmpty((String)className)) {
            ExplainPlanProvider explainPlanProvider = NULL_PROVIDER;
            if (explainPlanProvider == null) {
                ExplainPlanProvider.$$$reportNull$$$0(2);
            }
            return explainPlanProvider;
        }
        for (ExplainPlanProvider provider : (ExplainPlanProvider[])Extensions.getExtensions(EP_NAME)) {
            if (!provider.getClass().getCanonicalName().equals(className)) continue;
            ExplainPlanProvider explainPlanProvider = provider;
            if (explainPlanProvider == null) {
                ExplainPlanProvider.$$$reportNull$$$0(3);
            }
            return explainPlanProvider;
        }
        ExplainPlanProvider explainPlanProvider = NULL_PROVIDER;
        if (explainPlanProvider == null) {
            ExplainPlanProvider.$$$reportNull$$$0(4);
        }
        return explainPlanProvider;
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public ConfigurableUi<LocalDataSource> createOptionsComponent() {
        return null;
    }

    public abstract boolean isAvailableFor(@NotNull LocalDataSource var1);

    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model) {
        if (model == null) {
            ExplainPlanProvider.$$$reportNull$$$0(5);
        }
        ScriptModel<V> scriptModel = model;
        if (scriptModel == null) {
            ExplainPlanProvider.$$$reportNull$$$0(6);
        }
        return scriptModel;
    }

    @Nullable
    public abstract DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx var1, @NotNull Consumer<PlanModel> var2, @NotNull LocalDataSource var3, @NotNull String var4, boolean var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/ExplainPlanProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersFor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderByClassName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/ExplainPlanProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullExplainPlanProvider
    extends ExplainPlanProvider {
        private NullExplainPlanProvider() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("None" == null) {
                NullExplainPlanProvider.$$$reportNull$$$0(0);
            }
            return "None";
        }

        @Override
        public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                NullExplainPlanProvider.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        @Nullable
        public DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer, @NotNull LocalDataSource dataSource, @NotNull String statement, boolean run) {
            if (owner == null) {
                NullExplainPlanProvider.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                NullExplainPlanProvider.$$$reportNull$$$0(3);
            }
            if (dataSource == null) {
                NullExplainPlanProvider.$$$reportNull$$$0(4);
            }
            if (statement == null) {
                NullExplainPlanProvider.$$$reportNull$$$0(5);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/plan/ExplainPlanProvider$NullExplainPlanProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailableFor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createExplainRequest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

