/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dbimport.DbElementDnDTarget;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.DataGridDocumentationProvider;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbTableImpl
extends DbElementImpl<DasTable, DbElement>
implements DbTable {
    protected DbTableImpl(DbElement parent, DasTable delegate) {
        super(parent, delegate);
        this.putUserData(DatabaseDataKeys.DND_TARGET_KEY, new DbElementDnDTarget.DbTableDnDTarget(this));
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        DdlBuilder.Colored colored = this.createDocHeaderColored();
        StringBuilder sb = colored.cast(StringBuilder.class);
        boolean skipDDL = this.appendDefinition(sb);
        ObjectKind kind = this.getKind();
        if (kind != ObjectKind.SYNONYM && kind != ObjectKind.SEQUENCE && !skipDDL) {
            colored.plain("<br>").plain("<!-- async-doc-cut -->").plain("<code><pre>");
            colored.comment("auto-generated definition").newLine();
            colored.element((DasObject)this);
            colored.plain("</pre></code>");
        }
        if (DbImplUtil.isDataTable((DasTable)this) || !skipDDL && DatabaseEditorHelper.isRawDefinitionAvailable(this)) {
            this.scheduleAsyncDocumentationUpdate(sb, (out, conn) -> this.loadSlowDocumentationInner(skipDDL, out, conn));
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbTableImpl.$$$reportNull$$$0(0);
        }
        return stringBuilder;
    }

    @Override
    @NotNull
    protected StringBuilder createDocHeaderDefault() {
        StringBuilder sb = super.createDocHeaderDefault();
        this.appendAdditionalInfo(sb);
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DbTableImpl.$$$reportNull$$$0(1);
        }
        return stringBuilder;
    }

    private void appendAdditionalInfo(@NotNull StringBuilder b) {
        DasTable delegate;
        if (b == null) {
            DbTableImpl.$$$reportNull$$$0(2);
        }
        if ((delegate = (DasTable)this.getDelegate()) instanceof PostgresTable) {
            PostgresTable pgTable = (PostgresTable)delegate;
            if (!pgTable.getAncestorIds().isEmpty()) {
                List<PostgresTable> ancestors = PostgresModelFun.getAncestors(pgTable);
                DbTableImpl.appendPostgresInheritanceTables(b, ancestors, "Inherits ");
            }
            if (!pgTable.getSuccessorIds().isEmpty()) {
                Set<PostgresTable> successors = PostgresModelFun.getSuccessors(pgTable);
                DbTableImpl.appendPostgresInheritanceTables(b, successors, "Base for ");
            }
        }
    }

    private static void appendPostgresInheritanceTables(@NotNull StringBuilder b, @NotNull Collection<PostgresTable> tables, String tablesAlias) {
        if (b == null) {
            DbTableImpl.$$$reportNull$$$0(3);
        }
        if (tables == null) {
            DbTableImpl.$$$reportNull$$$0(4);
        }
        b.append("<br>").append(tablesAlias).append(' ');
        b.append(tables.size() >= 2 ? "tables: " : "table: ");
        boolean first = true;
        for (PostgresTable table : tables) {
            if (first) {
                first = false;
            } else {
                b.append(',').append(' ');
            }
            b.append("<b><tt>").append(table.getName()).append("</tt></b>");
        }
        b.append("<br>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSlowDocumentationInner(boolean skipDDL, @NotNull CharOut sb, @NotNull ConnectionProvider provider) throws Exception {
        if (sb == null) {
            DbTableImpl.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            DbTableImpl.$$$reportNull$$$0(6);
        }
        if (DbImplUtil.isDataTable((DasTable)this)) {
            Map<Object, Object> infoMap = Collections.emptyMap();
            try {
                infoMap = DbImplUtil.tryLoadTableInfo(provider, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!skipDDL && DatabaseEditorHelper.isRawDefinitionAvailable(this)) {
                sb.append("<b>Definition:</b><br><code><pre>");
                StringBuilder builder = new StringBuilder();
                DatabaseEditorHelper.loadDefinition(provider, this, builder);
                sb.append(DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtil.getSqlDialect(this), builder));
                sb.append("</pre></code><br>");
            }
            int previewRows = DatabaseSettings.getSettings().getPreviewRows();
            DdlBuilder builder = DbImplUtil.createSelectAllQuery((DasTable)this, DbImplUtil.getDatabaseDialect(this), (DatabaseSystem)this.getDataSource(), previewRows);
            String tableQuery = builder.getStatement();
            sb.append("<b>Rows:</b> ~").append(ObjectUtils.notNull((Object)infoMap.get("rows"), (Object)"0").toString()).append(DataGridDocumentationProvider.getCountCommand(false)).append("<br>");
            for (String string : infoMap.keySet()) {
                Object obj = infoMap.get(string);
                String s = obj == null ? null : String.valueOf(obj);
                if (StringUtil.isEmptyOrSpaces((String)s) || "rows".equals(string)) continue;
                sb.append("<b>" + string + ":</b> " + s + "<br>");
            }
            if (previewRows > 0) {
                sb.append("<br>");
                long curLength = sb.length();
                try {
                    if (provider.acquire()) {
                        DbImplUtil.tryLoadFirstNRows("<b>First %d rows:</b><br>", provider.getConnection(), tableQuery, sb, previewRows);
                    }
                }
                finally {
                    provider.release();
                }
                if (sb.length() == curLength) {
                    sb.append("<b>").append(StringUtil.capitalize((String)this.getTypeName())).append(" is empty</b><br>");
                }
            }
        }
    }

    public boolean isSystem() {
        return ((DasTable)this.myDelegate).isSystem();
    }

    public boolean isTemporary() {
        return ((DasTable)this.myDelegate).isTemporary();
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
        Set set = ((DasTable)this.myDelegate).getColumnAttrs(columnInfo instanceof DbColumn ? (DasColumn)((DbColumn)columnInfo).getDelegate() : columnInfo);
        if (set == null) {
            DbTableImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DbTableImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocHeaderDefault";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DbTableImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendAdditionalInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendPostgresInheritanceTables";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadSlowDocumentationInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

