/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.ui.table.JBTable;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTableWithResizableCells
extends JBTable {
    private static final int RESIZE_AREA_RADIUS = 3;
    private CellRectangle myResizingCellOrigin;
    private boolean myExpandableItemsHandlerState;

    public JBTableWithResizableCells(TableModel model, TableColumnModel columnModel) {
        super(model, columnModel);
    }

    protected void processMouseEvent(MouseEvent e) {
        this.preProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseEvent(e);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        this.preProcessMouseEvent(e);
        if (!e.isConsumed()) {
            super.processMouseMotionEvent(e);
        }
    }

    private void preProcessMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            return;
        }
        Point mouseLocation = e.getPoint();
        CellRectangle cellToResize = this.getCellToResize(mouseLocation);
        int eventId = e.getID();
        if (eventId == 506) {
            if (this.myResizingCellOrigin != null) {
                this.updateResizingCell(mouseLocation);
                e.consume();
            }
        } else if (eventId == 503 || eventId == 504 || eventId == 505) {
            this.updateCursor(cellToResize);
        } else if (eventId == 501) {
            if (cellToResize != null) {
                this.myExpandableItemsHandlerState = this.getExpandableItemsHandler().isEnabled();
                this.setExpandableItemsEnabled(false);
                this.myResizingCellOrigin = cellToResize;
                this.updateResizingCell(mouseLocation);
                e.consume();
            }
        } else if (eventId == 502 && this.myResizingCellOrigin != null) {
            this.setExpandableItemsEnabled(this.myExpandableItemsHandlerState);
            this.myResizingCellOrigin = null;
            e.consume();
        }
    }

    private void updateCursor(@Nullable CellRectangle cellToResize) {
        int newCursorType;
        int n = newCursorType = cellToResize != null || this.myResizingCellOrigin != null ? 1 : 0;
        if (this.getCursor().getType() != newCursorType) {
            this.setCursor(Cursor.getPredefinedCursor(newCursorType));
        }
    }

    private void updateResizingCell(@NotNull Point mouseLocation) {
        if (mouseLocation == null) {
            JBTableWithResizableCells.$$$reportNull$$$0(0);
        }
        int diffX = mouseLocation.x - this.myResizingCellOrigin.x - this.myResizingCellOrigin.width - 1;
        int diffY = mouseLocation.y - this.myResizingCellOrigin.y - this.myResizingCellOrigin.height - 1;
        int newWidth = this.myResizingCellOrigin.width + diffX;
        int newHeight = Math.max(this.getRowHeight(), this.myResizingCellOrigin.height + diffY);
        this.setRowHeight(this.myResizingCellOrigin.row, newHeight);
        this.getColumnModel().getColumn(this.myResizingCellOrigin.column).setPreferredWidth(newWidth);
    }

    @Nullable
    private CellRectangle getCellToResize(@NotNull Point mouseLocation) {
        Rectangle hoveredCell;
        if (mouseLocation == null) {
            JBTableWithResizableCells.$$$reportNull$$$0(1);
        }
        int row = this.rowAtPoint(mouseLocation);
        int column = this.columnAtPoint(mouseLocation);
        Rectangle rectangle = hoveredCell = row != -1 && column != -1 ? this.getCellRect(row, column, true) : null;
        if (hoveredCell == null) {
            return null;
        }
        if (column != 0 && mouseLocation.distance(hoveredCell.x, hoveredCell.y + hoveredCell.height - 1) < 3.0) {
            --column;
        } else if (row != 0 && mouseLocation.distance(hoveredCell.x + hoveredCell.width - 1, hoveredCell.y) < 3.0) {
            --row;
        } else if (column != 0 && row != 0 && mouseLocation.distance(hoveredCell.x, hoveredCell.y) < 3.0) {
            --row;
            --column;
        }
        Rectangle toResize = this.getCellRect(row, column, true);
        boolean inResizeArea = mouseLocation.distance(toResize.x + toResize.width - 1, toResize.y + toResize.height - 1) < 3.0;
        return inResizeArea ? new CellRectangle(row, column, toResize) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "mouseLocation";
        objectArray2[1] = "com/intellij/database/run/ui/grid/JBTableWithResizableCells";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateResizingCell";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCellToResize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CellRectangle
    extends Rectangle {
        public final int row;
        public final int column;

        public CellRectangle(int row, int column, Rectangle r) {
            super(r);
            this.row = row;
            this.column = column;
        }
    }
}

