/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTextRendererFactory
implements GridCellRendererFactory {
    @Override
    public boolean supportsDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    public boolean supportsColumn(@NotNull DataConsumer.Column column) {
        if (column == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    @NotNull
    public GridCellRenderer createRenderer(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(2);
        }
        TextRenderer textRenderer = new TextRenderer(grid);
        if (textRenderer == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(3);
        }
        return textRenderer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportsDialect";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsColumn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenderer";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class TextRenderer
    extends GridCellRenderer {
        private final Map<Object, String> myValueTextCache;
        private EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;

        public TextRenderer(@NotNull DataGrid grid) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(0);
            }
            super(grid);
            this.myValueTextCache = ContainerUtil.createConcurrentWeakKeySoftValueMap((int)10, (float)0.75f, (int)1, (TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
            new UiNotifyConnector((Component)grid.getComponent(), (Activatable)new Activatable.Adapter(){

                public void hideNotify() {
                    myValueTextCache.clear();
                }
            });
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
            if (row == null) {
                TextRenderer.$$$reportNull$$$0(1);
            }
            if (column == null) {
                TextRenderer.$$$reportNull$$$0(2);
            }
            return 1;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ModelIndex<DataConsumer.Row> rowIdx, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(3);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(4);
            }
            if (this.myComponent == null) {
                this.myComponent = new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(DataGridUtil.getProject(this.myGrid), null, false);
                this.myComponent.setBorder((Border)new JBEmptyBorder(0, 3, 0, 3));
            }
            EditorEx editor = this.myComponent.getEditor();
            this.configureEditor(editor);
            EditorColorsScheme scheme = editor.getColorsScheme();
            boolean selected = this.myGrid.getSelectionModel().isSelected(rowIdx, columnIdx);
            TextAttributesKey attributesKey = TextRenderer.getAttributesKey(value);
            TextAttributes attributes = !selected && attributesKey != null ? scheme.getAttributes(attributesKey) : null;
            String valueText = this.getValueText(columnIdx, value);
            this.myComponent.setText(valueText, attributes, selected);
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = this.myComponent;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(5);
            }
            return abbreviatingRendererComponent;
        }

        protected void configureEditor(@NotNull EditorEx editor) {
            EditorColorsScheme scheme;
            boolean schemeAlreadySet;
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(6);
            }
            boolean bl = schemeAlreadySet = (scheme = editor.getColorsScheme()) instanceof DelegateColorScheme && ((DelegateColorScheme)scheme).getDelegate() == this.myGrid.getColorsScheme() && scheme.getEditorFontSize() == this.myGrid.getPreferredFocusedComponent().getFont().getSize();
            if (schemeAlreadySet) {
                return;
            }
            EditorColorsScheme bounded = editor.createBoundColorSchemeDelegate((EditorColorsScheme)this.myGrid.getColorsScheme());
            bounded.setEditorFontSize(this.myGrid.getPreferredFocusedComponent().getFont().getSize());
            editor.setColorsScheme(bounded);
        }

        @NotNull
        private String getValueText(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value) {
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(7);
            }
            if (value == null || value instanceof ReservedCellValue) {
                String string = ((ReservedCellValue)((Object)ObjectUtils.notNull((Object)((Object)((ReservedCellValue)((Object)value))), (Object)((Object)ReservedCellValue.NULL)))).getDisplayName();
                if (string == null) {
                    TextRenderer.$$$reportNull$$$0(8);
                }
                return string;
            }
            String cachedText = this.myValueTextCache.get(value);
            if (cachedText != null) {
                String string = cachedText;
                if (string == null) {
                    TextRenderer.$$$reportNull$$$0(9);
                }
                return string;
            }
            DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)this.myGrid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx));
            String text2 = TextRenderer.getDisplayString(this.myGrid.getObjectFormatter().getPlainValue(value, column, (DatabaseDialect)DataGridUtil.getDatabaseDialect(this.myGrid)));
            this.myValueTextCache.put(value, text2);
            String string = text2;
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(10);
            }
            return string;
        }

        private static String getDisplayString(@NotNull String str) {
            int lineEnd;
            if (str == null) {
                TextRenderer.$$$reportNull$$$0(11);
            }
            if (DataGridUtil.isFailedToLoad(str) && (lineEnd = str.indexOf(10, "<failed to load>".length() + 1)) > -1) {
                str = str.substring("<failed to load>".length(), lineEnd).trim();
            }
            return TextRenderer.trimTrailingWhitespace(str);
        }

        private static String trimTrailingWhitespace(String s) {
            int end;
            for (end = s.length(); end > 0 && s.charAt(end - 1) <= ' '; --end) {
            }
            return s.substring(0, end);
        }

        @Override
        public void dispose() {
            if (this.myComponent != null) {
                Disposer.dispose((Disposable)this.myComponent);
            }
        }

        @Nullable
        private static TextAttributesKey getAttributesKey(@Nullable Object value) {
            if (value == null) {
                return DatabaseColors.GRID_NULL_VALUE;
            }
            if (value instanceof ObjectFormatter.ImageInfo) {
                return DatabaseColors.GRID_IMAGE_VALUE;
            }
            if (DataGridUtil.isFailedToLoad(value)) {
                return DatabaseColors.GRID_ERROR_VALUE;
            }
            if (value instanceof LobInfo.FileClobInfo || value instanceof LobInfo.FileBlobInfo) {
                return DatabaseColors.GRID_UPLOAD_VALUE;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "configureEditor";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getDisplayString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

