/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableChild;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.Key;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaExportHelper {
    private static final Key<Boolean> FK_PULLED_MARK = Key.create((String)"SchemaExportHelper.FK_PULLED_MARK");
    private final Map<DasObject, DeObject> myCache;
    private final DatabaseEditorContext myContext;
    private final SchemaExporters myExporter;
    private final DeModel myModel;
    private final DeObject.DeCopier myCopier;
    private final Set<DasObject> myLocked;

    @NotNull
    public DeObject.DeCopier getCopier() {
        DeObject.DeCopier deCopier = this.myCopier;
        if (deCopier == null) {
            SchemaExportHelper.$$$reportNull$$$0(0);
        }
        return deCopier;
    }

    public SchemaExportHelper(@NotNull SchemaExportHelper other) {
        if (other == null) {
            SchemaExportHelper.$$$reportNull$$$0(1);
        }
        this.myCache = ContainerUtil.newHashMap();
        this.myCopier = new DeObject.DeCopier(){

            @Override
            public <De extends DeObject> De copy(@Nullable De object, boolean child) {
                return SchemaExportHelper.this.export(object, child);
            }
        };
        this.myLocked = ContainerUtil.newHashSet();
        this.myContext = other.myContext;
        this.myExporter = other.myExporter;
        this.myModel = new DeModel(other.myModel, this);
    }

    public SchemaExportHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, @NotNull DasModel model) {
        if (exporter == null) {
            SchemaExportHelper.$$$reportNull$$$0(2);
        }
        if (context == null) {
            SchemaExportHelper.$$$reportNull$$$0(3);
        }
        if (model == null) {
            SchemaExportHelper.$$$reportNull$$$0(4);
        }
        this.myCache = ContainerUtil.newHashMap();
        this.myCopier = new /* invalid duplicate definition of identical inner class */;
        this.myLocked = ContainerUtil.newHashSet();
        this.myContext = context;
        this.myExporter = exporter;
        this.myModel = new DeModel(model, this);
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            SchemaExportHelper.$$$reportNull$$$0(5);
        }
        return databaseEditorContext;
    }

    @NotNull
    public SchemaExportHelper chained() {
        SchemaExportHelper schemaExportHelper = new SchemaExportHelper(this);
        if (schemaExportHelper == null) {
            SchemaExportHelper.$$$reportNull$$$0(6);
        }
        return schemaExportHelper;
    }

    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myModel;
        if (deModel == null) {
            SchemaExportHelper.$$$reportNull$$$0(7);
        }
        return deModel;
    }

    public boolean contains(@NotNull DasObject obj) {
        if (obj == null) {
            SchemaExportHelper.$$$reportNull$$$0(8);
        }
        return this.myCache.containsKey(obj);
    }

    public boolean canExport(@NotNull DasObject object) {
        if (object == null) {
            SchemaExportHelper.$$$reportNull$$$0(9);
        }
        return this.myExporter.get(object) != null;
    }

    @Contract(value="null,_ -> null; !null,_ -> !null")
    public <De extends DeObject> De export(@Nullable DasObject object, boolean withChildren) {
        if (object == null) {
            return null;
        }
        while (object instanceof DbElement) {
            object = (DasObject)ObjectUtils.notNull((Object)((DasObject)((DbElement)object).getDelegate()));
        }
        DeObject res = this.myCache.get(object);
        if (!(res == null || withChildren && res.lightExported)) {
            return (De)res;
        }
        SchemaExporters.Exporter<? extends DeObject, DasObject> exporter = this.myExporter.get(object);
        assert (exporter != null) : "No exporter for " + object.getClass().getName();
        if (res == null) {
            boolean wasFree = this.myLocked.add(object);
            assert (wasFree);
            assert (!(object instanceof DeObject) || ((DeObject)object).model != this.myModel);
            res = exporter.create(this, object);
            this.myLocked.remove(object);
            this.created(object, res);
            res.lightExported = true;
            exporter.lightExport(this, res, object);
            if (res.getParent() != null && res.getParent().lightExported) {
                res.getParent().addLightChild(res);
            }
        }
        if (withChildren && res.lightExported) {
            res.lightChildren = null;
            res.lightExported = false;
            exporter.exportChildren(this, res, object);
        }
        return (De)res;
    }

    protected void created(@NotNull DasObject object, @NotNull DeObject res) {
        if (object == null) {
            SchemaExportHelper.$$$reportNull$$$0(10);
        }
        if (res == null) {
            SchemaExportHelper.$$$reportNull$$$0(11);
        }
        this.myCache.put(object, res);
    }

    public <De extends DeObject> De exportDeep(@NotNull DasModel model, @NotNull DasObject object, boolean withChildren) {
        if (model == null) {
            SchemaExportHelper.$$$reportNull$$$0(12);
        }
        if (object == null) {
            SchemaExportHelper.$$$reportNull$$$0(13);
        }
        return (De)((DeObject)this.exportDeep(model, (Iterable<? extends DasObject>)JBIterable.of((Object)object), withChildren).first());
    }

    public <De extends DeObject> JBIterable<De> exportDeep(@NotNull DasModel model, @NotNull Iterable<? extends DasObject> objects, boolean withChildren) {
        JBIterable<De> unexported;
        if (model == null) {
            SchemaExportHelper.$$$reportNull$$$0(14);
        }
        if (objects == null) {
            SchemaExportHelper.$$$reportNull$$$0(15);
        }
        if (model == this.myModel) {
            return JBIterable.from(objects).map(f -> (DeObject)f);
        }
        DasModel subModel = this.myModel.getModel();
        if (subModel != model) {
            assert (subModel instanceof DeModel);
            unexported = ((DeModel)subModel).getExportHelper().exportDeep(model, objects, withChildren);
        } else {
            unexported = JBIterable.from(objects);
        }
        return unexported.map(object -> this.export((DasObject)object, withChildren));
    }

    public void pullDependencies(@Nullable DasObject baseTarget) {
        Object obj = this.export(baseTarget, false);
        DeTable target2 = (DeTable)ObjectUtils.tryCast(obj, DeTable.class);
        if (target2 == null) {
            DeTableChild child = (DeTableChild)ObjectUtils.tryCast(obj, DeTableChild.class);
            DeTable deTable = target2 = child == null ? null : child.table;
        }
        if (target2 == null) {
            return;
        }
        if (FK_PULLED_MARK.get(target2.flags) == Boolean.TRUE) {
            return;
        }
        target2.model.getExportedKeys(target2).size();
        FK_PULLED_MARK.set(target2.flags, (Object)Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaExportHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaExportHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "chained";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canExport";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "created";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "exportDeep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

