/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicMatView;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingOptionStatic;
import com.intellij.database.scripting.ScriptingTask;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/scripting/BaseEnableDisableGenerator;", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "actionWord", "", "getActionWord", "()Ljava/lang/String;", "generateCheck", "", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateEnableDisableForConstraint", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "generateEnableDisableForTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateForeignKey", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "generateTrigger", "database-scripting"})
public class BaseEnableDisableGenerator
extends AbstractCodeGenerator {
    @NotNull
    private final String actionWord;

    @NotNull
    public final String getActionWord() {
        return this.actionWord;
    }

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof BasicTable) {
            ObjectKind[] objectKindArray = new ObjectKind[5];
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"KEY");
            objectKindArray[0] = objectKind;
            ObjectKind objectKind2 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind2, (String)"FOREIGN_KEY");
            objectKindArray[1] = objectKind2;
            ObjectKind objectKind3 = ObjectKind.CHECK;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind3, (String)"CHECK");
            objectKindArray[2] = objectKind3;
            ObjectKind objectKind4 = ObjectKind.RULE;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind4, (String)"RULE");
            objectKindArray[3] = objectKind4;
            ObjectKind objectKind5 = ObjectKind.TRIGGER;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind5, (String)"TRIGGER");
            objectKindArray[4] = objectKind5;
            this.processInnerElements(element, objectKindArray);
        } else if (basicElement instanceof BasicMatView) {
            ObjectKind[] objectKindArray = new ObjectKind[5];
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"KEY");
            objectKindArray[0] = objectKind;
            ObjectKind objectKind6 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind6, (String)"FOREIGN_KEY");
            objectKindArray[1] = objectKind6;
            ObjectKind objectKind7 = ObjectKind.CHECK;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind7, (String)"CHECK");
            objectKindArray[2] = objectKind7;
            ObjectKind objectKind8 = ObjectKind.RULE;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind8, (String)"RULE");
            objectKindArray[3] = objectKind8;
            ObjectKind objectKind9 = ObjectKind.TRIGGER;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind9, (String)"TRIGGER");
            objectKindArray[4] = objectKind9;
            this.processInnerElements(element, objectKindArray);
        } else if (basicElement instanceof BasicView) {
            ObjectKind[] objectKindArray = new ObjectKind[5];
            ObjectKind objectKind = ObjectKind.KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"KEY");
            objectKindArray[0] = objectKind;
            ObjectKind objectKind10 = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind10, (String)"FOREIGN_KEY");
            objectKindArray[1] = objectKind10;
            ObjectKind objectKind11 = ObjectKind.CHECK;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind11, (String)"CHECK");
            objectKindArray[2] = objectKind11;
            ObjectKind objectKind12 = ObjectKind.RULE;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind12, (String)"RULE");
            objectKindArray[3] = objectKind12;
            ObjectKind objectKind13 = ObjectKind.TRIGGER;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectKind13, (String)"TRIGGER");
            objectKindArray[4] = objectKind13;
            this.processInnerElements(element, objectKindArray);
        } else if (basicElement instanceof BasicKey) {
            this.generateKey((BasicKey)element);
        } else if (basicElement instanceof BasicForeignKey) {
            this.generateForeignKey((BasicForeignKey)element);
        } else if (basicElement instanceof BasicCheck) {
            this.generateCheck((BasicCheck)element);
        } else if (basicElement instanceof BasicTrigger) {
            this.generateTrigger((BasicTrigger)element);
        }
    }

    protected void generateKey(@NotNull BasicKey key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        if (this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_KEYS).booleanValue() && !key2.isClustering()) {
            this.generateEnableDisableForConstraint(key2);
        }
    }

    protected void generateForeignKey(@NotNull BasicForeignKey fk) {
        Intrinsics.checkParameterIsNotNull((Object)fk, (String)"fk");
        if (this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_FOREIGN_KEYS).booleanValue()) {
            this.generateEnableDisableForConstraint(fk);
        }
    }

    protected void generateCheck(@NotNull BasicCheck check) {
        Intrinsics.checkParameterIsNotNull((Object)check, (String)"check");
        if (this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_CHECKS).booleanValue()) {
            this.generateEnableDisableForConstraint(check);
        }
    }

    protected void generateTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        if (this.getContext().getOptions().get(ScriptingOptionStatic.CONSIDER_TRIGGERS).booleanValue()) {
            this.generateEnableDisableForTrigger(trigger);
        }
    }

    protected void generateEnableDisableForTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        String triggerName = this.currentScopeName(trigger);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName){
            final /* synthetic */ BaseEnableDisableGenerator this$0;
            final /* synthetic */ String $triggerName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("alter trigger ", this.$triggerName, this.this$0.getActionWord());
            }
            {
                this.this$0 = baseEnableDisableGenerator;
                this.$triggerName = string;
                super(0);
            }
        }, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    protected void generateEnableDisableForConstraint(@NotNull BasicConstraint constraint) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
        BasicLikeTable basicLikeTable = constraint.getLikeTable();
        if (basicLikeTable == null) {
            return;
        }
        BasicLikeTable table = basicLikeTable;
        String tableName = this.currentScopeName(table);
        String string = constraint.getName();
        BaseEnableDisableGenerator this_$iv = this;
        String constraintName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, constraintName){
            final /* synthetic */ BaseEnableDisableGenerator this$0;
            final /* synthetic */ String $tableName;
            final /* synthetic */ String $constraintName;

            public final void invoke() {
                this.this$0.getBuilder().phrase("alter table", this.$tableName, this.this$0.getActionWord(), "constraint", this.$constraintName);
            }
            {
                this.this$0 = baseEnableDisableGenerator;
                this.$tableName = string;
                this.$constraintName = string2;
                super(0);
            }
        }, 3, null);
    }

    public BaseEnableDisableGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
        String string2 = this.getTask().name();
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        BaseEnableDisableGenerator baseEnableDisableGenerator = this;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        baseEnableDisableGenerator.actionWord = string = string4;
    }
}

