/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlModelBuilderUtils {
    private static final Logger LOG = Logger.getInstance(SqlModelBuilderUtils.class);

    public static short getSybaseNumber(DasObject obj) {
        if (obj instanceof SqlCreateProcedureStatement) {
            return SqlModelBuilderUtils.getSybaseNumber(obj.getName());
        }
        if (obj instanceof DasPositioned) {
            return ((DasPositioned)obj).getPosition();
        }
        return SqlModelBuilderUtils.getSybaseNumber(obj.getName());
    }

    public static short getSybaseNumber(String name) {
        Short num = SqlModelBuilderUtils.isNumber(name) ? SqlModelBuilderUtils.tryConvert(name) : null;
        return num == null ? (short)1 : num;
    }

    @Nullable
    public static Short tryConvert(@Nullable String sub) {
        if (sub == null) {
            return null;
        }
        try {
            return Short.valueOf(sub);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static boolean isNumber(@Nullable String s) {
        if (s == null) {
            return false;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (Character.isDigit(s.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static void hardWarning(@NotNull String message) {
        Application app;
        if (message == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()) == null || app.isUnitTestMode()) {
            throw new AssertionError((Object)message);
        }
        LOG.warn(message);
    }

    @Nullable
    public static String getSubName(@NotNull DasObject obj, @NotNull DatabaseFamilyId family) {
        if (obj == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(1);
        }
        if (family == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(2);
        }
        String name = obj.getName();
        if (obj instanceof BasicElement) {
            String id = obj instanceof BasicOverloadable ? ((BasicOverloadable)obj).identity(true) : null;
            return id == null || id.equals(name) ? null : id;
        }
        if (family.isSybase() && obj instanceof DasRoutine && ((DasRoutine)obj).getRoutineKind() == DasRoutine.Kind.PROCEDURE) {
            short pos = SqlModelBuilderUtils.getSybaseNumber(obj);
            return ModelUtil.calculateSybProcedureIdentity(pos);
        }
        if (!(obj instanceof DasRoutine)) {
            return null;
        }
        String id = SqlModelBuilderUtils.hasOverloads(family) ? ModelUtil.calculateRoutineIdentity(name, ((DasRoutine)obj).getArguments()) : null;
        return name.equals(id) ? null : id;
    }

    private static boolean hasOverloads(DatabaseFamilyId familyId) {
        return familyId.isDb2() || familyId.isDerby() || familyId == DatabaseFamilyId.UNKNOWN || familyId.isH2() || familyId.isHsqldb() || familyId.isMysql() || familyId.isPostgres();
    }

    @Nullable
    public static BasicModElement createObject(@NotNull BasicModElement parent, @NotNull String name, @Nullable String identity, @NotNull ObjectKind kind) {
        Object obj;
        Family family;
        if (parent == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(3);
        }
        if (name == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(4);
        }
        if (kind == null) {
            SqlModelBuilderUtils.$$$reportNull$$$0(5);
        }
        if ((family = parent.familyOf(kind)) == null) {
            return null;
        }
        if (family instanceof ModSingletonFamily) {
            obj = ((ModSingletonFamily)family).createOrGet();
        } else {
            obj = family.find(o -> {
                if (name == null) {
                    SqlModelBuilderUtils.$$$reportNull$$$0(6);
                }
                return name.equals(o.getName()) && (identity == null || identity.equals(o.identity()));
            });
            if (obj != null && !obj.isSyncPending() && StringUtil.isEmpty((String)name) && !(obj instanceof BasicNamespace)) {
                obj = null;
            }
            if (obj instanceof BasicOverloadable) {
                obj = null;
            }
            if (obj == null) {
                obj = family.createNewOne();
                if (obj instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)obj).setName(name);
                }
            } else {
                obj.resetSyncPending();
            }
        }
        return obj;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/scripting/SqlModelBuilderUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hardWarning";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSubName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$createObject$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

