/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.mysql;

import com.intellij.database.model.DataType;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mysql.MysqlArgument;
import com.intellij.database.model.mysql.MysqlCollation;
import com.intellij.database.model.mysql.MysqlKey;
import com.intellij.database.model.mysql.MysqlRoot;
import com.intellij.database.model.mysql.MysqlRoutine;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.mysql.MysqlTableColumn;
import com.intellij.database.model.mysql.MysqlTrigger;
import com.intellij.database.model.mysql.MysqlView;
import com.intellij.database.model.properties.MysqlColumnKind;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.scripting.HeaderFooter;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001e\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020)H\u0002J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110+2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0012\u0010-\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020.H\u0014J\u0012\u0010/\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u00100\u001a\u0002012\u0006\u0010\"\u001a\u000202H\u0014J\b\u00103\u001a\u00020\bH\u0014\u00a8\u00064"}, d2={"Lcom/intellij/database/scripting/mysql/MysqlCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "allowReferenceOnPrimaryKeyWithoutColumns", "", "argDataType", "", "arg", "Lcom/intellij/database/model/basic/BasicArgument;", "canGenerateHere", "locus", "Lcom/intellij/database/scripting/ScriptLocus;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "canQualify", "defaultCollationForCharset", "model", "Lcom/intellij/database/model/basic/BasicModel;", "name", "findCollation", "Lcom/intellij/database/model/mysql/MysqlCollation;", "generateColumnComment", "", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateElement", "generateRoutine", "routine", "Lcom/intellij/database/model/mysql/MysqlRoutine;", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicTableOrView;", "generateTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateView", "view", "Lcom/intellij/database/model/mysql/MysqlView;", "getSingleColumnElements", "", "makeColumnDefinition", "makeComputedColumnSpecification", "Lcom/intellij/database/model/basic/BasicTableOrViewColumn;", "makeNormalColumnSpecification", "makeTableHeaderFooter", "Lcom/intellij/database/scripting/HeaderFooter;", "Lcom/intellij/database/model/basic/BasicTable;", "shouldCollectColumnElements", "database-scripting"})
public final class MysqlCreatingGenerator
extends BaseCreatingGenerator {
    @Override
    protected boolean canQualify(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return !(element instanceof BasicIndex) && super.canQualify(element);
    }

    @Override
    @NotNull
    protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        BasicLikeTable basicLikeTable = column.getLikeTable();
        if (basicLikeTable == null) {
            return SetsKt.emptySet();
        }
        BasicLikeTable table = basicLikeTable;
        JBIterable jBIterable = table.getChildren().filter(BasicKey.class).filter((Condition)new Condition<BasicKey>(this, column){
            final /* synthetic */ MysqlCreatingGenerator this$0;
            final /* synthetic */ BasicLikeColumn $column;

            public final boolean value(BasicKey it) {
                BasicKey basicKey = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicKey, (String)"it");
                return MysqlCreatingGenerator.access$canCreateInColumn(this.this$0, basicKey) && it.isNameSurrogate() && it.getColNames().size() == 1 && Intrinsics.areEqual((Object)((String)CollectionsKt.first(it.getColNames())), (Object)this.$column.getName());
            }
            {
                this.this$0 = mysqlCreatingGenerator;
                this.$column = basicLikeColumn;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"table.children\n      .fi\u2026s.first() == column.name}");
        return (Iterable)jBIterable;
    }

    @Override
    protected boolean shouldCollectColumnElements() {
        return Intrinsics.areEqual((Object)((Object)this.getLocus()), (Object)((Object)ScriptLocus.IN_TABLE));
    }

    @Override
    protected boolean canGenerateHere(@NotNull ScriptLocus locus, @Nullable BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)locus), (String)"locus");
        if (Intrinsics.areEqual((Object)((Object)locus), (Object)((Object)ScriptLocus.IN_COLUMN)) && element instanceof MysqlKey && ((MysqlKey)element).isPrimary()) {
            MysqlTableColumn col;
            BasicNode basicNode;
            List<String> list = ((MysqlKey)element).getColNames();
            List<String> it = list;
            MysqlTableColumn mysqlTableColumn = it.size() != 1 ? null : ((basicNode = ((MysqlKey)element).getTable()) != null && (basicNode = basicNode.getColumns()) != null ? (MysqlTableColumn)basicNode.get(it.get(0)) : (col = null));
            if (col != null && col.isAutoInc()) {
                return true;
            }
        }
        return super.canGenerateHere(locus, element);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected String makeNormalColumnSpecification(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        String string = super.makeNormalColumnSpecification(column);
        if (string == null) {
            return null;
        }
        String s = string;
        if (column instanceof MysqlTableColumn) {
            if (((MysqlTableColumn)column).isAutoInc()) {
                s = s + " auto_increment";
            }
            if (((MysqlTableColumn)column).getOnUpdate() != null) {
                s = s + " on update " + ((MysqlTableColumn)column).getOnUpdate();
            }
            String collation = ((MysqlTableColumn)column).getCollation();
            String charSet = this.defaultCollationForCharset(this.getContext().getModel(), collation);
            if (charSet != null) {
                void $receiver$iv;
                void this_$iv;
                String string2 = charSet;
                MysqlCreatingGenerator mysqlCreatingGenerator = this;
                StringBuilder stringBuilder = new StringBuilder().append(s).append(" charset ");
                String string3 = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                s = stringBuilder.append(string3).toString();
            } else if (collation != null) {
                String $receiver$iv = collation;
                MysqlCreatingGenerator this_$iv = this;
                StringBuilder stringBuilder = new StringBuilder().append(s).append(" collate ");
                String string4 = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                s = stringBuilder.append(string4).toString();
            }
        }
        return s;
    }

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof MysqlView) {
            this.generateView((MysqlView)element);
        } else if (basicElement instanceof MysqlRoutine) {
            this.generateRoutine((MysqlRoutine)element);
        } else {
            super.generateElement(element);
        }
    }

    private final String argDataType(BasicArgument arg) {
        String string;
        if (arg == null) {
            string = "/*none*/";
        } else {
            DataType dataType = arg.getDataType();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"arg.dataType");
            string = this.script(dataType);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected HeaderFooter makeTableHeaderFooter(@NotNull BasicTable table) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        HeaderFooter hf = super.makeTableHeaderFooter(table);
        StringBuilder footer = new StringBuilder();
        if (table.getComment() != null) {
            StringBuilder stringBuilder = new StringBuilder().append(" comment ");
            String string = table.getComment();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            footer.append(stringBuilder.append(this.getSqlString(string)).toString());
        }
        if (table instanceof MysqlTable) {
            String string;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2;
            if (((MysqlTable)table).getEngine() != null) {
                void $receiver$iv;
                void this_$iv;
                StringBuilder stringBuilder3 = new StringBuilder().append(" engine=");
                String string2 = ((MysqlTable)table).getEngine();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = string2;
                object = this;
                stringBuilder2 = stringBuilder3;
                stringBuilder = footer;
                string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                stringBuilder.append(stringBuilder2.append(string).toString());
            }
            String collation = ((MysqlTable)table).getCollation();
            String charSet = this.defaultCollationForCharset(this.getContext().getModel(), collation);
            if (charSet != null) {
                void $receiver$iv;
                void this_$iv;
                String string4 = charSet;
                MysqlCreatingGenerator $i$f$getScr = this;
                stringBuilder2 = new StringBuilder().append(" charset=");
                stringBuilder = footer;
                string = AbstractCodeGenerator.access$getNaming$p((AbstractCodeGenerator)this_$iv).nameToScript((String)$receiver$iv);
                stringBuilder.append(stringBuilder2.append(string).toString());
            } else if (collation != null) {
                String $receiver$iv = collation;
                MysqlCreatingGenerator this_$iv = this;
                stringBuilder2 = new StringBuilder().append(" collate=");
                stringBuilder = footer;
                string = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript($receiver$iv);
                stringBuilder.append(stringBuilder2.append(string).toString());
            }
        }
        if (!((object = (CharSequence)footer).length() == 0)) {
            hf = new HeaderFooter(hf.getHeader(), footer.substring(1));
        }
        return hf;
    }

    private final MysqlCollation findCollation(BasicModel model, String name) {
        BasicNode basicNode;
        if (name == null) {
            return null;
        }
        BasicModel basicModel = model;
        BasicRoot basicRoot = basicModel != null ? basicModel.getRoot() : null;
        if (!(basicRoot instanceof MysqlRoot)) {
            basicRoot = null;
        }
        return (basicNode = (MysqlRoot)basicRoot) != null && (basicNode = basicNode.getCollations()) != null ? (MysqlCollation)basicNode.get(name) : null;
    }

    private final String defaultCollationForCharset(BasicModel model, String name) {
        MysqlCollation c = this.findCollation(model, name);
        return c != null && Intrinsics.areEqual((Object)c.getDefaultForCharset(), (Object)Boolean.TRUE) ? c.getCharset() : null;
    }

    @Override
    @Nullable
    protected String makeComputedColumnSpecification(@NotNull BasicTableOrViewColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        if (!(column instanceof MysqlTableColumn)) {
            return super.makeComputedColumnSpecification(column);
        }
        StringBuilder stringBuilder = new StringBuilder().append("");
        DataType dataType = ((MysqlTableColumn)column).getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"column.dataType");
        String res = stringBuilder.append(this.script(dataType)).append(" as (").append(((MysqlTableColumn)column).getDefault()).append(')').toString();
        if (Intrinsics.areEqual((Object)((Object)((MysqlTableColumn)column).getColumnKind()), (Object)((Object)MysqlColumnKind.GENERATED_STORED))) {
            res = res + " stored";
        }
        return res;
    }

    @Override
    @Nullable
    protected String makeColumnDefinition(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
        String definition = super.makeColumnDefinition(column);
        String columnComment = column.getComment();
        if (columnComment != null) {
            definition = Intrinsics.stringPlus((String)definition, (Object)(" comment " + this.getSqlString(columnComment)));
        }
        return definition;
    }

    @Override
    protected boolean allowReferenceOnPrimaryKeyWithoutColumns() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateRoutine(MysqlRoutine routine) {
        String string;
        String returns;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        boolean isFunction = routine.getReturnArgument() != null;
        Iterable iterable = $receiver$iv = routine.getArguments();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MysqlArgument it = (MysqlArgument)element$iv$iv;
            if (!(!it.getArgumentDirection().isReturnOrResult())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String params2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)((Function1)new Function1<MysqlArgument, String>(this, isFunction){
            final /* synthetic */ MysqlCreatingGenerator this$0;
            final /* synthetic */ boolean $isFunction;

            @NotNull
            public final String invoke(MysqlArgument p) {
                StringBuilder stringBuilder = new StringBuilder().append(this.$isFunction ? "" : p.getArgumentDirection().name() + " ").append("").append(MysqlCreatingGenerator.access$getScr$p(this.this$0, p.getName())).append(' ');
                DataType dataType = p.getDataType();
                Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"p.dataType");
                return stringBuilder.append(MysqlCreatingGenerator.access$script(this.this$0, dataType)).toString();
            }
            {
                this.this$0 = mysqlCreatingGenerator;
                this.$isFunction = bl;
                super(1);
            }
        }), (int)31, null);
        String routineType = isFunction ? "function" : "procedure";
        String string2 = returns = isFunction ? " returns " + this.argDataType(routine.getReturnArgument()) : "";
        if (routine.getComment() != null) {
            StringBuilder stringBuilder = new StringBuilder().append(" comment ");
            String string3 = routine.getComment();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            string = stringBuilder.append(this.getSqlString(string3)).toString();
        } else {
            string = "";
        }
        String comment = string;
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, routineType, routine, params2, returns, comment){
            final /* synthetic */ MysqlCreatingGenerator this$0;
            final /* synthetic */ String $routineType;
            final /* synthetic */ MysqlRoutine $routine;
            final /* synthetic */ String $params;
            final /* synthetic */ String $returns;
            final /* synthetic */ String $comment;

            public final void invoke() {
                CodeTextBuilder.append$default(MysqlCreatingGenerator.access$getBuilder$p(this.this$0), "create " + this.$routineType + ' ' + MysqlCreatingGenerator.access$currentScopeName(this.this$0, this.$routine) + " (" + this.$params + ')' + this.$returns + "" + this.$comment, null, false, 6, null);
                CompositeText compositeText = this.$routine.getSourceText();
                MysqlCreatingGenerator.access$getBuilder$p(this.this$0).append(compositeText != null ? compositeText.getContent() : null);
            }
            {
                this.this$0 = mysqlCreatingGenerator;
                this.$routineType = string;
                this.$routine = mysqlRoutine;
                this.$params = string2;
                this.$returns = string3;
                this.$comment = string4;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateTrigger(@NotNull BasicTrigger trigger) {
        Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
        if (!(trigger instanceof MysqlTrigger)) {
            super.generateTrigger(trigger);
            return;
        }
        String event = ((TrigEvent)CollectionsKt.first((Iterable)((MysqlTrigger)trigger).getEvents())).name();
        String turn = Intrinsics.areEqual((Object)((MysqlTrigger)trigger).getTurn(), (Object)TrigTurn.BEFORE_ROW) ? "before" : "after";
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger, turn, event){
            final /* synthetic */ MysqlCreatingGenerator this$0;
            final /* synthetic */ BasicTrigger $trigger;
            final /* synthetic */ String $turn;
            final /* synthetic */ String $event;

            public final void invoke() {
                MysqlTable mysqlTable = ((MysqlTrigger)this.$trigger).getTable();
                CodeTextBuilder.append$default(MysqlCreatingGenerator.access$getBuilder$p(this.this$0), "create trigger " + MysqlCreatingGenerator.access$currentScopeName(this.this$0, this.$trigger) + "\n             " + this.$turn + ' ' + this.$event + " on " + (mysqlTable != null ? MysqlCreatingGenerator.access$currentScopeName(this.this$0, mysqlTable) : null) + "\n             for each row", null, false, 6, null);
                CompositeText compositeText = ((MysqlTrigger)this.$trigger).getSourceText();
                MysqlCreatingGenerator.access$getBuilder$p(this.this$0).append(compositeText != null ? compositeText.getContent() : null);
            }
            {
                this.this$0 = mysqlCreatingGenerator;
                this.$trigger = basicTrigger;
                this.$turn = string;
                this.$event = string2;
                super(0);
            }
        }, 3, null);
    }

    private final void generateView(MysqlView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ MysqlCreatingGenerator this$0;
            final /* synthetic */ MysqlView $view;

            public final void invoke() {
                CodeTextBuilder.append$default(MysqlCreatingGenerator.access$getBuilder$p(this.this$0), "create view " + MysqlCreatingGenerator.access$currentScopeName(this.this$0, this.$view) + " as ", null, false, 6, null);
                CompositeText compositeText = this.$view.getSourceText();
                MysqlCreatingGenerator.access$getBuilder$p(this.this$0).append(compositeText != null ? compositeText.getContent() : null);
            }
            {
                this.this$0 = mysqlCreatingGenerator;
                this.$view = mysqlView;
                super(0);
            }
        }, 3, null);
    }

    @Override
    protected void generateTableComment(@NotNull BasicTableOrView table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
    }

    @Override
    protected void generateColumnComment(@NotNull BasicLikeColumn column) {
        Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
    }

    public MysqlCreatingGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
    }

    public static final /* synthetic */ boolean access$canCreateInColumn(MysqlCreatingGenerator $this, @NotNull BasicElement element) {
        return $this.canCreateInColumn(element);
    }

    @NotNull
    public static final /* synthetic */ String access$getScr$p(MysqlCreatingGenerator $this, @NotNull String $receiver) {
        return $this.getScr($receiver);
    }

    @NotNull
    public static final /* synthetic */ String access$script(MysqlCreatingGenerator $this, @NotNull DataType d) {
        return $this.script(d);
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(MysqlCreatingGenerator $this) {
        return $this.getBuilder();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(MysqlCreatingGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }
}

