/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting.sqlite;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.sqlite.SqliteIndex;
import com.intellij.database.model.sqlite.SqliteTable;
import com.intellij.database.model.sqlite.SqliteTrigger;
import com.intellij.database.model.sqlite.SqliteView;
import com.intellij.database.model.sqlite.SqliteVirtualTable;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseDropGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/scripting/sqlite/SqliteDropGenerator;", "Lcom/intellij/database/scripting/BaseDropGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateElement", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateIndex", "index", "Lcom/intellij/database/model/sqlite/SqliteIndex;", "generateSqliteTable", "table", "generateTable", "Lcom/intellij/database/model/sqlite/SqliteTable;", "generateTrigger", "trigger", "Lcom/intellij/database/model/sqlite/SqliteTrigger;", "generateView", "view", "Lcom/intellij/database/model/sqlite/SqliteView;", "Companion", "database-scripting"})
public final class SqliteDropGenerator
extends BaseDropGenerator {
    private static final Set<ObjectKind> SUPPORTED;
    public static final Companion Companion;

    @Override
    protected void generateElement(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicElement basicElement = element;
        if (basicElement instanceof SqliteTable) {
            this.generateTable((SqliteTable)element);
        } else if (basicElement instanceof SqliteVirtualTable) {
            this.generateSqliteTable(element);
        } else if (basicElement instanceof SqliteIndex) {
            this.generateIndex((SqliteIndex)element);
        } else if (basicElement instanceof SqliteTrigger) {
            this.generateTrigger((SqliteTrigger)element);
        } else if (basicElement instanceof SqliteView) {
            this.generateView((SqliteView)element);
        } else {
            this.unknownHowToDrop(element);
        }
    }

    private final void generateView(SqliteView view) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, view){
            final /* synthetic */ SqliteDropGenerator this$0;
            final /* synthetic */ SqliteView $view;

            public final void invoke() {
                SqliteDropGenerator.access$getBuilder$p(this.this$0).phrase("drop view", SqliteDropGenerator.access$ifExists(this.this$0), SqliteDropGenerator.access$currentScopeName(this.this$0, this.$view));
            }
            {
                this.this$0 = sqliteDropGenerator;
                this.$view = sqliteView;
                super(0);
            }
        }, 3, null);
    }

    private final void generateIndex(SqliteIndex index) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, index){
            final /* synthetic */ SqliteDropGenerator this$0;
            final /* synthetic */ SqliteIndex $index;

            public final void invoke() {
                SqliteDropGenerator.access$getBuilder$p(this.this$0).phrase("drop index", SqliteDropGenerator.access$ifExists(this.this$0), SqliteDropGenerator.access$currentScopeName(this.this$0, this.$index));
            }
            {
                this.this$0 = sqliteDropGenerator;
                this.$index = sqliteIndex;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTrigger(SqliteTrigger trigger) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
            final /* synthetic */ SqliteDropGenerator this$0;
            final /* synthetic */ SqliteTrigger $trigger;

            public final void invoke() {
                SqliteDropGenerator.access$getBuilder$p(this.this$0).phrase("drop trigger", SqliteDropGenerator.access$ifExists(this.this$0), SqliteDropGenerator.access$currentScopeName(this.this$0, this.$trigger));
            }
            {
                this.this$0 = sqliteDropGenerator;
                this.$trigger = sqliteTrigger;
                super(0);
            }
        }, 3, null);
    }

    private final void generateTable(SqliteTable table) {
        this.generateSqliteTable(table);
    }

    private final void generateSqliteTable(BasicElement table) {
        AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, table){
            final /* synthetic */ SqliteDropGenerator this$0;
            final /* synthetic */ BasicElement $table;

            public final void invoke() {
                SqliteDropGenerator.access$getBuilder$p(this.this$0).phrase("drop table", SqliteDropGenerator.access$ifExists(this.this$0), SqliteDropGenerator.access$currentScopeName(this.this$0, this.$table));
            }
            {
                this.this$0 = sqliteDropGenerator;
                this.$table = basicElement;
                super(0);
            }
        }, 3, null);
    }

    public SqliteDropGenerator(@NotNull ScriptingContext context, @NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        super(context, task);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED = SetsKt.setOf((Object[])new ObjectKind[]{ObjectKind.TABLE, ObjectKind.VIRTUAL_TABLE, ObjectKind.VIEW, ObjectKind.INDEX, ObjectKind.TRIGGER});
    }

    @NotNull
    public static final /* synthetic */ CodeTextBuilder access$getBuilder$p(SqliteDropGenerator $this) {
        return $this.getBuilder();
    }

    @Nullable
    public static final /* synthetic */ String access$ifExists(SqliteDropGenerator $this) {
        return $this.ifExists();
    }

    @NotNull
    public static final /* synthetic */ String access$currentScopeName(SqliteDropGenerator $this, @NotNull BasicElement $receiver) {
        return $this.currentScopeName($receiver);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rR\"\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/scripting/sqlite/SqliteDropGenerator$Companion;", "", "()V", "SUPPORTED", "", "Lcom/intellij/database/model/ObjectKind;", "kotlin.jvm.PlatformType", "getSUPPORTED", "()Ljava/util/Set;", "canDrop", "", "kind", "context", "", "database-scripting"})
    public static final class Companion {
        private final Set<ObjectKind> getSUPPORTED() {
            return SUPPORTED;
        }

        public final boolean canDrop(@NotNull ObjectKind kind, @NotNull Iterable<? extends ObjectKind> context) {
            Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            return this.getSUPPORTED().contains(kind);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

