/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DataViewsComponent
implements ConfigurableUi<DatabaseSettings> {
    private JPanel myPanel;
    private IntegerField myResultPageSizeTextField;
    private IntegerField myFilterHistorySizeField;
    private IntegerField myLobLengthLimitField;
    private IntegerField myPrefetchSizeTextField;
    private JBCheckBox mySubmitImmediatelyCheckBox;

    public DataViewsComponent() {
        this.$$$setupUI$$$();
    }

    public void reset(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(0);
        }
        this.myResultPageSizeTextField.setValue(Integer.valueOf(settings.getPageSize()));
        this.myFilterHistorySizeField.setValue(Integer.valueOf(settings.getFiltersHistorySize()));
        this.myLobLengthLimitField.setValue(Integer.valueOf(settings.getMaxLobLength()));
        this.myPrefetchSizeTextField.setValue(Integer.valueOf(settings.getPrefetchSize()));
        this.mySubmitImmediatelyCheckBox.setSelected(settings.isSubmitImmediately());
    }

    public boolean isModified(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(1);
        }
        if (settings.getPageSize() != this.myResultPageSizeTextField.getValue().intValue()) {
            return true;
        }
        if (settings.getFiltersHistorySize() != this.myFilterHistorySizeField.getValue().intValue()) {
            return true;
        }
        if (settings.getMaxLobLength() != this.myLobLengthLimitField.getValue().intValue()) {
            return true;
        }
        if (settings.getPrefetchSize() != this.myPrefetchSizeTextField.getValue().intValue()) {
            return true;
        }
        return settings.isSubmitImmediately() != this.mySubmitImmediatelyCheckBox.isSelected();
    }

    public void apply(@NotNull DatabaseSettings settings) throws ConfigurationException {
        if (settings == null) {
            DataViewsComponent.$$$reportNull$$$0(2);
        }
        this.myResultPageSizeTextField.validateContent();
        this.myFilterHistorySizeField.validateContent();
        this.myLobLengthLimitField.validateContent();
        this.myPrefetchSizeTextField.validateContent();
        settings.setPageSize(this.myResultPageSizeTextField.getValue());
        settings.setFiltersHistorySize(this.myFilterHistorySizeField.getValue());
        settings.setMaxLobLength(this.myLobLengthLimitField.getValue());
        settings.setPrefetchSize(this.myPrefetchSizeTextField.getValue());
        settings.setSubmitImmediately(this.mySubmitImmediatelyCheckBox.isSelected());
        DatabaseSettings.fireSettingsChanged();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DataViewsComponent.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myResultPageSizeTextField = DataViewsComponent.createIntegerField();
        this.myFilterHistorySizeField = DataViewsComponent.createIntegerField();
        this.myLobLengthLimitField = DataViewsComponent.createIntegerField();
        this.myPrefetchSizeTextField = DataViewsComponent.createIntegerField();
    }

    @NotNull
    private static IntegerField createIntegerField() {
        IntegerField integerField = new IntegerField(null, -1, Integer.MAX_VALUE);
        if (integerField == null) {
            DataViewsComponent.$$$reportNull$$$0(4);
        }
        return integerField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/settings/DataViewsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/settings/DataViewsComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntegerField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        IntegerField integerField = this.myResultPageSizeTextField;
        integerField.setColumns(6);
        integerField.setHorizontalAlignment(4);
        jPanel.add((Component)integerField, new GridConstraints(0, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Result set page size:");
        jBLabel.setDisplayedMnemonic('P');
        jBLabel.setDisplayedMnemonicIndex(11);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Filter history size:");
        jBLabel2.setDisplayedMnemonic('H');
        jBLabel2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField2 = this.myFilterHistorySizeField;
        integerField2.setColumns(6);
        integerField2.setHorizontalAlignment(4);
        jPanel.add((Component)integerField2, new GridConstraints(2, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Max LOB length (bytes):");
        jBLabel3.setDisplayedMnemonic('L');
        jBLabel3.setDisplayedMnemonicIndex(8);
        jBLabel3.setToolTipText("LOB values exceeding the limit will not be loaded and displayed");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField3 = this.myLobLengthLimitField;
        integerField3.setColumns(6);
        integerField3.setHorizontalAlignment(4);
        jPanel.add((Component)integerField3, new GridConstraints(3, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        IntegerField integerField4 = this.myPrefetchSizeTextField;
        integerField4.setColumns(6);
        integerField4.setHorizontalAlignment(4);
        jPanel.add((Component)integerField4, new GridConstraints(1, 1, 1, 1, 4, 0, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Result set prefetch size:");
        jBLabel4.setDisplayedMnemonic('F');
        jBLabel4.setDisplayedMnemonicIndex(14);
        jBLabel4.setToolTipText("Default number of rows to be preloaded by a jdbc driver when fetching a result set");
        jPanel.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySubmitImmediatelyCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Submit changes immediately");
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Data Modification");
        jPanel.add((Component)titledSeparator, new GridConstraints(4, 0, 1, 3, 0, 3, 6, 0, null, null, null));
        jBLabel.setLabelFor((Component)integerField);
        jBLabel2.setLabelFor((Component)integerField2);
        jBLabel3.setLabelFor((Component)integerField3);
        jBLabel4.setLabelFor((Component)integerField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

