/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.derby;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.vendors.DefinitionProviderImpl;
import com.intellij.util.PairConsumer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class DerbyDefinitionProvider
extends DefinitionProviderImpl {
    public static final DerbyDefinitionProvider INSTANCE = new DerbyDefinitionProvider();

    @Override
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW;
    }

    @Override
    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) throws Exception {
        if (objects == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            DerbyDefinitionProvider.$$$reportNull$$$0(3);
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT v.VIEWDEFINITION FROM sys.SYSVIEWS v JOIN sys.SYSTABLES t ON v.TABLEID = t.TABLEID JOIN sys.SYSSCHEMAS s ON s.SCHEMAID = t.SCHEMAID WHERE t.TABLENAME = ? AND s.SCHEMANAME = ?");){
            for (DasObject dasObject : objects) {
                statement.setString(1, dasObject.getName());
                statement.setString(2, DasUtil.getSchema((DasObject)dasObject));
                try {
                    ResultSet rs = statement.executeQuery();
                    Throwable throwable = null;
                    try {
                        consumer.consume((Object)dasObject, !rs.next() ? null : rs.getString(1));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (rs == null) continue;
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        rs.close();
                    }
                }
                catch (SQLException e) {
                    consumer.consume((Object)dasObject, (Object)e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/vendors/derby/DerbyDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

